/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.genai.util.MalformedGenAIResponseException;
import org.neo4j.genai.vector.VectorEncoding;

public final class JsonUtils {
    private static volatile ObjectMapper LAZY_OBJECT_MAPPER_INSTANCE;
    public static final TypeReference<float[]> TYPE_REF_FLOAT_VECTOR;
    public static final TypeReference<Map<String, Object>> TYPE_REF_MAP_STRING_OBJECT;
    public static final TypeReference<Map<String, Map<?, ?>>> TYPE_REF_MAP_STRING_MAP;

    public static Stream<VectorEncoding.BatchRow> parseResponse(String name, String topLevelKey, String[] properties, List<String> resources, InputStream inputStream, int[] nullIndexes) throws MalformedGenAIResponseException {
        JsonNode tree = JsonUtils.readTree(inputStream);
        JsonNode predictions = JsonUtils.getExpectedFrom(name, tree, topLevelKey);
        if (!predictions.isArray()) {
            throw new MalformedGenAIResponseException("Expected response to contain an array of embeddings");
        }
        if (predictions.size() != resources.size()) {
            throw new MalformedGenAIResponseException("Expected to receive %d embeddings; however got %d".formatted(resources.size(), predictions.size()));
        }
        MutableInt offset = new MutableInt();
        return IntStream.range(0, resources.size() + nullIndexes.length).mapToObj(index -> {
            VectorEncoding.BatchRow batchRow;
            block13: {
                if (Arrays.binarySearch(nullIndexes, index) >= 0) {
                    offset.increment();
                    return new VectorEncoding.BatchRow(index, null, null);
                }
                int offsetIndex = index - offset.intValue();
                JsonNode embedding = JsonUtils.getExpectedFrom(name, predictions.get(offsetIndex), properties);
                if (!embedding.isArray()) {
                    throw new MalformedGenAIResponseException("Expected embedding to be an array");
                }
                JsonParser parser = embedding.traverse((ObjectCodec)JsonUtils.getObjectMapper());
                try {
                    batchRow = new VectorEncoding.BatchRow(index, (String)resources.get(offsetIndex), (float[])parser.readValueAs(TYPE_REF_FLOAT_VECTOR));
                    if (parser == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new MalformedGenAIResponseException("Unexpected error occurred while parsing the embedding", e);
                        }
                    }
                    catch (Throwable throwable3) {
                        throw new RuntimeException(throwable3);
                    }
                }
                parser.close();
            }
            return batchRow;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = LAZY_OBJECT_MAPPER_INSTANCE;
        if (objectMapper != null) return objectMapper;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            objectMapper = LAZY_OBJECT_MAPPER_INSTANCE;
            if (objectMapper != null) return objectMapper;
            LAZY_OBJECT_MAPPER_INSTANCE = new ObjectMapper();
            return LAZY_OBJECT_MAPPER_INSTANCE;
        }
    }

    public static JsonNode readTree(InputStream inputStream) {
        try {
            return JsonUtils.getObjectMapper().readTree(inputStream);
        }
        catch (IOException e) {
            throw new MalformedGenAIResponseException("Unexpected error occurred while parsing the API response", e);
        }
    }

    public static <T> T readValue(InputStream inputStream, Class<T> type) {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(inputStream, type);
        }
        catch (IOException e) {
            throw new MalformedGenAIResponseException("Unexpected error occurred while parsing the API response", e);
        }
    }

    public static JsonNode getExpectedFrom(String provider, JsonNode json, String property) throws MalformedGenAIResponseException {
        try {
            if (!json.isObject()) {
                throw JsonUtils.isNotObjectNode("provided json node");
            }
            return json.required(property);
        }
        catch (IllegalArgumentException e) {
            throw JsonUtils.doesNotExist(provider, property, e);
        }
    }

    public static JsonNode getExpectedFrom(String provider, JsonNode json, String ... properties) throws MalformedGenAIResponseException {
        Object parent = "provided json node";
        for (String property : properties) {
            if (!json.isObject()) {
                throw JsonUtils.isNotObjectNode((String)parent);
            }
            json = JsonUtils.getExpectedFrom(provider, json, property);
            parent = "'" + property + "'";
        }
        return json;
    }

    private static MalformedGenAIResponseException isNotObjectNode(String parent) {
        return new MalformedGenAIResponseException("Expected %s to be an object".formatted(parent));
    }

    private static MalformedGenAIResponseException doesNotExist(String provider, String property, Throwable cause) {
        return new MalformedGenAIResponseException("'%s' is expected to exist in the response from %s".formatted(property, provider), cause);
    }

    private JsonUtils() {
    }

    static {
        TYPE_REF_FLOAT_VECTOR = new TypeReference<float[]>(){};
        TYPE_REF_MAP_STRING_OBJECT = new TypeReference<Map<String, Object>>(){};
        TYPE_REF_MAP_STRING_MAP = new TypeReference<Map<String, Map<?, ?>>>(){};
    }
}

