/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util.monitor;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.neo4j.genai.util.GenAIMonitor;
import org.neo4j.genai.util.monitor.Monitors;

class MonitorCache
implements Monitors.GlobalCache {
    private final Map<CacheKey, Object> monitors = new ConcurrentHashMap<CacheKey, Object>();

    MonitorCache() {
    }

    public <T extends GenAIMonitor> T getIfAbsentPut(String dbName, Class<T> type, Supplier<T> monitorSupplier) {
        return (T)((GenAIMonitor)this.monitors.computeIfAbsent(CacheKey.of(dbName, type), key -> monitorSupplier.get()));
    }

    public void removeMonitors(String dbName) {
        this.monitors.keySet().removeIf(key -> Objects.equals(key.databaseName(), dbName));
    }

    @Override
    public Map<?, ?> snapshot() {
        return Map.copyOf(this.monitors);
    }

    record CacheKey(String databaseName, String type) {
        static CacheKey of(String databaseName, Class<?> type) {
            return new CacheKey(databaseName, type.getCanonicalName());
        }
    }
}

