/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util.monitor;

import java.util.Map;
import org.neo4j.genai.ai.text.completion.TextCompletionCallCountersMonitor;
import org.neo4j.genai.dbs.VectorDatabaseCallCountersMonitor;
import org.neo4j.genai.util.GenAIMonitor;
import org.neo4j.genai.util.monitor.CachingMonitors;
import org.neo4j.genai.util.monitor.MonitorCache;
import org.neo4j.genai.vector.VectorEncodingCallCountersMonitor;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.util.VisibleForTesting;

public interface Monitors {
    public <T extends GenAIMonitor> T ofType(Class<T> var1);

    default public VectorDatabaseCallCountersMonitor vectorDb() {
        return this.ofType(VectorDatabaseCallCountersMonitor.class);
    }

    default public VectorEncodingCallCountersMonitor vectorEnc() {
        return this.ofType(VectorEncodingCallCountersMonitor.class);
    }

    default public TextCompletionCallCountersMonitor textCompletion() {
        return this.ofType(TextCompletionCallCountersMonitor.class);
    }

    @VisibleForTesting
    public static interface GlobalCache {
        public Map<?, ?> snapshot();
    }

    public static class MonitorExtension
    extends ExtensionFactory<Dependencies> {
        public MonitorExtension() {
            super(ExtensionType.GLOBAL, "gen-ai-plugin-monitors");
        }

        public Lifecycle newInstance(ExtensionContext context, final Dependencies dependencies) {
            return new LifecycleAdapter(this){

                public void init() {
                    final MonitorCache monitorCache = new MonitorCache();
                    dependencies.procedures().registerComponent(Monitors.class, ctx -> new CachingMonitors((Context)ctx, monitorCache), true);
                    dependencies.databaseEventListeners().registerDatabaseEventListener((DatabaseEventListener)new DatabaseEventListenerAdapter(this){

                        public void databaseShutdown(DatabaseEventContext eventContext) {
                            monitorCache.removeMonitors(eventContext.getDatabaseName());
                        }

                        public void databasePanic(DatabaseEventContext eventContext) {
                            monitorCache.removeMonitors(eventContext.getDatabaseName());
                        }
                    });
                }
            };
        }

        public static interface Dependencies {
            public GlobalProcedures procedures();

            public DatabaseEventListeners databaseEventListeners();
        }
    }
}

