/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util.provider;

import org.eclipse.collections.api.list.ImmutableList;
import org.neo4j.annotations.service.Service;

@Service
public interface NamedProvider {
    public String name();

    public Class<?> paramType();

    public static interface Lookup<PROVIDER extends NamedProvider, IMPLEMENTATION extends Implementation> {
        public ImmutableList<PROVIDER> providers();

        public IMPLEMENTATION implementation(PROVIDER var1);

        default public IMPLEMENTATION byName(String name) {
            for (NamedProvider provider : this.providers()) {
                if (String.CASE_INSENSITIVE_ORDER.compare(provider.name(), name) != 0) continue;
                return this.implementation(provider);
            }
            throw new RuntimeException("Provider not supported: %s".formatted(name));
        }
    }

    public static interface Implementation {
        public String name();
    }
}

