/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util.provider;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MutableMap;
import org.neo4j.genai.util.Parameters;
import org.neo4j.genai.util.provider.NamedProvider;
import org.neo4j.genai.vector.VectorEncoding;
import org.neo4j.procedure.Description;

public record ProviderRow(@Description(value="Provider name.") String name, @Description(value="The signature of the required config map.") String requiredConfigType, @Description(value="The signature of the optional config map.") String optionalConfigType, @Description(value="The default values for the GenAI provider.") Map<String, Object> defaultConfig) {
    public static VectorEncoding.ProviderRow from(NamedProvider provider) {
        List<Parameters.Parameter> parameters = Parameters.getParameters(provider.paramType());
        return new VectorEncoding.ProviderRow(provider.name(), ProviderRow.requiredConfigType(parameters), ProviderRow.optionalConfigType(parameters), ProviderRow.defaultConfig(parameters));
    }

    private static String requiredConfigType(List<Parameters.Parameter> parameters) {
        return ProviderRow.cypherMapType(parameters.stream().filter(Parameters.Parameter::isRequired));
    }

    private static String optionalConfigType(List<Parameters.Parameter> parameters) {
        return ProviderRow.cypherMapType(parameters.stream().filter(Parameters.Parameter::isOptional));
    }

    private static String cypherMapType(Stream<Parameters.Parameter> parameters) {
        return parameters.map(p -> "%s :: %s".formatted(p.name(), p.type().cypherName())).collect(Collectors.joining(", ", "{ ", " }"));
    }

    private static Map<String, Object> defaultConfig(List<Parameters.Parameter> parameters) {
        MutableMap defaults = Maps.mutable.empty();
        for (Parameters.Parameter parameter : parameters) {
            Object defaultValue = parameter.defaultValue();
            if (defaultValue == null) continue;
            if (defaultValue instanceof Optional) {
                Optional optionalDefaultValue = (Optional)defaultValue;
                optionalDefaultValue.ifPresent(o -> defaults.put((Object)parameter.name(), o));
                continue;
            }
            if (defaultValue instanceof OptionalLong) {
                OptionalLong optionalDefaultValue = (OptionalLong)defaultValue;
                optionalDefaultValue.ifPresent(o -> defaults.put((Object)parameter.name(), (Object)o));
                continue;
            }
            if (defaultValue instanceof OptionalDouble) {
                OptionalDouble optionalDefaultValue = (OptionalDouble)defaultValue;
                optionalDefaultValue.ifPresent(o -> defaults.put((Object)parameter.name(), (Object)o));
                continue;
            }
            defaults.put((Object)parameter.name(), defaultValue);
        }
        return defaults.asUnmodifiable();
    }
}

