/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.vector.providers;

import java.net.URI;
import java.net.http.HttpRequest;
import java.util.Map;
import java.util.OptionalLong;
import java.util.regex.Pattern;
import org.apache.commons.text.StringSubstitutor;
import org.neo4j.genai.vector.VectorEncoding;
import org.neo4j.genai.vector.providers.openai.OpenAIBasedEncoder;

public final class AzureOpenAI
implements VectorEncoding.Provider<Parameters> {
    public static final String NAME = "AzureOpenAI";
    public static final String ENDPOINT_TEMPLATE = "https://${resource}.openai.azure.com/openai/deployments/${deployment}/embeddings?api-version=2023-05-15";
    private static final Pattern RESOURCE_PATTERN = Pattern.compile("^\\p{Alnum}[\\p{Alnum}-]{0,62}\\p{Alnum}$");
    private static final Pattern DEPLOYMENT_PATTERN = Pattern.compile("^[\\p{Alnum}_-]{1,63}\\p{Alnum}$");

    @Override
    public Class<Parameters> parameterDeclarations() {
        return Parameters.class;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public VectorEncoding.Provider.Encoder configure(Parameters configuration) {
        URI endpoint = AzureOpenAI.configureEndpoint(configuration);
        return new Encoder(endpoint, configuration);
    }

    private static URI configureEndpoint(Parameters config) {
        AzureOpenAI.validateResourceName(config.resource);
        AzureOpenAI.validateDeploymentName(config.deployment);
        return URI.create(StringSubstitutor.replace((Object)ENDPOINT_TEMPLATE, Map.of("resource", config.resource, "deployment", config.deployment)));
    }

    private static void validateResourceName(String name) {
        if (!RESOURCE_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Provided resource '%s' is invalid. It must consist of 2-64 alphanumerical characters or hyphens, and cannot start or end on a hyphen.".formatted(name));
        }
    }

    private static void validateDeploymentName(String name) {
        if (!DEPLOYMENT_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Provided deployment '%s' is invalid. It must consist of 2-64 alphanumerical characters, hyphens, or underscores, and cannot end on a hyphen or underscore.".formatted(name));
        }
    }

    public static class Parameters {
        public String token;
        public String resource;
        public String deployment;
        public OptionalLong dimensions;
    }

    static class Encoder
    extends OpenAIBasedEncoder {
        private final Parameters configuration;

        Encoder(URI endpoint, Parameters configuration) {
            super(AzureOpenAI.NAME, endpoint, configuration.dimensions);
            this.configuration = configuration;
        }

        @Override
        protected HttpRequest.Builder customize(HttpRequest.Builder builder) {
            return builder.setHeader("api-key", this.configuration.token);
        }
    }
}

