/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchimport.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntFunction;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.batchimport.api.DetailedProgressReport;
import org.neo4j.batchimport.api.input.ApplicationMode;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.SchemaUserDescription;

public class DetailedProgressReportBase {
    private final MutableStats nodeStats = new MutableStats();
    private final MutableStats relationshipStats = new MutableStats();
    private final PerTokenMutableStats perLabelStats = new PerTokenMutableStats();
    private final PerTokenMutableStats perRelationshipTypeStats = new PerTokenMutableStats();
    private final MutableStats indexStats = new MutableStats();
    private final MutableStats constraintStats = new MutableStats();
    private final Timer schemaTimer = new Timer();
    private final Timer nodeTimer = new Timer();
    private final Timer relationshipTimer = new Timer();
    private final boolean trackPerEntityTokenStats;
    private volatile TokenNameLookup tokenNameLookup = SchemaUserDescription.TOKEN_ID_NAME_LOOKUP;

    public DetailedProgressReportBase(boolean trackPerEntityTokenStats) {
        this.trackPerEntityTokenStats = trackPerEntityTokenStats;
    }

    public void setTokenNameLookup(TokenNameLookup tokenNameLookup) {
        this.tokenNameLookup = tokenNameLookup;
    }

    public MutableStats nodeStats() {
        return this.nodeStats;
    }

    public MutableStats relationshipStats() {
        return this.relationshipStats;
    }

    public MutableStats indexStats() {
        return this.indexStats;
    }

    public MutableStats constraintStats() {
        return this.constraintStats;
    }

    public Timer schemaTimer() {
        return this.schemaTimer;
    }

    public Timer nodeTimer() {
        return this.nodeTimer;
    }

    public Timer relationshipTimer() {
        return this.relationshipTimer;
    }

    public void registerNodeStats(ApplicationMode applicationMode, IntSet ... entityTokens) {
        this.nodeStats.register(applicationMode);
        if (this.trackPerEntityTokenStats) {
            this.perLabelStats.register(applicationMode, entityTokens);
        }
    }

    public void registerRelationshipStats(ApplicationMode applicationMode, int relationshipType) {
        this.relationshipStats.register(applicationMode);
        if (this.trackPerEntityTokenStats) {
            this.perRelationshipTypeStats.register(applicationMode, relationshipType);
        }
    }

    public DetailedProgressReport snapshot() {
        return new DetailedProgressReport(this.nodeStats.snapshot(), this.relationshipStats.snapshot(), this.perLabelStats.snapshot(arg_0 -> ((TokenNameLookup)this.tokenNameLookup).labelGetName(arg_0)), this.perRelationshipTypeStats.snapshot(arg_0 -> ((TokenNameLookup)this.tokenNameLookup).relationshipTypeGetName(arg_0)), this.indexStats.snapshot(), this.constraintStats.snapshot(), this.nodeTimer.snapshot(), this.relationshipTimer.snapshot(), this.schemaTimer.snapshot());
    }

    public record MutableStats(LongAdder numProcessed, LongAdder numCreated, LongAdder numUpdated, LongAdder numDeleted) {
        public MutableStats() {
            this(new LongAdder(), new LongAdder(), new LongAdder(), new LongAdder());
        }

        public DetailedProgressReport.Stats snapshot() {
            return new DetailedProgressReport.Stats(this.numProcessed.longValue(), this.numCreated.longValue(), this.numUpdated.longValue(), this.numDeleted.longValue());
        }

        public void register(ApplicationMode applicationMode) {
            switch (applicationMode) {
                case CREATE: {
                    this.numCreated.increment();
                    break;
                }
                case UPDATE: {
                    this.numUpdated.increment();
                    break;
                }
                case DELETE: {
                    this.numDeleted.increment();
                }
            }
        }
    }

    public static class PerTokenMutableStats {
        private final MutableStats[] lowIdStats = new MutableStats[100];
        private final Map<Integer, MutableStats> higherIdStats = new ConcurrentHashMap<Integer, MutableStats>();

        PerTokenMutableStats() {
            for (int tokenId = 0; tokenId < this.lowIdStats.length; ++tokenId) {
                this.lowIdStats[tokenId] = new MutableStats();
            }
        }

        private void register(ApplicationMode applicationMode, IntSet ... entityTokens) {
            for (IntSet tokens : entityTokens) {
                tokens.forEach((IntProcedure & Serializable)tokenId -> {
                    MutableStats stats = this.forToken(tokenId);
                    stats.numProcessed.increment();
                    stats.register(applicationMode);
                });
            }
        }

        private void register(ApplicationMode applicationMode, int entityTokenId) {
            MutableStats stats = this.forToken(entityTokenId);
            stats.numProcessed.increment();
            stats.register(applicationMode);
        }

        private Map<String, DetailedProgressReport.Stats> snapshot(IntFunction<String> tokenNameLookup) {
            HashMap<String, DetailedProgressReport.Stats> snapshot = new HashMap<String, DetailedProgressReport.Stats>();
            for (int tokenId2 = 0; tokenId2 < this.lowIdStats.length; ++tokenId2) {
                MutableStats stats = this.lowIdStats[tokenId2];
                if (stats.numProcessed.sum() <= 0L) continue;
                snapshot.put(tokenNameLookup.apply(tokenId2), stats.snapshot());
            }
            this.higherIdStats.forEach((tokenId, mutableStats) -> snapshot.put((String)tokenNameLookup.apply((int)tokenId), mutableStats.snapshot()));
            return snapshot;
        }

        private MutableStats forToken(int tokenId) {
            return tokenId < this.lowIdStats.length ? this.lowIdStats[tokenId] : this.higherIdStats.computeIfAbsent(tokenId, k -> new MutableStats());
        }
    }

    public static class Timer {
        private volatile long start;
        private volatile long end;

        public void start() {
            this.start = System.nanoTime();
        }

        public void end() {
            this.end = System.nanoTime();
        }

        public Duration snapshot() {
            long start = this.start;
            if (start == 0L) {
                return Duration.ZERO;
            }
            long end = this.end;
            if (end == 0L) {
                end = System.nanoTime();
            }
            return Duration.ofNanos(end - start);
        }
    }
}

