/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.importer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.ast.GraphSelection;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.Statements;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckContext;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.notification.InternalNotificationLogger;
import org.neo4j.cypher.internal.notification.devNullLogger$;
import org.neo4j.cypher.internal.parser.AstParserFactory$;
import org.neo4j.cypher.internal.preparser.PreParsedQuery;
import org.neo4j.cypher.internal.util.CypherExceptionFactory;
import org.neo4j.cypher.internal.util.ErrorMessageProvider;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.Neo4jCypherExceptionFactory;
import org.neo4j.cypher.internal.util.NotImplementedErrorMessageProvider$;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.importer.SchemaCommandsBuilder;
import org.neo4j.internal.schema.SchemaCommand;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import scala.Option;
import scala.jdk.CollectionConverters;

public class SchemaCommandReader {
    private static final InternalNotificationLogger NOTIFICATION_LOGGER = devNullLogger$.MODULE$;
    private final FileSystemAbstraction fileSystem;
    private final ReaderConfig readerConfig;
    private final PreParser preParser;

    public SchemaCommandReader(FileSystemAbstraction fileSystem, Config config, ReaderConfig readerConfig) {
        this.fileSystem = Objects.requireNonNull(fileSystem);
        this.preParser = new PreParser(CypherConfiguration.fromConfig((Config)Objects.requireNonNull(config)));
        this.readerConfig = Objects.requireNonNull(readerConfig);
    }

    public List<SchemaCommand> parse(Path cypherPath) throws SchemaCommand.SchemaCommandReaderException {
        String cypherText = this.parseFile(cypherPath);
        if (cypherText.isEmpty()) {
            return List.of();
        }
        return this.parse(cypherText);
    }

    public List<SchemaCommand> parse(String cypherText) {
        PreParsedQuery preParsedQuery = this.preParser.preParse(cypherText);
        CypherVersion cypherVersion = preParsedQuery.resolvedLanguage();
        Neo4jCypherExceptionFactory exceptionFactory = new Neo4jCypherExceptionFactory(cypherText, Option.apply((Object)preParsedQuery.options().offset()));
        List semanticFeatures = List.of();
        Statements statements = AstParserFactory$.MODULE$.apply(cypherVersion).apply(preParsedQuery.statement(), (CypherExceptionFactory)exceptionFactory, Option.apply((Object)NOTIFICATION_LOGGER), CollectionConverters.CollectionHasAsScala(semanticFeatures).asScala().toSeq()).statements();
        SchemaCommandsBuilder changesBuilder = new SchemaCommandsBuilder(this.readerConfig, cypherVersion);
        MutableList errors = Lists.mutable.empty();
        SemanticCheckContext checkContext = SemanticCheckContext.apply((CypherVersion)cypherVersion, (ErrorMessageProvider)NotImplementedErrorMessageProvider$.MODULE$);
        int length = statements.size();
        for (int i = 0; i < length; ++i) {
            this.transform(changesBuilder, statements.get(i), (MutableList<String>)errors, checkContext);
        }
        if (errors.isEmpty()) {
            return changesBuilder.build();
        }
        errors.addFirst((Object)"Unable to parse the Cypher in import change commands.");
        throw new SchemaCommand.SchemaCommandReaderException(String.join((CharSequence)System.lineSeparator(), (Iterable<? extends CharSequence>)errors));
    }

    private String parseFile(Path cypherPath) throws SchemaCommand.SchemaCommandReaderException {
        Preconditions.checkState((cypherPath != null && this.fileSystem.fileExists(cypherPath) ? 1 : 0) != 0, (String)"The path to the Cypher schema commands must exist");
        try {
            return FileSystemUtils.readString((FileSystemAbstraction)this.fileSystem, (Path)cypherPath, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        catch (IOException ex) {
            throw new SchemaCommand.SchemaCommandReaderException("Unable to read Cypher statement(s) in " + String.valueOf(cypherPath), (Throwable)ex);
        }
    }

    private void transform(SchemaCommandsBuilder changesBuilder, Statement statement, MutableList<String> errors, SemanticCheckContext checkContext) throws SchemaCommand.SchemaCommandReaderException {
        if (statement instanceof org.neo4j.cypher.internal.ast.SchemaCommand) {
            org.neo4j.cypher.internal.ast.SchemaCommand command = (org.neo4j.cypher.internal.ast.SchemaCommand)statement;
            if (command.useGraph().isEmpty()) {
                if (SchemaCommandReader.checkStatement(statement, errors, checkContext)) {
                    changesBuilder.withCommand(command);
                }
            } else {
                errors.add((Object)SchemaCommandReader.errorMessage(statement.position(), "Schema commands are only applied to the database to be imported into so graph names are not allowed: " + ((GraphSelection)command.useGraph().get()).graphReference().print()));
            }
        } else {
            errors.add((Object)SchemaCommandReader.errorMessage(statement.position(), "Only schema change clauses are allowed here but found: " + statement.getClass().getSimpleName()));
        }
    }

    private static boolean checkStatement(Statement statement, MutableList<String> errors, SemanticCheckContext checkContext) throws SchemaCommand.SchemaCommandReaderException {
        SemanticCheckResult checkResult = statement.semanticCheck().run(SemanticState.clean(), checkContext);
        if (!checkResult.errors().isEmpty()) {
            checkResult.errors().foreach(error -> errors.add((Object)SchemaCommandReader.errorMessage(error.position(), error.msg())));
            return false;
        }
        return true;
    }

    private static String errorMessage(InputPosition position, String message) {
        return "Problem on line %d, column %d: %s".formatted(position.line(), position.column(), message);
    }

    public record ReaderConfig(boolean allowEnterpriseFeatures, boolean allowConstraints, boolean allowDropOperations, VectorIndexVersion latestVectorIndexVersion) {
        public static ReaderConfig defaults() {
            return new ReaderConfig(false, false, false, VectorIndexVersion.latestSupportedVersion((KernelVersion)KernelVersion.getLatestVersion((Configuration)Config.defaults())));
        }
    }
}

