/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.common.DependencyResolver;
import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;
import org.neo4j.index.internal.gbptree.InternalNodeDynamicSize;
import org.neo4j.index.internal.gbptree.InternalNodeFixedSize;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeBehaviour;
import org.neo4j.index.internal.gbptree.LeafNodeDynamicSize;
import org.neo4j.index.internal.gbptree.LeafNodeFixedSize;
import org.neo4j.index.internal.gbptree.OffloadStore;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;

public class DefaultTreeNodeSelector {
    private static final TreeNodeSelector.Factory FIXED = new TreeNodeSelector.Factory(){
        static final byte FORMAT_IDENTIFIER = 2;
        static final byte FORMAT_VERSION = 0;

        @Override
        public <KEY, VALUE> LeafNodeBehaviour<KEY, VALUE> createLeafBehaviour(int payloadSize, Layout<KEY, VALUE> layout, OffloadStore<KEY, VALUE> offloadStore, DependencyResolver dependencyResolver) {
            return new LeafNodeFixedSize<KEY, VALUE>(payloadSize, layout);
        }

        @Override
        public <KEY, VALUE> InternalNodeBehaviour<KEY> createInternalBehaviour(int payloadSize, Layout<KEY, VALUE> layout, OffloadStore<KEY, VALUE> offloadStore, DependencyResolver dependencyResolver) {
            return new InternalNodeFixedSize<KEY>(payloadSize, layout);
        }

        @Override
        public byte formatIdentifier() {
            return 2;
        }

        @Override
        public byte formatVersion() {
            return 0;
        }
    };
    private static final TreeNodeSelector.Factory DYNAMIC = new TreeNodeSelector.Factory(){
        static final byte FORMAT_IDENTIFIER = 3;
        static final byte FORMAT_VERSION = 0;

        @Override
        public <KEY, VALUE> LeafNodeBehaviour<KEY, VALUE> createLeafBehaviour(int payloadSize, Layout<KEY, VALUE> layout, OffloadStore<KEY, VALUE> offloadStore, DependencyResolver dependencyResolver) {
            return new LeafNodeDynamicSize<KEY, VALUE>(payloadSize, layout, offloadStore);
        }

        @Override
        public <KEY, VALUE> InternalNodeBehaviour<KEY> createInternalBehaviour(int payloadSize, Layout<KEY, VALUE> layout, OffloadStore<KEY, VALUE> offloadStore, DependencyResolver dependencyResolver) {
            return new InternalNodeDynamicSize<KEY>(payloadSize, layout, offloadStore);
        }

        @Override
        public byte formatIdentifier() {
            return 3;
        }

        @Override
        public byte formatVersion() {
            return 0;
        }
    };

    public static TreeNodeSelector selector() {
        return layout -> layout.fixedSize() ? FIXED : DYNAMIC;
    }
}

