/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringJoiner;
import org.neo4j.index.internal.gbptree.DynamicSizeUtil;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.OffloadStore;
import org.neo4j.index.internal.gbptree.Overflow;
import org.neo4j.index.internal.gbptree.PointerWithGeneration;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.io.pagecache.context.CursorContext;

public final class InternalNodeDynamicSize<KEY>
implements InternalNodeBehaviour<KEY> {
    private final int inlineKeySizeCap;
    private final int keySizeCap;
    private final int totalSpace;
    final OffloadStore<KEY, ?> offloadStore;
    private final int maxKeyCount;
    final Layout<KEY, ?> layout;
    final int payloadSize;

    InternalNodeDynamicSize(int payloadSize, Layout<KEY, ?> layout, OffloadStore<KEY, ?> offloadStore) {
        this.payloadSize = payloadSize;
        this.layout = layout;
        assert (payloadSize < DynamicSizeUtil.SUPPORTED_PAGE_SIZE_LIMIT) : "Only payload size less then " + DynamicSizeUtil.SUPPORTED_PAGE_SIZE_LIMIT + " bytes supported";
        this.totalSpace = payloadSize - 86;
        this.maxKeyCount = this.totalSpace / 3;
        this.offloadStore = offloadStore;
        this.inlineKeySizeCap = DynamicSizeUtil.inlineKeyValueSizeCapInternalNode(payloadSize);
        this.keySizeCap = DynamicSizeUtil.keyValueSizeCapFromPageSize(payloadSize);
        DynamicSizeUtil.validateInlineCap(this.inlineKeySizeCap, payloadSize);
    }

    @Override
    public void initialize(PageCursor cursor, byte layerType, long stableGeneration, long unstableGeneration) {
        TreeNodeUtil.writeBaseHeader(cursor, (byte)0, layerType, stableGeneration, unstableGeneration);
        DynamicSizeUtil.setAllocOffset(cursor, this.payloadSize);
        DynamicSizeUtil.setDeadSpace(cursor, 0);
    }

    @Override
    public long offloadIdAt(PageCursor cursor, int pos) {
        this.placeCursorAtActualKey(cursor, pos);
        return DynamicSizeUtil.offloadIdAt(cursor);
    }

    @Override
    public KEY keyAt(PageCursor cursor, KEY into, int pos, CursorContext cursorContext) {
        this.placeCursorAtActualKey(cursor, pos);
        return TreeNodeUtil.readDynamicKey(this.layout, this.offloadStore, cursor, into, pos, cursorContext, this.keySizeCap);
    }

    @Override
    public Comparator<KEY> keyComparator() {
        return this.layout;
    }

    @Override
    public void insertKeyAndRightChildAt(PageCursor cursor, KEY key, long child, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int newKeyOffset;
        int currentKeyOffset = DynamicSizeUtil.getAllocOffset(cursor);
        int keySize = this.layout.keySize(key);
        if (this.canInline(keySize)) {
            newKeyOffset = currentKeyOffset - keySize - DynamicSizeUtil.getOverhead(keySize, 0, false);
            cursor.setOffset(newKeyOffset);
            DynamicSizeUtil.putKeyValueSize(cursor, keySize, 0);
            this.layout.writeKey(cursor, key);
        } else {
            newKeyOffset = currentKeyOffset - DynamicSizeUtil.getOverhead(keySize, 0, true);
            cursor.setOffset(newKeyOffset);
            DynamicSizeUtil.putOffloadMarker(cursor);
            long offloadId = this.offloadStore.writeKey(key, stableGeneration, unstableGeneration, cursorContext);
            DynamicSizeUtil.putOffloadId(cursor, offloadId);
        }
        DynamicSizeUtil.setAllocOffset(cursor, newKeyOffset);
        int childPos = pos + 1;
        int childOffset = this.childOffset(childPos);
        TreeNodeUtil.insertSlotsAt(cursor, pos, 1, keyCount, InternalNodeDynamicSize.keyPosOffsetInternal(0), 26);
        cursor.setOffset(InternalNodeDynamicSize.keyPosOffsetInternal(pos));
        PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)newKeyOffset);
        TreeNodeUtil.writeChild(cursor, child, stableGeneration, unstableGeneration, childPos, childOffset);
    }

    @Override
    public void removeKeyAndRightChildAt(PageCursor cursor, int keyPos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.placeCursorAtActualKey(cursor, keyPos);
        int keyOffset = cursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            this.offloadStore.free(offloadId, stableGeneration, unstableGeneration, cursorContext);
        }
        cursor.setOffset(keyOffset);
        DynamicSizeUtil.putTombstone(cursor);
        int deadSpace = DynamicSizeUtil.getDeadSpace(cursor);
        DynamicSizeUtil.setDeadSpace(cursor, deadSpace + keySize + DynamicSizeUtil.getOverhead(keySize, 0, offload));
        TreeNodeUtil.removeSlotAt(cursor, keyPos, keyCount, InternalNodeDynamicSize.keyPosOffsetInternal(0), 26);
        InternalNodeDynamicSize.zeroPad(cursor, InternalNodeDynamicSize.keyPosOffsetInternal(keyCount - 1), 26);
    }

    @Override
    public void removeKeyAndLeftChildAt(PageCursor cursor, int keyPos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.placeCursorAtActualKey(cursor, keyPos);
        int keyOffset = cursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            this.offloadStore.free(offloadId, stableGeneration, unstableGeneration, cursorContext);
        }
        cursor.setOffset(keyOffset);
        DynamicSizeUtil.putTombstone(cursor);
        int deadSpace = DynamicSizeUtil.getDeadSpace(cursor);
        DynamicSizeUtil.setDeadSpace(cursor, deadSpace + keySize + DynamicSizeUtil.getOverhead(keySize, 0, offload));
        TreeNodeUtil.removeSlotAt(cursor, keyPos, keyCount, InternalNodeDynamicSize.keyPosOffsetInternal(0) - 24, 26);
        cursor.copyTo(this.childOffset(keyCount), cursor, this.childOffset(keyCount - 1), 24);
        InternalNodeDynamicSize.zeroPad(cursor, InternalNodeDynamicSize.keyPosOffsetInternal(keyCount - 1), 26);
    }

    @Override
    public boolean setKeyAt(PageCursor cursor, KEY key, int pos) {
        int newKeySize;
        this.placeCursorAtActualKey(cursor, pos);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int oldKeySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int oldValueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        if (this.keyValueSizeTooLarge(oldKeySize, oldValueSize)) {
            this.readUnreliableKeyValueSize(cursor, oldKeySize, oldValueSize, keyValueSize, pos);
        }
        if ((newKeySize = this.layout.keySize(key)) == oldKeySize) {
            this.layout.writeKey(cursor, key);
            return true;
        }
        return false;
    }

    @Override
    public void setChildAt(PageCursor cursor, long child, int pos, long stableGeneration, long unstableGeneration) {
        int childOffset = this.childOffset(pos);
        cursor.setOffset(childOffset);
        TreeNodeUtil.writeChild(cursor, child, stableGeneration, unstableGeneration, pos, childOffset);
    }

    @Override
    public boolean reasonableKeyCount(int keyCount) {
        return keyCount >= 0 && keyCount <= this.maxKeyCount;
    }

    @Override
    public int childOffset(int pos) {
        return InternalNodeDynamicSize.keyPosOffsetInternal(pos) - 24;
    }

    @Override
    public int maxKeyCount() {
        return this.maxKeyCount;
    }

    @Override
    public Overflow overflow(PageCursor cursor, int currentKeyCount, KEY newKey) {
        int neededSpace = this.totalSpaceOfKeyChild(newKey);
        int deadSpace = DynamicSizeUtil.getDeadSpace(cursor);
        int allocSpace = DynamicSizeUtil.getAllocSpace(cursor, InternalNodeDynamicSize.keyPosOffsetInternal(currentKeyCount));
        return DynamicSizeUtil.calculateOverflow(neededSpace, deadSpace, allocSpace);
    }

    @Override
    public int availableSpace(PageCursor cursor, int currentKeyCount) {
        int deadSpace = DynamicSizeUtil.getDeadSpace(cursor);
        int allocSpace = DynamicSizeUtil.getAllocSpace(cursor, InternalNodeDynamicSize.keyPosOffsetInternal(currentKeyCount));
        return allocSpace + deadSpace;
    }

    @Override
    public void defragment(PageCursor cursor, int keyCount) {
        this.doDefragment(cursor, keyCount);
    }

    private void doDefragment(PageCursor cursor, int keyCount) {
        int[] offsets = new int[keyCount];
        int[] sizes = new int[keyCount];
        DynamicSizeUtil.recordAliveBlocks(cursor, keyCount, offsets, sizes, this.payloadSize);
        DynamicSizeUtil.compactToRight(cursor, keyCount, keyCount, offsets, sizes, this.payloadSize, InternalNodeDynamicSize::keyPosOffsetInternal);
        DynamicSizeUtil.setDeadSpace(cursor, 0);
    }

    @Override
    public void doSplit(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, long newRightChild, long stableGeneration, long unstableGeneration, KEY newSplitter, double ratioToKeepInLeftOnSplit, CursorContext cursorContext) throws IOException {
        int keyCountAfterInsert = leftKeyCount + 1;
        int splitPos = this.splitPosInternal(leftCursor, insertPos, newKey, keyCountAfterInsert, ratioToKeepInLeftOnSplit);
        if (splitPos == insertPos) {
            this.layout.copyKey(newKey, newSplitter);
        } else {
            this.keyAt(leftCursor, newSplitter, insertPos < splitPos ? splitPos - 1 : splitPos, cursorContext);
        }
        int rightKeyCount = keyCountAfterInsert - splitPos - 1;
        if (insertPos < splitPos) {
            this.moveKeysAndChildren(leftCursor, splitPos, rightCursor, 0, rightKeyCount, true);
            this.removeKeyAndRightChildAt(leftCursor, splitPos - 1, splitPos, stableGeneration, unstableGeneration, cursorContext);
            this.doDefragment(leftCursor, splitPos - 1);
            this.insertKeyAndRightChildAt(leftCursor, newKey, newRightChild, insertPos, splitPos - 1, stableGeneration, unstableGeneration, cursorContext);
        } else if (insertPos == splitPos) {
            int copyFrom = splitPos;
            int copyCount = leftKeyCount - copyFrom;
            this.moveKeysAndChildren(leftCursor, copyFrom, rightCursor, 0, copyCount, false);
            this.doDefragment(leftCursor, splitPos);
            this.setChildAt(rightCursor, newRightChild, 0, stableGeneration, unstableGeneration);
        } else {
            int copyFrom = splitPos + 1;
            int copyCount = leftKeyCount - copyFrom;
            this.moveKeysAndChildren(leftCursor, copyFrom, rightCursor, 0, copyCount, true);
            this.removeKeyAndRightChildAt(leftCursor, splitPos, splitPos + 1, stableGeneration, unstableGeneration, cursorContext);
            this.doDefragment(leftCursor, splitPos);
            this.insertKeyAndRightChildAt(rightCursor, newKey, newRightChild, insertPos - copyFrom, copyCount, stableGeneration, unstableGeneration, cursorContext);
        }
        TreeNodeUtil.setKeyCount(leftCursor, splitPos);
        TreeNodeUtil.setKeyCount(rightCursor, rightKeyCount);
    }

    private void moveKeysAndChildren(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count, boolean includeLeftMostChild) {
        int toAllocOffset;
        if (count == 0 && !includeLeftMostChild) {
            return;
        }
        int childFromOffset = includeLeftMostChild ? this.childOffset(fromPos) : this.childOffset(fromPos + 1);
        int childToOffset = this.childOffset(fromPos + count) + 24;
        int lengthInBytes = childToOffset - childFromOffset;
        int targetOffset = includeLeftMostChild ? this.childOffset(0) : this.childOffset(1);
        fromCursor.copyTo(childFromOffset, toCursor, targetOffset, lengthInBytes);
        int firstAllocOffset = toAllocOffset = DynamicSizeUtil.getAllocOffset(toCursor);
        int i = 0;
        while (i < count) {
            toAllocOffset = this.transferRawKey(fromCursor, fromPos + i, toCursor, toAllocOffset);
            toCursor.setOffset(InternalNodeDynamicSize.keyPosOffsetInternal(toPos));
            PageCursorUtil.putUnsignedShort((PageCursor)toCursor, (int)toAllocOffset);
            ++i;
            ++toPos;
        }
        DynamicSizeUtil.setAllocOffset(toCursor, toAllocOffset);
        int deadSpace = DynamicSizeUtil.getDeadSpace(fromCursor);
        int totalMovedBytes = firstAllocOffset - toAllocOffset;
        DynamicSizeUtil.setDeadSpace(fromCursor, deadSpace + totalMovedBytes);
        InternalNodeDynamicSize.zeroPad(fromCursor, childFromOffset, lengthInBytes);
    }

    private static void zeroPad(PageCursor fromCursor, int fromOffset, int lengthInBytes) {
        fromCursor.setOffset(fromOffset);
        fromCursor.putBytes(lengthInBytes, (byte)0);
    }

    private int transferRawKey(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toAllocOffset) {
        this.placeCursorAtActualKey(fromCursor, fromPos);
        int fromKeyOffset = fromCursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(fromCursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        int toCopy = DynamicSizeUtil.getOverhead(keySize, 0, offload) + keySize;
        fromCursor.copyTo(fromKeyOffset, toCursor, toAllocOffset -= toCopy, toCopy);
        fromCursor.setOffset(fromKeyOffset);
        DynamicSizeUtil.putTombstone(fromCursor);
        return toAllocOffset;
    }

    private int splitPosInternal(PageCursor cursor, int insertPos, KEY newKey, int keyCountAfterInsert, double ratioToKeepInLeftOnSplit) {
        boolean prevPosPossible;
        int prevDelta;
        int targetLeftSpace = (int)((double)this.totalSpace * ratioToKeepInLeftOnSplit);
        int splitPos = 0;
        int currentPos = 0;
        int accumulatedLeftSpace = 24;
        int currentDelta = Math.abs(accumulatedLeftSpace - targetLeftSpace);
        int spaceOfNewKeyAndChild = this.totalSpaceOfKeyChild(newKey);
        int totalSpaceIncludingNewKeyAndChild = this.totalActiveSpace(cursor, keyCountAfterInsert - 1) + spaceOfNewKeyAndChild;
        boolean includedNew = false;
        boolean thisPosPossible = false;
        do {
            int space;
            prevPosPossible = thisPosPossible;
            if (currentPos == insertPos && !includedNew) {
                space = this.totalSpaceOfKeyChild(newKey);
                includedNew = true;
                --currentPos;
            } else {
                space = this.totalSpaceOfKeyChild(cursor, currentPos);
            }
            prevDelta = currentDelta;
            currentDelta = Math.abs((accumulatedLeftSpace += space) - targetLeftSpace);
            ++currentPos;
            boolean bl = thisPosPossible = totalSpaceIncludingNewKeyAndChild - accumulatedLeftSpace < this.totalSpace;
        } while (currentDelta < prevDelta && ++splitPos < keyCountAfterInsert && accumulatedLeftSpace < this.totalSpace || !thisPosPossible);
        if (prevPosPossible) {
            --splitPos;
        }
        return splitPos;
    }

    private int totalActiveSpace(PageCursor cursor, int keyCount) {
        int deadSpace = DynamicSizeUtil.getDeadSpace(cursor);
        int allocSpace = DynamicSizeUtil.getAllocSpace(cursor, InternalNodeDynamicSize.keyPosOffsetInternal(keyCount));
        return this.totalSpace - deadSpace - allocSpace;
    }

    @Override
    public int totalSpaceOfKeyChild(KEY key) {
        int keySize = this.layout.keySize(key);
        boolean canInline = this.canInline(keySize);
        if (canInline) {
            return 2 + DynamicSizeUtil.getOverhead(keySize, 0, false) + 24 + keySize;
        }
        return 2 + DynamicSizeUtil.getOverhead(keySize, 0, true) + 24;
    }

    private int totalSpaceOfKeyChild(PageCursor cursor, int pos) {
        this.placeCursorAtActualKey(cursor, pos);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        return 2 + DynamicSizeUtil.getOverhead(keySize, 0, offload) + 24 + keySize;
    }

    private void placeCursorAtActualKey(PageCursor cursor, int pos) {
        int keyPosOffset = InternalNodeDynamicSize.keyPosOffsetInternal(pos);
        DynamicSizeUtil.redirectCursor(cursor, keyPosOffset, 86, this.payloadSize);
    }

    void readUnreliableKeyValueSize(PageCursor cursor, int keySize, int valueSize, long keyValueSize, int pos) {
        cursor.setCursorException(String.format("Read unreliable key, id=%d, keySize=%d, valueSize=%d, keyValueSizeCap=%d, keyHasTombstone=%b, pos=%d", cursor.getCurrentPageId(), keySize, valueSize, this.keySizeCap, DynamicSizeUtil.extractTombstone(keyValueSize), pos));
    }

    boolean keyValueSizeTooLarge(int keySize, int valueSize) {
        return keySize + valueSize > this.keySizeCap;
    }

    private static int keyPosOffsetInternal(int pos) {
        return 110 + pos * 26;
    }

    public String toString() {
        return "TreeNodeDynamicSize[pageSize:" + this.payloadSize + ", keyValueSizeCap:" + this.keySizeCap + ", inlineKeySizeCap:" + this.inlineKeySizeCap + "]";
    }

    private String asString(PageCursor cursor, boolean includeAllocSpace, long stableGeneration, long unstableGeneration) {
        int currentOffset = cursor.getOffset();
        int allocOffset = DynamicSizeUtil.getAllocOffset(cursor);
        int deadSpace = DynamicSizeUtil.getDeadSpace(cursor);
        String additionalHeader = "{" + cursor.getCurrentPageId() + "} [allocOffset=" + allocOffset + " deadSpace=" + deadSpace + "] ";
        String offsetArray = this.readOffsetArray(cursor, stableGeneration, unstableGeneration);
        String allocSpace = "";
        if (includeAllocSpace) {
            allocSpace = this.readAllocSpace(cursor, allocOffset);
        }
        Object readKey = this.layout.newKey();
        StringJoiner keys = new StringJoiner(" ");
        cursor.setOffset(allocOffset);
        while (cursor.getOffset() < cursor.getPagedFile().payloadSize()) {
            StringJoiner singleKey = new StringJoiner("|");
            singleKey.add(Integer.toString(cursor.getOffset()));
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
            if (DynamicSizeUtil.extractTombstone(keyValueSize)) {
                singleKey.add("T");
            } else {
                singleKey.add("_");
            }
            if (offload) {
                singleKey.add("O");
            } else {
                singleKey.add("_");
            }
            if (offload) {
                long offloadId = DynamicSizeUtil.readOffloadId(cursor);
                singleKey.add(Long.toString(offloadId));
            } else {
                this.layout.readKey(cursor, readKey, keySize);
                singleKey.add(Integer.toString(keySize));
                singleKey.add(readKey.toString());
            }
            keys.add(singleKey.toString());
        }
        cursor.setOffset(currentOffset);
        return additionalHeader + offsetArray + " " + allocSpace + " " + String.valueOf(keys);
    }

    @Override
    public void printNode(PageCursor cursor, boolean includeAllocSpace, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        System.out.println(this.asString(cursor, includeAllocSpace, stableGeneration, unstableGeneration));
    }

    @Override
    public String checkMetaConsistency(PageCursor cursor) {
        int keyCount;
        int offsetArray;
        long nodeId = cursor.getCurrentPageId();
        StringJoiner joiner = new StringJoiner(", ", "Meta data for tree node is inconsistent, id=" + nodeId + ": ", "");
        boolean hasInconsistency = false;
        int allocOffset = DynamicSizeUtil.getAllocOffset(cursor);
        if (allocOffset < (offsetArray = InternalNodeDynamicSize.keyPosOffsetInternal(keyCount = TreeNodeUtil.keyCount(cursor)))) {
            joiner.add(String.format("Overlap between offsetArray and allocSpace, offsetArray=%d, allocOffset=%d", offsetArray, allocOffset));
            return joiner.toString();
        }
        if (this.reasonableKeyCount(keyCount)) {
            int lowestActiveKeyOffset;
            int allocSpace;
            int deadSpace;
            int activeSpace = this.totalActiveSpaceRaw(cursor, keyCount);
            if (activeSpace + (deadSpace = DynamicSizeUtil.getDeadSpace(cursor)) + (allocSpace = DynamicSizeUtil.getAllocSpace(cursor, InternalNodeDynamicSize.keyPosOffsetInternal(keyCount))) != this.totalSpace) {
                hasInconsistency = true;
                joiner.add(String.format("Space areas did not sum to total space; activeSpace=%d, deadSpace=%d, allocSpace=%d, totalSpace=%d", activeSpace, deadSpace, allocSpace, this.totalSpace));
            }
            if ((lowestActiveKeyOffset = this.lowestActiveKeyOffset(cursor, keyCount)) < allocOffset) {
                hasInconsistency = true;
                joiner.add(String.format("Overlap between allocSpace and active keys, allocOffset=%d, lowestActiveKeyOffset=%d", allocOffset, lowestActiveKeyOffset));
            }
        }
        if (allocOffset < this.payloadSize && allocOffset >= 0) {
            cursor.setOffset(allocOffset);
            long keyValueAtAllocOffset = DynamicSizeUtil.readKeyValueSize(cursor);
            if (keyValueAtAllocOffset == 0L) {
                hasInconsistency = true;
                joiner.add(String.format("Pointer to allocSpace is misplaced, it should point to start of key, allocOffset=%d", allocOffset));
            }
        }
        if (hasInconsistency) {
            return joiner.toString();
        }
        return "";
    }

    private int lowestActiveKeyOffset(PageCursor cursor, int keyCount) {
        int lowestOffsetSoFar = this.payloadSize;
        for (int pos = 0; pos < keyCount; ++pos) {
            int keyPosOffset = InternalNodeDynamicSize.keyPosOffsetInternal(pos);
            cursor.setOffset(keyPosOffset);
            int keyOffset = PageCursorUtil.getUnsignedShort((PageCursor)cursor);
            lowestOffsetSoFar = Math.min(lowestOffsetSoFar, keyOffset);
        }
        return lowestOffsetSoFar;
    }

    private int totalActiveSpaceRaw(PageCursor cursor, int keyCount) {
        int offsetArrayStart = 86;
        int offsetArrayEnd = InternalNodeDynamicSize.keyPosOffsetInternal(keyCount);
        int offsetArraySize = offsetArrayEnd - offsetArrayStart;
        int aliveKeySize = 0;
        int nextKeyOffset = DynamicSizeUtil.getAllocOffset(cursor);
        while (nextKeyOffset < this.payloadSize) {
            cursor.setOffset(nextKeyOffset);
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
            boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
            boolean tombstone = DynamicSizeUtil.extractTombstone(keyValueSize);
            if (!tombstone) {
                aliveKeySize += DynamicSizeUtil.getOverhead(keySize, valueSize, offload) + keySize + valueSize;
            }
            nextKeyOffset = cursor.getOffset() + (offload ? 8 : keySize + valueSize);
        }
        return offsetArraySize + aliveKeySize;
    }

    private String readAllocSpace(PageCursor cursor, int allocOffset) {
        int keyCount = TreeNodeUtil.keyCount(cursor);
        int endOfOffsetArray = InternalNodeDynamicSize.keyPosOffsetInternal(keyCount);
        cursor.setOffset(endOfOffsetArray);
        int bytesToRead = allocOffset - endOfOffsetArray;
        byte[] allocSpace = new byte[bytesToRead];
        cursor.getBytes(allocSpace);
        for (byte b : allocSpace) {
            if (b == 0) continue;
            return "v" + endOfOffsetArray + ">" + bytesToRead + "|" + Arrays.toString(allocSpace);
        }
        return "v" + endOfOffsetArray + ">" + bytesToRead + "|[0...]";
    }

    private String readOffsetArray(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        int keyCount = TreeNodeUtil.keyCount(cursor);
        StringJoiner offsetArray = new StringJoiner(" ");
        for (int i = 0; i < keyCount; ++i) {
            long childPointer = GenerationSafePointerPair.pointer(this.childAt(cursor, i, stableGeneration, unstableGeneration));
            offsetArray.add("/" + childPointer + "\\");
            cursor.setOffset(InternalNodeDynamicSize.keyPosOffsetInternal(i));
            offsetArray.add(Integer.toString(PageCursorUtil.getUnsignedShort((PageCursor)cursor)));
        }
        long childPointer = GenerationSafePointerPair.pointer(this.childAt(cursor, keyCount, stableGeneration, unstableGeneration));
        offsetArray.add("/" + childPointer + "\\");
        return offsetArray.toString();
    }

    @Override
    public long childAt(PageCursor cursor, int pos, long stableGeneration, long unstableGeneration) {
        return this.childWithGenerationAt(cursor, pos, stableGeneration, unstableGeneration).pointer();
    }

    @Override
    public PointerWithGeneration childWithGenerationAt(PageCursor cursor, int pos, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(this.childOffset(pos));
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration);
    }

    private PointerWithGeneration readChild(PageCursor cursor, int pos, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(this.childOffset(pos));
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration);
    }

    private boolean canInline(int entrySize) {
        return entrySize <= this.inlineKeySizeCap;
    }
}

