/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;
import org.neo4j.index.internal.gbptree.KeySearch;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeBehaviour;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.PointerWithGeneration;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootCatchup;
import org.neo4j.index.internal.gbptree.RootInitializer;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.index.internal.gbptree.ValueHolder;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.util.Preconditions;

class SeekCursor<KEY, VALUE>
implements Seeker<KEY, VALUE> {
    static final Monitor NO_MONITOR = new MonitorAdaptor();
    static final int DEFAULT_MAX_READ_AHEAD = 20;
    static final int LEAF_LEVEL = Integer.MAX_VALUE;
    private RootInitializer rootInitializer;
    private final PageCursor cursor;
    private final CursorContext cursorContext;
    private final Cache cache = new Cache();
    private boolean resultOnTrack;
    private KEY fromInclusive;
    private KEY toExclusive;
    private boolean exactMatch;
    private final Layout<KEY, VALUE> layout;
    private final LeafNodeBehaviour<KEY, VALUE> leafNode;
    private final InternalNodeBehaviour<KEY> internalNode;
    private final KEY prevKey;
    private final LongSupplier generationSupplier;
    private RootCatchup rootCatchup;
    private int searchLevel;
    private boolean first = true;
    private long stableGeneration;
    private long unstableGeneration;
    private int pos;
    private int keyCount;
    private long currentNodeGeneration;
    private long lastFollowedPointerGeneration;
    private long expectedCurrentNodeGeneration;
    private boolean seekForward;
    private int stride;
    private byte nodeType;
    private PointerWithGeneration successor = PointerWithGeneration.EMPTY;
    private boolean isInternal;
    private PointerWithGeneration nextSibling;
    private PointerWithGeneration prevSibling;
    private final KEY expectedFirstAfterGoToNext;
    private final KEY firstKeyInNode;
    private boolean verifyExpectedFirstAfterGoToNext;
    private boolean ended;
    private boolean closed;
    private final Consumer<Throwable> exceptionDecorator;
    private Monitor monitor;
    private boolean forceReadHeader;
    private final int maxKeyCount;
    private final KEY tempKey;

    SeekCursor(PageCursor cursor, Layout<KEY, VALUE> layout, LeafNodeBehaviour<KEY, VALUE> leafNode, InternalNodeBehaviour<KEY> internalNode, LongSupplier generationSupplier, Consumer<Throwable> exceptionDecorator, CursorContext cursorContext) {
        this.cursor = cursor;
        this.cursorContext = cursorContext;
        this.layout = layout;
        this.exceptionDecorator = exceptionDecorator;
        this.generationSupplier = generationSupplier;
        this.leafNode = leafNode;
        this.internalNode = internalNode;
        this.prevKey = layout.newKey();
        this.expectedFirstAfterGoToNext = layout.newKey();
        this.firstKeyInNode = layout.newKey();
        this.maxKeyCount = Math.max(leafNode.maxKeyCount(), internalNode.maxKeyCount());
        this.tempKey = layout.newKey();
    }

    SeekCursor<KEY, VALUE> initialize(RootInitializer rootInitializer, RootCatchup rootCatchup, KEY fromInclusive, KEY toExclusive, int maxReadAhead, int searchLevel, Monitor monitor) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Seeker already closed");
        this.rootInitializer = rootInitializer;
        this.rootCatchup = rootCatchup;
        this.lastFollowedPointerGeneration = rootInitializer.goToRoot(this.cursor, this.cursorContext);
        long generation = this.generationSupplier.getAsLong();
        this.stableGeneration = Generation.stableGeneration(generation);
        this.unstableGeneration = Generation.unstableGeneration(generation);
        this.resultOnTrack = false;
        this.expectedCurrentNodeGeneration = 0L;
        this.verifyExpectedFirstAfterGoToNext = false;
        this.forceReadHeader = false;
        this.fromInclusive = fromInclusive;
        this.toExclusive = toExclusive;
        this.exactMatch = this.layout.compare(fromInclusive, toExclusive) == 0;
        this.first = true;
        this.seekForward = this.layout.compare(fromInclusive, toExclusive) <= 0;
        this.stride = this.seekForward ? 1 : -1;
        this.searchLevel = searchLevel;
        this.monitor = monitor;
        this.cache.init(this.exactMatch ? 1 : maxReadAhead);
        this.ended = false;
        this.pos = 0;
        this.keyCount = 0;
        this.currentNodeGeneration = 0L;
        this.nodeType = 0;
        this.successor = PointerWithGeneration.EMPTY;
        this.isInternal = false;
        this.nextSibling = PointerWithGeneration.EMPTY;
        this.prevSibling = PointerWithGeneration.EMPTY;
        return this;
    }

    private void traverseDownToCorrectLevel() throws IOException {
        this.traverseToTargetLevel(this.searchLevel);
        this.cache.clear();
    }

    private void traverseToTargetLevel(int searchLevel) throws IOException {
        int currentReadLevel = 0;
        while (true) {
            PointerWithGeneration childPointer = this.readHeaderAndSearchForChild();
            if (this.endedUpOnUnWrongNode()) {
                this.prepareToStartFromRoot();
                this.isInternal = true;
                currentReadLevel = 0;
                continue;
            }
            this.sanityCheck();
            if (this.goToSuccessor()) continue;
            this.monitorReadLevel(this.isInternal, currentReadLevel, this.keyCount);
            if (!this.isInternal || currentReadLevel == searchLevel) break;
            this.goTo(childPointer.pointer(), childPointer.generation(), "CHILD", false);
            ++currentReadLevel;
        }
    }

    private void monitorReadLevel(boolean internal, int readLevel, int keyCount) {
        if (internal) {
            this.monitor.internalNode(readLevel, keyCount);
        } else {
            this.monitor.leafNode(readLevel, keyCount);
        }
    }

    private void sanityCheck() {
        if (!this.keyCountIsSane(this.keyCount)) {
            throw new TreeInconsistencyException("Read inconsistent tree node %d%n  nodeType:%d%n  currentNodeGeneration:%d%n  successor:%d%n  successorGeneration:%d%n  isInternal:%b%n  keyCount:%d%n  pos:%d%n  childId:%d%n  childIdGeneration:%d", this.cursor.getCurrentPageId(), this.nodeType, this.currentNodeGeneration, this.successor.pointer(), this.successor.generation(), this.isInternal, this.keyCount, this.pos, this.nextSibling.pointer(), this.nextSibling.generation());
        }
    }

    private PointerWithGeneration readHeaderAndSearchForChild() throws IOException {
        PointerWithGeneration result = null;
        do {
            try {
                if (!this.readHeader() || !this.isInternal) continue;
                int searchResult = KeySearch.search(this.cursor, this.internalNode, this.fromInclusive, this.tempKey, this.keyCount, this.cursorContext);
                int childPos = KeySearch.childPositionOf(searchResult);
                result = this.internalNode.childWithGenerationAt(this.cursor, childPos, this.stableGeneration, this.unstableGeneration);
            }
            catch (Exception e) {
                this.cursor.setCursorException(e.getMessage());
            }
        } while (this.cursor.shouldRetry());
        PointerChecking.checkOutOfBounds(this.cursor);
        this.cursor.checkAndClearCursorException();
        return result;
    }

    @Override
    public boolean next() throws IOException {
        try {
            this.initialTraverseDownIfNeeded();
            boolean concurrentWriteHappened = this.first;
            block7: while (!this.ended) {
                this.pos += this.stride;
                if (this.cache.hasNext() && !(concurrentWriteHappened = this.cursor.shouldRetry())) {
                    this.cache.next();
                    if (this.resultOnTrack && this.isValueDefined(this.cache.currentValue())) {
                        return true;
                    }
                    if (this.insidePrevKey(this.cache.currentKey())) {
                        this.first = false;
                        this.resultOnTrack = true;
                        if (!this.isValueDefined(this.cache.currentValue())) continue;
                        return true;
                    }
                    if (!this.first) continue;
                    concurrentWriteHappened = true;
                    continue;
                }
                if (this.resultOnTrack) {
                    this.layout.copyKey(this.cache.currentKey(), this.prevKey);
                }
                boolean bl = concurrentWriteHappened = !this.readAndValidateNextKeyValueBatch(concurrentWriteHappened);
                if (concurrentWriteHappened) {
                    this.cache.clear();
                    continue;
                }
                if (!this.seekForward && this.pos >= this.keyCount) {
                    if (!this.goTo(this.prevSibling.pointer(), this.prevSibling.generation(), "RIGHT_SIBLING", true)) continue;
                    concurrentWriteHappened = true;
                    continue;
                }
                if (this.seekForward && this.pos >= this.keyCount || !this.seekForward && this.pos < 0) {
                    switch (this.goToNextSibling().ordinal()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            concurrentWriteHappened = true;
                            continue block7;
                        }
                        case 1: {
                            continue block7;
                        }
                    }
                }
                this.pos -= this.stride;
                this.ended = this.cache.empty();
            }
        }
        catch (Throwable e) {
            this.exceptionDecorator.accept(e);
            throw e;
        }
        return false;
    }

    private void initialTraverseDownIfNeeded() throws IOException {
        if (this.first && !this.ended) {
            this.traverseDownToCorrectLevel();
        }
    }

    private boolean readAndValidateNextKeyValueBatch(boolean writeHappened) throws IOException {
        boolean retry = writeHappened;
        do {
            try {
                this.cache.clear();
                this.resultOnTrack = false;
                if ((retry || this.forceReadHeader || !this.seekForward) && (!this.readHeader() || this.isInternal && this.searchLevel == Integer.MAX_VALUE)) continue;
                if (this.verifyExpectedFirstAfterGoToNext) {
                    assert (!this.seekForward);
                    this.pos = this.keyCount - 1;
                    (this.isInternal ? this.internalNode : this.leafNode).keyAt(this.cursor, this.firstKeyInNode, this.pos, this.cursorContext);
                }
                if (retry) {
                    KEY key = this.first ? this.fromInclusive : this.prevKey;
                    int searchResult = KeySearch.search(this.cursor, this.isInternal ? this.internalNode : this.leafNode, key, this.tempKey, this.keyCount, this.cursorContext);
                    this.pos = this.selectPosition(searchResult, this.first, this.seekForward, this.keyCount);
                }
                this.cache.fill(this.pos);
            }
            catch (Exception e) {
                this.cursor.setCursorException(e.getMessage());
            }
            retry = true;
        } while (this.cursor.shouldRetry());
        this.checkOutOfBoundsAndClosed();
        this.cursor.checkAndClearCursorException();
        if (this.endedUpOnUnWrongNode() || this.isInternal && this.searchLevel == Integer.MAX_VALUE) {
            this.prepareToStartFromRoot();
            this.traverseDownToCorrectLevel();
            return false;
        }
        this.sanityCheck();
        if (!this.verifyFirstKeyInNodeIsExpectedAfterGoTo()) {
            return false;
        }
        return !this.goToSuccessor();
    }

    private int selectPosition(int searchResult, boolean inclusive, boolean seekForward, int keyCount) {
        int position = KeySearch.positionOf(searchResult);
        boolean hit = KeySearch.isHit(searchResult);
        if (seekForward) {
            if (hit && !inclusive) {
                return position + 1;
            }
            return position;
        }
        if (position == keyCount) {
            return position;
        }
        if (!hit || !inclusive) {
            return position - 1;
        }
        return position;
    }

    private void checkOutOfBoundsAndClosed() {
        try {
            PointerChecking.checkOutOfBounds(this.cursor);
        }
        catch (TreeInconsistencyException e) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Tried to use seeker after it was closed");
            throw e;
        }
    }

    private boolean insideEndRange(boolean exactMatch, KEY key) {
        int compare = this.layout.compare(key, this.toExclusive);
        if (exactMatch) {
            return this.seekForward ? compare <= 0 : compare >= 0;
        }
        return this.seekForward ? compare < 0 : compare > 0;
    }

    private boolean insideStartRange(KEY key) {
        int compare = this.layout.compare(key, this.fromInclusive);
        return this.seekForward ? compare >= 0 : compare <= 0;
    }

    private boolean insidePrevKey(KEY key) {
        if (this.first) {
            return this.insideStartRange(key);
        }
        int compare = this.layout.compare(key, this.prevKey);
        return this.seekForward ? compare > 0 : compare < 0;
    }

    private boolean goTo(long pointerId, long pointerGeneration, String type, boolean allowNoNode) throws IOException {
        if (this.pointerCheckingWithGenerationCatchup(pointerId, allowNoNode, type)) {
            return true;
        }
        if (!allowNoNode || TreeNodeUtil.isNode(pointerId)) {
            TreeNodeUtil.goTo(this.cursor, type, pointerId);
            this.lastFollowedPointerGeneration = pointerGeneration;
            return true;
        }
        return false;
    }

    private boolean goToSuccessor() throws IOException {
        return this.goTo(this.successor.pointer(), this.successor.generation(), "SUCCESSOR", true);
    }

    private boolean verifyFirstKeyInNodeIsExpectedAfterGoTo() {
        boolean result = true;
        if (this.verifyExpectedFirstAfterGoToNext && this.layout.compare(this.firstKeyInNode, this.expectedFirstAfterGoToNext) != 0) {
            result = false;
        }
        this.verifyExpectedFirstAfterGoToNext = false;
        return result;
    }

    private PointerWithGeneration readPrevSibling() {
        return this.seekForward ? TreeNodeUtil.leftSibling(this.cursor, this.stableGeneration, this.unstableGeneration) : TreeNodeUtil.rightSibling(this.cursor, this.stableGeneration, this.unstableGeneration);
    }

    private PointerWithGeneration readNextSibling() {
        return this.seekForward ? TreeNodeUtil.rightSibling(this.cursor, this.stableGeneration, this.unstableGeneration) : TreeNodeUtil.leftSibling(this.cursor, this.stableGeneration, this.unstableGeneration);
    }

    private boolean readHeader() {
        this.nodeType = TreeNodeUtil.nodeType(this.cursor);
        if (this.nodeType != 1) {
            return false;
        }
        this.isInternal = TreeNodeUtil.isInternal(this.cursor);
        this.keyCount = TreeNodeUtil.keyCount(this.cursor);
        this.currentNodeGeneration = TreeNodeUtil.generation(this.cursor);
        this.successor = TreeNodeUtil.successor(this.cursor, this.stableGeneration, this.unstableGeneration);
        this.prevSibling = this.readPrevSibling();
        this.nextSibling = this.readNextSibling();
        this.forceReadHeader = false;
        return this.keyCountIsSane(this.keyCount);
    }

    private boolean endedUpOnUnWrongNode() {
        return this.nodeType != 1 || !this.verifyNodeGenerationInvariants();
    }

    private NextSiblingResult goToNextSibling() throws IOException {
        if (this.pointerCheckingWithGenerationCatchup(this.nextSibling.pointer(), true, this.seekForward ? "RIGHT_SIBLING" : "LEFT_SIBLING")) {
            return NextSiblingResult.RETRY_READ;
        }
        if (TreeNodeUtil.isNode(this.nextSibling.pointer())) {
            NextSiblingResult result = NextSiblingResult.FOLLOW;
            if (this.seekForward) {
                TreeNodeUtil.goTo(this.cursor, "sibling", this.nextSibling.pointer());
                this.lastFollowedPointerGeneration = this.nextSibling.generation();
                if (this.first) {
                    result = NextSiblingResult.RETRY_READ;
                } else {
                    this.forceReadHeader = true;
                    this.pos = -1;
                }
            } else if (this.scoutNextSibling()) {
                TreeNodeUtil.goTo(this.cursor, "sibling", this.nextSibling.pointer());
                this.verifyExpectedFirstAfterGoToNext = true;
                this.lastFollowedPointerGeneration = this.nextSibling.generation();
            } else {
                result = NextSiblingResult.RETRY_READ;
            }
            return result;
        }
        return NextSiblingResult.STOP;
    }

    private boolean scoutNextSibling() throws IOException {
        assert (!this.seekForward);
        assert (!this.isInternal);
        try (PageCursor scout = this.cursor.openLinkedCursor(GenerationSafePointerPair.pointer(this.nextSibling.pointer()));){
            scout.next();
            if (TreeNodeUtil.nodeType(scout) != 1) {
                boolean bl = false;
                return bl;
            }
            if (!TreeNodeUtil.isLeaf(scout)) {
                boolean bl = false;
                return bl;
            }
            int keyCount = TreeNodeUtil.keyCount(scout);
            if (keyCount <= 0 || keyCount > this.maxKeyCount) {
                boolean bl = false;
                return bl;
            }
            int firstPosInBackwardsSibling = keyCount - 1;
            this.leafNode.keyAt(scout, this.expectedFirstAfterGoToNext, firstPosInBackwardsSibling, this.cursorContext);
            if (this.cursor.shouldRetry()) {
                boolean bl = false;
                return bl;
            }
            PointerChecking.checkOutOfBounds(this.cursor);
        }
        return true;
    }

    private boolean isValueDefined(ValueHolder<VALUE> value) {
        return this.isInternal || value.defined;
    }

    private boolean keyCountIsSane(int keyCount) {
        return keyCount >= 0 && keyCount <= this.maxKeyCount;
    }

    private void prepareToStartFromRoot() throws IOException {
        this.generationCatchup();
        Root root = this.rootCatchup.catchupFrom(this.cursor.getCurrentPageId(), this.cursorContext);
        this.lastFollowedPointerGeneration = root.goTo(this.cursor);
        if (!this.first) {
            this.fromInclusive = this.layout.copyKey(this.prevKey);
        }
        this.cache.clear();
        this.resultOnTrack = false;
        this.pos = 0;
        this.keyCount = 0;
        this.verifyExpectedFirstAfterGoToNext = false;
        this.currentNodeGeneration = 0L;
        this.expectedCurrentNodeGeneration = 0L;
        this.nodeType = 0;
        this.successor = PointerWithGeneration.EMPTY;
        this.isInternal = false;
        this.nextSibling = PointerWithGeneration.EMPTY;
        this.prevSibling = PointerWithGeneration.EMPTY;
        this.forceReadHeader = false;
    }

    private boolean verifyNodeGenerationInvariants() {
        if (this.lastFollowedPointerGeneration != 0L) {
            if (this.currentNodeGeneration > this.lastFollowedPointerGeneration) {
                return false;
            }
            this.lastFollowedPointerGeneration = 0L;
            this.expectedCurrentNodeGeneration = this.currentNodeGeneration;
        } else if (this.currentNodeGeneration != this.expectedCurrentNodeGeneration) {
            return false;
        }
        return true;
    }

    private boolean pointerCheckingWithGenerationCatchup(long pointer, boolean allowNoNode, String pointerType) {
        if (!GenerationSafePointerPair.isSuccess(pointer)) {
            if (this.generationCatchup()) {
                return true;
            }
            PointerChecking.checkPointer(pointer, allowNoNode, this.cursor.getCurrentPageId(), pointerType, this.stableGeneration, this.unstableGeneration);
        }
        return false;
    }

    private boolean generationCatchup() {
        long newGeneration = this.generationSupplier.getAsLong();
        long newStableGeneration = Generation.stableGeneration(newGeneration);
        long newUnstableGeneration = Generation.unstableGeneration(newGeneration);
        if (newStableGeneration != this.stableGeneration || newUnstableGeneration != this.unstableGeneration) {
            this.stableGeneration = newStableGeneration;
            this.unstableGeneration = newUnstableGeneration;
            return true;
        }
        return false;
    }

    @Override
    public KEY key() {
        this.assertHasResult();
        return this.cache.currentKey();
    }

    @Override
    public VALUE value() {
        this.assertHasResult();
        ValueHolder value = this.cache.currentValue();
        assert (value.defined);
        return value.value;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.cursor.close();
            this.closed = true;
            this.ended = true;
        }
    }

    private void assertHasResult() {
        if (this.first) {
            throw new IllegalStateException("There has been no successful call to next() yet");
        }
        if (this.closed) {
            throw new IllegalStateException("This cursor is closed");
        }
    }

    @Override
    public void reinitializeToNewRange(KEY fromInclusive, KEY toExclusive) {
        if (!this.ended) {
            try {
                this.initialize(this.rootInitializer, this.rootCatchup, fromInclusive, this.toExclusive, this.cache.size(), this.searchLevel, this.monitor);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private class Cache {
        private KEY[] keys;
        private ValueHolder<VALUE>[] values;
        private int index;
        private int length;

        private Cache() {
        }

        private void init(int batchSize) {
            if (this.keys == null || batchSize > this.keys.length) {
                this.keys = new Object[batchSize];
                this.values = new ValueHolder[batchSize];
            }
            this.clear();
        }

        private void fill(int fromPos) throws IOException {
            int cacheIndex = 0;
            for (int readPos = fromPos; cacheIndex < this.keys.length && 0 <= readPos && readPos < SeekCursor.this.keyCount; ++cacheIndex, readPos += SeekCursor.this.stride) {
                this.initSlot(cacheIndex);
                this.readIntoSlot(cacheIndex, readPos);
                if (!SeekCursor.this.insideEndRange(SeekCursor.this.exactMatch, this.keys[cacheIndex])) break;
            }
            this.length = cacheIndex;
        }

        private void readIntoSlot(int index, int readPos) throws IOException {
            if (SeekCursor.this.isInternal) {
                SeekCursor.this.internalNode.keyAt(SeekCursor.this.cursor, this.keys[index], readPos, SeekCursor.this.cursorContext);
            } else {
                SeekCursor.this.leafNode.keyValueAt(SeekCursor.this.cursor, this.keys[index], this.values[index], readPos, SeekCursor.this.cursorContext);
            }
        }

        private void initSlot(int cacheIndex) {
            if (this.keys[cacheIndex] == null) {
                this.keys[cacheIndex] = SeekCursor.this.layout.newKey();
                this.values[cacheIndex] = new ValueHolder(SeekCursor.this.layout.newValue());
            }
        }

        private ValueHolder<VALUE> currentValue() {
            return this.values[this.index];
        }

        private KEY currentKey() {
            return this.keys[this.index];
        }

        private boolean hasNext() {
            return this.index + 1 < this.length;
        }

        private void next() {
            ++this.index;
        }

        private void clear() {
            this.index = -1;
            this.length = 0;
        }

        private int size() {
            return this.keys.length;
        }

        private boolean empty() {
            return this.length == 0;
        }
    }

    static interface Monitor {
        public void internalNode(int var1, int var2);

        public void leafNode(int var1, int var2);
    }

    private static enum NextSiblingResult {
        STOP,
        FOLLOW,
        RETRY_READ;

    }

    static class MonitorAdaptor
    implements Monitor {
        MonitorAdaptor() {
        }

        @Override
        public void internalNode(int depth, int keyCount) {
        }

        @Override
        public void leafNode(int depth, int keyCount) {
        }
    }
}

