/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.v202505.LogEntryStartV2025_05;
import org.neo4j.kernel.impl.transaction.log.entry.v42.LogEntryCommitV4_2;
import org.neo4j.kernel.impl.transaction.log.entry.v42.LogEntryStartV4_2;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryChunkStartV5_20;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryRollbackV5_20;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryStartV5_20;

public final class LogEntryFactory {
    private LogEntryFactory() {
    }

    public static LogEntryStart newStartEntry(KernelVersion version, long timeWritten, long lastCommittedTxWhenTransactionStarted, long appendIndex, int previousChecksum, byte[] additionalHeader) {
        if (version.isAtLeast(KernelVersion.V2025_05)) {
            return new LogEntryStartV2025_05(version, timeWritten, lastCommittedTxWhenTransactionStarted, appendIndex, additionalHeader);
        }
        if (version.isAtLeast(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED)) {
            return new LogEntryStartV5_20(version, timeWritten, lastCommittedTxWhenTransactionStarted, appendIndex, previousChecksum, additionalHeader);
        }
        return new LogEntryStartV4_2(version, timeWritten, lastCommittedTxWhenTransactionStarted, previousChecksum, additionalHeader);
    }

    public static LogEntryCommit newCommitEntry(KernelVersion version, long txId, long timeWritten, int checksum) {
        return new LogEntryCommitV4_2(version, txId, timeWritten, checksum);
    }

    public static AbstractVersionAwareLogEntry newRollbackEntry(KernelVersion kernelVersion, long transactionId, long appendIndex, long timeWritten) {
        return new LogEntryRollbackV5_20(kernelVersion, transactionId, appendIndex, timeWritten, 0);
    }

    public static LogEntry newChunkStartEntry(KernelVersion kernelVersion, long timeWritten, long chunkId, long appendIndex, long previousBatchAppendIndex) {
        return new LogEntryChunkStartV5_20(kernelVersion, timeWritten, chunkId, appendIndex, previousBatchAppendIndex);
    }
}

