/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.enveloped.InvalidLogEnvelopeReadException;

public record LogEnvelopeHeader(EnvelopeType type, long index, int payLoadLength, KernelVersion version, int previousChecksum, int payloadChecksum) {
    public static final int HEADER_SIZE = 31;
    public static final int MAX_ZERO_PADDING_SIZE = 39;
    public static final byte IGNORE_KERNEL_VERSION = -1;
    public static final byte UNSPECIFIED_CONTENT_TYPE = -1;
    public static final byte UNSPECIFIED_INDEX = -1;
    public static final byte UNSPECIFIED_TERM = -1;
    public static final byte KERNEL_CONTENT_TYPE = 64;

    public static enum EnvelopeType {
        ZERO(0),
        FULL(1),
        BEGIN(2),
        MIDDLE(3),
        END(4),
        START_OFFSET(5);

        private static final EnvelopeType[] VALUES;
        public final byte typeValue;

        private EnvelopeType(byte typeValue) {
            this.typeValue = typeValue;
        }

        public boolean isStarting() {
            return this == FULL || this == BEGIN;
        }

        public boolean isTerminating() {
            return this == FULL || this == END;
        }

        public static EnvelopeType of(byte type) throws InvalidLogEnvelopeReadException {
            try {
                return VALUES[type];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new InvalidLogEnvelopeReadException("Invalid envelope type: " + type);
            }
        }

        static {
            VALUES = EnvelopeType.values();
        }
    }
}

