/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v520;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryChunkStartV5_20;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class ChunkStartLogEntrySerializerV5_20
extends LogEntrySerializer<LogEntryChunkStartV5_20> {
    public ChunkStartLogEntrySerializerV5_20() {
        super((byte)10);
    }

    @Override
    public LogEntryChunkStartV5_20 parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory, MemoryTracker memoryTracker) throws IOException {
        long timeWritten = channel.getLong();
        long chunkId = channel.getLong();
        long previousBatchAppendIndex = channel.getLong();
        long appendIndex = channel.getAppendIndex();
        return new LogEntryChunkStartV5_20(version, timeWritten, chunkId, appendIndex, previousBatchAppendIndex);
    }

    @Override
    public int write(WritableChannel channel, LogEntryChunkStartV5_20 logEntry) throws IOException {
        channel.beginChecksumForWriting();
        ChunkStartLogEntrySerializerV5_20.writeLogEntryHeader(logEntry.kernelVersion(), (byte)10, channel);
        channel.putLong(logEntry.getTimeWritten()).putLong(logEntry.getChunkId()).putLong(logEntry.getPreviousBatchAppendIndex()).putAppendIndex(logEntry.getAppendIndex());
        return 0;
    }
}

