/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v520;

import java.util.Objects;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractDetachedCheckpointLogEntry;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.string.Mask;

public class LogEntryDetachedCheckpointV5_20
extends AbstractDetachedCheckpointLogEntry {
    private final TransactionId transactionId;
    private final long lastAppendIndex;
    private final boolean consensusIndexInCheckpoint;

    public LogEntryDetachedCheckpointV5_20(KernelVersion kernelVersion, TransactionId transactionId, long lastAppendIndex, LogPosition checkpointedLogPosition, long checkpointMillis, StoreId storeId, String reason) {
        super(kernelVersion, checkpointedLogPosition, checkpointMillis, storeId, reason);
        this.transactionId = transactionId;
        this.lastAppendIndex = lastAppendIndex;
        this.consensusIndexInCheckpoint = true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryDetachedCheckpointV5_20 that = (LogEntryDetachedCheckpointV5_20)o;
        return this.lastAppendIndex == that.lastAppendIndex && this.checkpointTime == that.checkpointTime && this.consensusIndexInCheckpoint == that.consensusIndexInCheckpoint && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.checkpointedLogPosition, that.checkpointedLogPosition) && Objects.equals(this.storeId, that.storeId) && Objects.equals(this.reason, that.reason);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.transactionId, this.lastAppendIndex, this.checkpointedLogPosition, this.checkpointTime, this.storeId, this.reason, this.consensusIndexInCheckpoint);
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public boolean consensusIndexInCheckpoint() {
        return this.consensusIndexInCheckpoint;
    }

    public long getLastAppendIndex() {
        return this.lastAppendIndex;
    }

    @Override
    public String toString(Mask mask) {
        return "LogEntryDetachedCheckpointV5_20{transactionId=" + String.valueOf(this.transactionId) + ", lastAppendIndex=" + this.lastAppendIndex + ", logPosition=" + String.valueOf(this.checkpointedLogPosition) + ", checkpointTime=" + this.checkpointTime + ", storeId=" + String.valueOf(this.storeId) + ", reason='" + this.reason + "', consensusIndexInCheckpoint=" + this.consensusIndexInCheckpoint + "}";
    }
}

