/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v57;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkStart;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class ChunkStartLogEntrySerializerV5_7
extends LogEntrySerializer<LogEntryChunkStart> {
    public ChunkStartLogEntrySerializerV5_7() {
        super((byte)10);
    }

    @Override
    public LogEntryChunkStart parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory, MemoryTracker memoryTracker) throws IOException {
        long timeWritten = channel.getLong();
        long chunkId = channel.getLong();
        long previousBatchAppendIndex = channel.getLong();
        return new LogEntryChunkStart(version, timeWritten, chunkId, previousBatchAppendIndex);
    }

    @Override
    public int write(WritableChannel channel, LogEntryChunkStart logEntry) throws IOException {
        channel.beginChecksumForWriting();
        ChunkStartLogEntrySerializerV5_7.writeLogEntryHeader(logEntry.kernelVersion(), (byte)10, channel);
        long previousBatchAppendIndex = logEntry.getPreviousBatchAppendIndex();
        channel.putLong(logEntry.getTimeWritten()).putLong(logEntry.getChunkId()).putLong(previousBatchAppendIndex);
        return 0;
    }
}

