/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogsRepository;
import org.neo4j.kernel.impl.transaction.log.enveloped.PruneStrategy;

class LogFilesPruner {
    private final LogsRepository logsRepository;
    private final PruneStrategy pruneStrategy;

    public LogFilesPruner(LogsRepository logsRepository, PruneStrategy pruneStrategy) {
        this.logsRepository = logsRepository;
        this.pruneStrategy = pruneStrategy;
    }

    long pruneUpTo(long desiredVersionToPrune, long currentIndex, long currentOffset, long version) throws IOException {
        long allowedVersion = -1L;
        PruneStrategy.PruneConstraint pruneConstraint = this.pruneStrategy.newConstraint(currentIndex, currentOffset, this.logsRepository.pathFor(version));
        long[] logVersions = this.logsRepository.logVersions(true);
        for (int i = 1; i < logVersions.length; ++i) {
            long v = logVersions[i];
            boolean shouldPrune = pruneConstraint.shouldPrune(this.logsRepository.pathFor(v));
            if (desiredVersionToPrune < v || !shouldPrune) continue;
            allowedVersion = v;
            break;
        }
        if (allowedVersion != -1L) {
            this.logsRepository.deleteLogFilesTo(allowedVersion);
        }
        return allowedVersion;
    }
}

