/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogPruningByEntryStrategy;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogPruningBySizeStrategy;
import org.neo4j.kernel.impl.transaction.log.enveloped.PruneStrategy;

public class LogPruningStrategies {
    private final FileSystemAbstraction fs;

    public LogPruningStrategies(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    public PruneStrategy fromKey(String key, long value) {
        return switch (key) {
            case "size" -> new LogPruningBySizeStrategy(this.fs, value);
            case "txs", "entries" -> new LogPruningByEntryStrategy(this.fs, value);
            case "false" -> PruneStrategy.NEVER_PRUNE;
            default -> throw new IllegalArgumentException("Unknown pruning strategy key: " + key);
        };
    }
}

