/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEnvelopeHeader;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogBinarySearch;

class SegmentBinarySearch
implements LogBinarySearch.BinarySearchReader {
    private final EnvelopeReadChannel envelopeReadChannel;
    private final ByteBuffer headerBuffer;
    private final int totalSegments;
    private final int segmentBlockSize;

    public SegmentBinarySearch(EnvelopeReadChannel envelopeReadChannel, int totalSegments, int segmentBlockSize) {
        this.envelopeReadChannel = envelopeReadChannel;
        this.headerBuffer = ByteBuffer.allocate(31).order(ByteOrder.LITTLE_ENDIAN);
        this.totalSegments = totalSegments;
        this.segmentBlockSize = segmentBlockSize;
    }

    @Override
    public int size() {
        return this.totalSegments - 1;
    }

    @Override
    public long get(int index) {
        return (long)(index + 1) * (long)this.segmentBlockSize;
    }

    @Override
    public int compare(long position, long target) {
        try {
            this.envelopeReadChannel.channel().position(position);
            try {
                EnvelopedHeader envelopedHeader = this.readHeader();
                LogEnvelopeHeader.EnvelopeType type = envelopedHeader.type;
                long entryIndex = envelopedHeader.entryIndex;
                return switch (type) {
                    default -> throw new MatchException(null, null);
                    case LogEnvelopeHeader.EnvelopeType.START_OFFSET, LogEnvelopeHeader.EnvelopeType.ZERO -> 1;
                    case LogEnvelopeHeader.EnvelopeType.BEGIN, LogEnvelopeHeader.EnvelopeType.FULL -> Long.compare(entryIndex, target);
                    case LogEnvelopeHeader.EnvelopeType.END, LogEnvelopeHeader.EnvelopeType.MIDDLE -> entryIndex >= target ? 1 : -1;
                };
            }
            catch (BufferUnderflowException | ReadPastEndException e) {
                return 1;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private EnvelopedHeader readHeader() throws IOException {
        this.headerBuffer.clear();
        this.envelopeReadChannel.channel().read(this.headerBuffer);
        this.headerBuffer.flip();
        this.headerBuffer.getInt();
        LogEnvelopeHeader.EnvelopeType type = LogEnvelopeHeader.EnvelopeType.of(this.headerBuffer.get());
        this.headerBuffer.getInt();
        long entryIndex = this.headerBuffer.getLong();
        return new EnvelopedHeader(type, entryIndex);
    }

    private record EnvelopedHeader(LogEnvelopeHeader.EnvelopeType type, long entryIndex) {
    }
}

