/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.nio.file.Path;
import org.neo4j.kernel.impl.transaction.log.files.LogRangeInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;

public class RangeLogVersionVisitor
implements LogVersionVisitor {
    public static final long UNKNOWN = -1L;
    private long lowestVersion = -1L;
    private Path lowestFile;
    private long highestVersion = -1L;
    private Path highestFile;

    @Override
    public void visit(Path file, long logVersion) {
        if (logVersion > this.highestVersion) {
            this.highestVersion = logVersion;
            this.highestFile = file;
        }
        if (this.lowestVersion == -1L || logVersion < this.lowestVersion) {
            this.lowestVersion = logVersion;
            this.lowestFile = file;
        }
    }

    public LogRangeInfo getLogRangeInfo() {
        return new LogRangeInfo(this.lowestVersion, this.lowestFile, this.highestVersion, this.highestFile);
    }
}

