/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Map;
import java.util.Optional;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;

public interface AllIndexProviderDescriptors {
    public static final IndexProviderDescriptor UNDECIDED = new IndexProviderDescriptor("Undecided", "0");
    public static final IndexProviderDescriptor TOKEN_DESCRIPTOR = new IndexProviderDescriptor("token-lookup", "1.0");
    public static final IndexProviderDescriptor POINT_DESCRIPTOR = new IndexProviderDescriptor("point", "1.0");
    public static final IndexProviderDescriptor RANGE_DESCRIPTOR = new IndexProviderDescriptor("range", "1.0");
    public static final IndexProviderDescriptor FULLTEXT_V1_DESCRIPTOR = new IndexProviderDescriptor("fulltext", "1.0");
    public static final IndexProviderDescriptor FULLTEXT_V2_DESCRIPTOR;
    public static final IndexProviderDescriptor DEFAULT_FULLTEXT_DESCRIPTOR;
    public static final IndexProviderDescriptor TEXT_V1_DESCRIPTOR;
    public static final IndexProviderDescriptor TEXT_V2_DESCRIPTOR;
    public static final IndexProviderDescriptor TEXT_V3_DESCRIPTOR;
    public static final IndexProviderDescriptor DEFAULT_TEXT_DESCRIPTOR;
    public static final IndexProviderDescriptor VECTOR_V1_DESCRIPTOR;
    public static final IndexProviderDescriptor VECTOR_V2_DESCRIPTOR;
    public static final IndexProviderDescriptor VECTOR_V3_DESCRIPTOR;
    public static final IndexProviderDescriptor DEFAULT_VECTOR_DESCRIPTOR;
    public static final Map<IndexProviderDescriptor, IndexType> INDEX_TYPES;
    public static final Map<IndexType, IndexProviderDescriptor> LATEST_INDEX_PROVIDERS;

    public static Optional<ProviderDescriptorDetails> providerDescriptorDetails(String providerName) {
        for (Map.Entry<IndexProviderDescriptor, IndexType> entry : INDEX_TYPES.entrySet()) {
            if (!entry.getKey().name().equals(providerName)) continue;
            return Optional.of(new ProviderDescriptorDetails(entry.getKey(), entry.getValue()));
        }
        return Optional.empty();
    }

    static {
        DEFAULT_FULLTEXT_DESCRIPTOR = FULLTEXT_V2_DESCRIPTOR = new IndexProviderDescriptor("fulltext", "2.0");
        TEXT_V1_DESCRIPTOR = new IndexProviderDescriptor("text", "1.0");
        TEXT_V2_DESCRIPTOR = new IndexProviderDescriptor("text", "2.0");
        DEFAULT_TEXT_DESCRIPTOR = TEXT_V3_DESCRIPTOR = new IndexProviderDescriptor("text", "3.0");
        VECTOR_V1_DESCRIPTOR = new IndexProviderDescriptor("vector", "1.0");
        VECTOR_V2_DESCRIPTOR = new IndexProviderDescriptor("vector", "2.0");
        DEFAULT_VECTOR_DESCRIPTOR = VECTOR_V3_DESCRIPTOR = new IndexProviderDescriptor("vector", "3.0");
        INDEX_TYPES = Map.ofEntries(Map.entry(FULLTEXT_V1_DESCRIPTOR, IndexType.FULLTEXT), Map.entry(FULLTEXT_V2_DESCRIPTOR, IndexType.FULLTEXT), Map.entry(TOKEN_DESCRIPTOR, IndexType.LOOKUP), Map.entry(TEXT_V1_DESCRIPTOR, IndexType.TEXT), Map.entry(TEXT_V2_DESCRIPTOR, IndexType.TEXT), Map.entry(TEXT_V3_DESCRIPTOR, IndexType.TEXT), Map.entry(RANGE_DESCRIPTOR, IndexType.RANGE), Map.entry(POINT_DESCRIPTOR, IndexType.POINT), Map.entry(VECTOR_V1_DESCRIPTOR, IndexType.VECTOR), Map.entry(VECTOR_V2_DESCRIPTOR, IndexType.VECTOR), Map.entry(VECTOR_V3_DESCRIPTOR, IndexType.VECTOR));
        LATEST_INDEX_PROVIDERS = Map.of(IndexType.FULLTEXT, FULLTEXT_V2_DESCRIPTOR, IndexType.LOOKUP, TOKEN_DESCRIPTOR, IndexType.TEXT, TEXT_V3_DESCRIPTOR, IndexType.RANGE, RANGE_DESCRIPTOR, IndexType.POINT, POINT_DESCRIPTOR, IndexType.VECTOR, VECTOR_V3_DESCRIPTOR);
    }

    public record ProviderDescriptorDetails(IndexProviderDescriptor descriptor, IndexType type) {
    }
}

