/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedMap;
import java.util.function.Supplier;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.factory.SortedMaps;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.api.tuple.Pair;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;

public final class IndexConfig {
    private static final IndexConfig EMPTY = new IndexConfig((ImmutableSortedMap<String, Value>)SortedMaps.immutable.empty());
    private final ImmutableSortedMap<String, Value> map;

    private IndexConfig(ImmutableSortedMap<String, Value> map) {
        this.map = map;
    }

    public static IndexConfig empty() {
        return EMPTY;
    }

    public static IndexConfig with(String key, Value value) {
        return new IndexConfig((ImmutableSortedMap<String, Value>)SortedMaps.immutable.with(String.CASE_INSENSITIVE_ORDER, (Object)key, (Object)value));
    }

    public static IndexConfig with(Map<String, Value> map) {
        for (Value value : map.values()) {
            IndexConfig.validate(value);
        }
        return new IndexConfig((ImmutableSortedMap<String, Value>)SortedMaps.mutable.with(String.CASE_INSENSITIVE_ORDER).withMap(map).toImmutable());
    }

    private static void validate(Value value) {
        ValueCategory category = value.valueGroup().category();
        switch (category) {
            case GEOMETRY: 
            case GEOMETRY_ARRAY: 
            case TEMPORAL: 
            case TEMPORAL_ARRAY: 
            case UNKNOWN: 
            case NO_CATEGORY: {
                throw new IllegalArgumentException("Value type not support in index configuration: " + String.valueOf(value) + ".");
            }
        }
    }

    public IndexConfig withIfAbsent(String key, Value value) {
        IndexConfig.validate(value);
        if (this.map.containsKey((Object)key)) {
            return this;
        }
        return new IndexConfig((ImmutableSortedMap<String, Value>)this.map.newWithKeyValue((Object)key, (Object)value));
    }

    public <T extends Value> T get(String key) {
        return (T)((Value)this.map.get((Object)key));
    }

    public <T extends Value> T getOrDefault(String key, T defaultValue) {
        T value = this.get(key);
        return value != null ? value : defaultValue;
    }

    public <T extends Value> T getOrThrow(String key) {
        return this.getOrThrow(key, () -> new NoSuchElementException("'%s' is not set".formatted(key)));
    }

    public <T extends Value, E extends Throwable> T getOrThrow(String key, Supplier<? extends E> exceptionSupplier) throws E {
        T value = this.get(key);
        if (value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return value;
    }

    public RichIterable<Pair<String, Value>> entries() {
        return this.map.keyValuesView();
    }

    public SortedMap<String, Value> asMap() {
        return this.map.castToMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexConfig)) {
            return false;
        }
        IndexConfig that = (IndexConfig)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IndexConfig[");
        for (Pair entry : this.entries()) {
            sb.append((String)entry.getOne()).append(" -> ").append(entry.getTwo()).append(", ");
        }
        if (!this.map.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }
}

