/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.List;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaCommandUtils;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.token.TokenHolders;

public sealed interface SchemaCommand {
    public String name();

    public static class SchemaCommandReaderException
    extends RuntimeException {
        public SchemaCommandReaderException(String message) {
            super(message);
        }

        public SchemaCommandReaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static sealed interface ConstraintCommand
    extends SchemaCommand {

        public static sealed interface Create
        extends ConstraintCommand {
            public EntityType entityType();

            public ConstraintType constraintType();

            public boolean ifNotExists();

            public boolean hasBackingIndex();

            public ConstraintPrototype toPrototype(TokenHolders var1);

            public record RelationshipPropertyType(String name, String type, String property, PropertyTypeSet propertyTypes, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.PROPERTY_TYPE;
                }

                @Override
                public boolean hasBackingIndex() {
                    return false;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertyForName(this.property));
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.typeForSchema(schema, this.propertyTypes, false), (TokenNameLookup)tokenHolders);
                    return new ConstraintPrototype(constraintDescriptor);
                }
            }

            public record RelationshipKey(String name, String type, List<String> properties, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.UNIQUE_EXISTS;
                }

                @Override
                public boolean hasBackingIndex() {
                    return true;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertiesForName(this.properties));
                    IndexPrototype backingIndex = SchemaCommandUtils.backingIndex(schema);
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.keyForSchema(schema, backingIndex.getIndexType()), (TokenNameLookup)tokenHolders);
                    return new ConstraintPrototype(constraintDescriptor, backingIndex.withName(constraintDescriptor.getName()));
                }
            }

            public record RelationshipExistence(String name, String type, String property, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.EXISTS;
                }

                @Override
                public boolean hasBackingIndex() {
                    return false;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertyForName(this.property));
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.existsForSchema(schema, false), (TokenNameLookup)tokenHolders);
                    return new ConstraintPrototype(constraintDescriptor);
                }
            }

            public record RelationshipUniqueness(String name, String type, List<String> properties, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.UNIQUE;
                }

                @Override
                public boolean hasBackingIndex() {
                    return true;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertiesForName(this.properties));
                    IndexPrototype backingIndex = SchemaCommandUtils.backingIndex(schema);
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.uniqueForSchema(schema, backingIndex.getIndexType()), (TokenNameLookup)tokenHolders);
                    return new ConstraintPrototype(constraintDescriptor, backingIndex.withName(constraintDescriptor.getName()));
                }
            }

            public record NodePropertyType(String name, String label, String property, PropertyTypeSet propertyTypes, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.PROPERTY_TYPE;
                }

                @Override
                public boolean hasBackingIndex() {
                    return false;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    LabelSchemaDescriptor schema = SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertyForName(this.property));
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.typeForSchema(schema, this.propertyTypes, false), (TokenNameLookup)tokenHolders);
                    return new ConstraintPrototype(constraintDescriptor);
                }
            }

            public record NodeKey(String name, String label, List<String> properties, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.UNIQUE_EXISTS;
                }

                @Override
                public boolean hasBackingIndex() {
                    return true;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    LabelSchemaDescriptor schema = SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertiesForName(this.properties));
                    IndexPrototype backingIndex = SchemaCommandUtils.backingIndex(schema);
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.keyForSchema(schema, backingIndex.getIndexType()), (TokenNameLookup)tokenHolders);
                    return new ConstraintPrototype(constraintDescriptor, backingIndex.withName(constraintDescriptor.getName()));
                }
            }

            public record NodeExistence(String name, String label, String property, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.EXISTS;
                }

                @Override
                public boolean hasBackingIndex() {
                    return false;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    LabelSchemaDescriptor schema = SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertyForName(this.property));
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.existsForSchema(schema, false), (TokenNameLookup)tokenHolders);
                    return new ConstraintPrototype(constraintDescriptor);
                }
            }

            public record NodeUniqueness(String name, String label, List<String> properties, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.UNIQUE;
                }

                @Override
                public boolean hasBackingIndex() {
                    return true;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    LabelSchemaDescriptor schema = SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertiesForName(this.properties));
                    IndexPrototype backingIndex = SchemaCommandUtils.backingIndex(schema);
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.uniqueForSchema(schema, backingIndex.getIndexType()), (TokenNameLookup)tokenHolders);
                    return new ConstraintPrototype(constraintDescriptor, backingIndex.withName(constraintDescriptor.getName()));
                }
            }

            public record ConstraintPrototype(ConstraintDescriptor descriptor, IndexPrototype backingIndex) {
                public ConstraintPrototype(ConstraintDescriptor descriptor) {
                    this(descriptor, null);
                }
            }
        }

        public record Drop(String name, boolean ifExists) implements ConstraintCommand
        {
        }
    }

    public static sealed interface IndexCommand
    extends SchemaCommand {

        public static sealed interface Create
        extends IndexCommand {
            public EntityType entityType();

            public IndexType indexType();

            public boolean ifNotExists();

            public IndexPrototype toPrototype(TokenHolders var1);

            public record RelationshipVector(String name, String type, String property, boolean ifNotExists, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.VECTOR;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.DEFAULT_VECTOR_DESCRIPTOR).withIndexConfig(this.config), (TokenNameLookup)tokenHolders);
                }
            }

            public record NodeVector(String name, String label, String property, boolean ifNotExists, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.VECTOR;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.DEFAULT_VECTOR_DESCRIPTOR).withIndexConfig(this.config), (TokenNameLookup)tokenHolders);
                }
            }

            public record RelationshipFulltext(String name, List<String> types, List<String> properties, boolean ifNotExists, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.FULLTEXT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forSemanticSearch(EntityType.RELATIONSHIP, tokenHolders.relationshipsForNames(this.types), tokenHolders.propertiesForName(this.properties)), AllIndexProviderDescriptors.DEFAULT_FULLTEXT_DESCRIPTOR).withIndexConfig(this.config), (TokenNameLookup)tokenHolders);
                }
            }

            public record NodeFulltext(String name, List<String> labels, List<String> properties, boolean ifNotExists, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.FULLTEXT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forSemanticSearch(EntityType.NODE, tokenHolders.labelsForNames(this.labels), tokenHolders.propertiesForName(this.properties)), AllIndexProviderDescriptors.DEFAULT_FULLTEXT_DESCRIPTOR).withIndexConfig(this.config), (TokenNameLookup)tokenHolders);
                }
            }

            public record RelationshipLookup(String name, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.LOOKUP;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forAnyEntityTokens(EntityType.RELATIONSHIP), AllIndexProviderDescriptors.TOKEN_DESCRIPTOR), (TokenNameLookup)tokenHolders);
                }
            }

            public record NodeLookup(String name, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.LOOKUP;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forAnyEntityTokens(EntityType.NODE), AllIndexProviderDescriptors.TOKEN_DESCRIPTOR), (TokenNameLookup)tokenHolders);
                }
            }

            public record RelationshipPoint(String name, String type, String property, boolean ifNotExists, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.POINT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.POINT_DESCRIPTOR).withIndexConfig(this.config), (TokenNameLookup)tokenHolders);
                }
            }

            public record NodePoint(String name, String label, String property, boolean ifNotExists, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.POINT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.POINT_DESCRIPTOR).withIndexConfig(this.config), (TokenNameLookup)tokenHolders);
                }
            }

            public record RelationshipText(String name, String type, String property, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.TEXT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.DEFAULT_TEXT_DESCRIPTOR), (TokenNameLookup)tokenHolders);
                }
            }

            public record NodeText(String name, String label, String property, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.TEXT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.DEFAULT_TEXT_DESCRIPTOR), (TokenNameLookup)tokenHolders);
                }
            }

            public record RelationshipRange(String name, String type, List<String> properties, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.RANGE;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertiesForName(this.properties)), AllIndexProviderDescriptors.RANGE_DESCRIPTOR), (TokenNameLookup)tokenHolders);
                }
            }

            public record NodeRange(String name, String label, List<String> properties, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.RANGE;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertiesForName(this.properties)), AllIndexProviderDescriptors.RANGE_DESCRIPTOR), (TokenNameLookup)tokenHolders);
                }
            }
        }

        public record Drop(String name, boolean ifExists) implements IndexCommand
        {
        }
    }
}

