/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.NodeLabelExistenceSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.RelationshipEndpointLabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaPatternMatchingType;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.internal.schema.SemanticSearchSchemaDescriptor;
import org.neo4j.lock.ResourceType;

public final class SchemaDescriptorImplementation
implements SchemaDescriptor,
LabelSchemaDescriptor,
RelationTypeSchemaDescriptor,
SemanticSearchSchemaDescriptor,
AnyTokenSchemaDescriptor,
RelationshipEndpointLabelSchemaDescriptor,
NodeLabelExistenceSchemaDescriptor {
    public static final int TOKEN_INDEX_LOCKING_ID = Integer.MAX_VALUE;
    public static final long[] TOKEN_INDEX_LOCKING_IDS = new long[]{Integer.MAX_VALUE};
    private final EntityType entityType;
    private final SchemaPatternMatchingType schemaPatternMatchingType;
    private final int[] entityTokens;
    private final int[] propertyKeyIds;
    private final SchemaArchetype schemaArchetype;

    public SchemaDescriptorImplementation(EntityType entityType, SchemaPatternMatchingType schemaPatternMatchingType, int[] entityTokens, int[] propertyKeyIds) {
        this.entityType = Objects.requireNonNull(entityType, "EntityType cannot be null.");
        this.schemaPatternMatchingType = Objects.requireNonNull(schemaPatternMatchingType, "Schema pattern matching type cannot be null.");
        this.entityTokens = Objects.requireNonNull(entityTokens, "Entity tokens array cannot be null.");
        this.propertyKeyIds = Objects.requireNonNull(propertyKeyIds, "Property key ids array cannot be null.");
        switch (schemaPatternMatchingType) {
            case SINGLE_ENTITY_TOKEN: {
                SchemaDescriptorImplementation.validateSingleEntityTokenSchema(entityTokens, propertyKeyIds);
                break;
            }
            case ENTITY_TOKENS: {
                SchemaDescriptorImplementation.validateEntityTokensSchema(entityType, entityTokens, propertyKeyIds);
                break;
            }
            default: {
                SchemaDescriptorImplementation.validatePropertySchema(entityType, entityTokens, propertyKeyIds);
            }
        }
        this.schemaArchetype = this.detectArchetype(entityType, schemaPatternMatchingType, entityTokens);
    }

    private static void validateSingleEntityTokenSchema(int[] entityTokens, int[] propertyKeyIds) {
        if (entityTokens.length != 1) {
            throw new IllegalArgumentException("Schema descriptor of schema pattern matching type " + String.valueOf((Object)SchemaPatternMatchingType.SINGLE_ENTITY_TOKEN) + " must have exactly one entity token.");
        }
        if (entityTokens[0] < 0) {
            throw new IllegalArgumentException("Schema descriptor of schema pattern matching type " + String.valueOf((Object)SchemaPatternMatchingType.SINGLE_ENTITY_TOKEN) + " must not have a negative entity token id");
        }
        if (propertyKeyIds.length != 0) {
            throw new IllegalArgumentException("Schema descriptor of schema pattern matching type " + String.valueOf((Object)SchemaPatternMatchingType.SINGLE_ENTITY_TOKEN) + " must not have any property key ids");
        }
    }

    private SchemaArchetype detectArchetype(EntityType entityType, SchemaPatternMatchingType schemaPatternMatchingType, int[] entityTokens) {
        if (entityTokens.length == 1 && schemaPatternMatchingType == SchemaPatternMatchingType.COMPLETE_ALL_TOKENS) {
            if (entityType == EntityType.NODE) {
                return SchemaArchetype.LABEL_PROPERTY;
            }
            if (entityType == EntityType.RELATIONSHIP) {
                return SchemaArchetype.RELATIONSHIP_PROPERTY;
            }
        } else {
            if (schemaPatternMatchingType == SchemaPatternMatchingType.PARTIAL_ANY_TOKEN) {
                return SchemaArchetype.MULTI_TOKEN;
            }
            if (schemaPatternMatchingType == SchemaPatternMatchingType.ENTITY_TOKENS) {
                return SchemaArchetype.ANY_TOKEN;
            }
            if (schemaPatternMatchingType == SchemaPatternMatchingType.SINGLE_ENTITY_TOKEN) {
                if (entityType == EntityType.RELATIONSHIP) {
                    return SchemaArchetype.SINGLE_RELATIONSHIP;
                }
                if (entityType == EntityType.NODE) {
                    return SchemaArchetype.SINGLE_LABEL;
                }
            }
        }
        throw new IllegalArgumentException("Can't detect schema archetype for arguments: " + String.valueOf(entityType) + " " + String.valueOf((Object)schemaPatternMatchingType) + " " + Arrays.toString(entityTokens));
    }

    private static void validatePropertySchema(EntityType entityType, int[] entityTokens, int[] propertyKeyIds) {
        if (entityTokens.length == 0) {
            throw new IllegalArgumentException("Schema descriptor must have at least one " + (entityType == EntityType.NODE ? "label." : "relationship type."));
        }
        if (propertyKeyIds.length == 0) {
            throw new IllegalArgumentException("Schema descriptor must have at least one property key id.");
        }
        switch (entityType) {
            case NODE: {
                SchemaDescriptorImplementation.validateLabelIds(entityTokens);
                break;
            }
            case RELATIONSHIP: {
                SchemaDescriptorImplementation.validateRelationshipTypeIds(entityTokens);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown entity type: " + String.valueOf(entityType) + ".");
            }
        }
        SchemaDescriptorImplementation.validatePropertyIds(propertyKeyIds);
    }

    private static void validateEntityTokensSchema(EntityType entityType, int[] entityTokens, int[] propertyKeyIds) {
        if (entityTokens.length != 0) {
            throw new IllegalArgumentException("Schema descriptor with schema pattern matching type " + String.valueOf((Object)SchemaPatternMatchingType.ENTITY_TOKENS) + " should not have any specified " + (entityType == EntityType.NODE ? "labels." : "relationship types."));
        }
        if (propertyKeyIds.length != 0) {
            throw new IllegalArgumentException("Schema descriptor with schema pattern matching type " + String.valueOf((Object)SchemaPatternMatchingType.ENTITY_TOKENS) + " should not have any specified property key ids.");
        }
    }

    private static void validatePropertyIds(int ... propertyIds) {
        for (int propertyId : propertyIds) {
            if (-1 != propertyId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent property.");
        }
    }

    private static void validateRelationshipTypeIds(int ... relTypes) {
        for (int relType : relTypes) {
            if (-1 != relType) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent relationship type.");
        }
    }

    private static void validateLabelIds(int ... labelIds) {
        for (int labelId : labelIds) {
            if (-1 != labelId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent label.");
        }
    }

    @Override
    public boolean isLabelSchemaDescriptor() {
        return this.schemaArchetype == SchemaArchetype.LABEL_PROPERTY;
    }

    @Override
    public LabelSchemaDescriptor asLabelSchemaDescriptor() {
        if (this.schemaArchetype != SchemaArchetype.LABEL_PROPERTY) {
            throw this.cannotCastException("LabelSchemaDescriptor");
        }
        return this;
    }

    @Override
    public boolean isRelationshipTypeSchemaDescriptor() {
        return this.schemaArchetype == SchemaArchetype.RELATIONSHIP_PROPERTY;
    }

    @Override
    public RelationTypeSchemaDescriptor asRelationshipTypeSchemaDescriptor() {
        if (this.schemaArchetype != SchemaArchetype.RELATIONSHIP_PROPERTY) {
            throw this.cannotCastException("RelationTypeSchemaDescriptor");
        }
        return this;
    }

    @Override
    public boolean isSemanticSearchSchemaDescriptor() {
        return this.schemaArchetype == SchemaArchetype.MULTI_TOKEN;
    }

    @Override
    public SemanticSearchSchemaDescriptor asSemanticSearchSchemaDescritor() {
        if (this.schemaArchetype != SchemaArchetype.MULTI_TOKEN) {
            throw this.cannotCastException("FulltextSchemaDescriptor");
        }
        return this;
    }

    @Override
    public boolean isAnyTokenSchemaDescriptor() {
        return this.schemaArchetype == SchemaArchetype.ANY_TOKEN;
    }

    @Override
    public AnyTokenSchemaDescriptor asAnyTokenSchemaDescriptor() {
        if (this.schemaArchetype != SchemaArchetype.ANY_TOKEN) {
            throw this.cannotCastException("AnyTokenSchemaDescriptor");
        }
        return this;
    }

    @Override
    public boolean isRelationshipEndpointLabelDescriptor() {
        return this.schemaArchetype == SchemaArchetype.SINGLE_RELATIONSHIP;
    }

    @Override
    public RelationshipEndpointLabelSchemaDescriptor asRelationshipEndpointLabelDescriptor() {
        if (this.schemaArchetype != SchemaArchetype.SINGLE_RELATIONSHIP) {
            throw this.cannotCastException("RelationshipEndpointLabelSchemaDescriptor");
        }
        return this;
    }

    @Override
    public boolean isNodeLabelExistenceSchemaDescriptor() {
        return this.schemaArchetype == SchemaArchetype.SINGLE_LABEL;
    }

    @Override
    public NodeLabelExistenceSchemaDescriptor asNodeLabelExistenceSchemaDescriptor() {
        if (this.schemaArchetype != SchemaArchetype.SINGLE_LABEL) {
            throw this.cannotCastException("NodeLabelExistenceSchemaDescriptor");
        }
        return this;
    }

    private IllegalStateException cannotCastException(String descriptorType) {
        return new IllegalStateException("Cannot cast this schema to a " + descriptorType + " because it does not match that structure: " + String.valueOf(this) + ".");
    }

    @Override
    public boolean isAffected(int[] entityTokenIds) {
        for (int id : this.entityTokens) {
            if (!ArrayUtils.contains((int[])entityTokenIds, (int)id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return SchemaUserDescription.forSchema(tokenNameLookup, this.entityType, this.entityTokens, this.propertyKeyIds);
    }

    @Override
    public int[] getPropertyIds() {
        return this.propertyKeyIds;
    }

    @Override
    public int[] getEntityTokenIds() {
        return this.entityTokens;
    }

    @Override
    public ResourceType keyType() {
        return this.entityType == EntityType.NODE ? ResourceType.LABEL : ResourceType.RELATIONSHIP_TYPE;
    }

    @Override
    public EntityType entityType() {
        return this.entityType;
    }

    @Override
    public SchemaPatternMatchingType schemaPatternMatchingType() {
        return this.schemaPatternMatchingType;
    }

    @Override
    public long[] lockingKeys() {
        if (this.isAnyTokenSchemaDescriptor()) {
            return TOKEN_INDEX_LOCKING_IDS;
        }
        int[] tokenIds = this.getEntityTokenIds();
        int tokenCount = tokenIds.length;
        long[] lockingIds = new long[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            lockingIds[i] = tokenIds[i];
        }
        Arrays.sort(lockingIds);
        return lockingIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaDescriptor)) {
            return false;
        }
        SchemaDescriptor that = (SchemaDescriptor)o;
        return this.entityType == that.entityType() && SchemaDescriptorImplementation.effectiveSchemaPatternMatchingTypeFeature(this.schemaPatternMatchingType, this.propertyKeyIds) == SchemaDescriptorImplementation.effectiveSchemaPatternMatchingTypeFeature(that.schemaPatternMatchingType(), that.getPropertyIds()) && Arrays.equals(this.entityTokens, that.getEntityTokenIds()) && Arrays.equals(this.propertyKeyIds, that.getPropertyIds());
    }

    public int hashCode() {
        int result = this.entityType.hashCode();
        result = 31 * result + SchemaDescriptorImplementation.effectiveSchemaPatternMatchingTypeFeature(this.schemaPatternMatchingType, this.propertyKeyIds);
        result = 31 * result + Arrays.hashCode(this.entityTokens);
        result = 31 * result + Arrays.hashCode(this.propertyKeyIds);
        return result;
    }

    public String toString() {
        return this.userDescription(SchemaUserDescription.TOKEN_ID_NAME_LOOKUP);
    }

    static int effectiveSchemaPatternMatchingTypeFeature(SchemaPatternMatchingType schemaPatternMatchingType, int ... propertyKeyIds) {
        return SchemaDescriptorImplementation.shouldMatchSinglePropertyKey(schemaPatternMatchingType, propertyKeyIds) ? 1 << SchemaPatternMatchingType.COMPLETE_ALL_TOKENS.ordinal() | 1 << SchemaPatternMatchingType.PARTIAL_ANY_TOKEN.ordinal() : 1 << schemaPatternMatchingType.ordinal();
    }

    private static boolean shouldMatchSinglePropertyKey(SchemaPatternMatchingType schemaPatternMatchingType, int ... propertyKeyIds) {
        return propertyKeyIds.length == 1 && (schemaPatternMatchingType == SchemaPatternMatchingType.COMPLETE_ALL_TOKENS || schemaPatternMatchingType == SchemaPatternMatchingType.PARTIAL_ANY_TOKEN);
    }

    private static enum SchemaArchetype {
        LABEL_PROPERTY,
        RELATIONSHIP_PROPERTY,
        MULTI_TOKEN,
        ANY_TOKEN,
        SINGLE_RELATIONSHIP,
        SINGLE_LABEL;

    }
}

