/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.NoSchemaDescriptor;
import org.neo4j.internal.schema.NodeLabelExistenceSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.RelationshipEndpointLabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorImplementation;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaPatternMatchingType;
import org.neo4j.internal.schema.SemanticSearchSchemaDescriptor;

public class SchemaDescriptors {
    public static final AnyTokenSchemaDescriptor ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR = new SchemaDescriptorImplementation(EntityType.NODE, SchemaPatternMatchingType.ENTITY_TOKENS, ArrayUtils.EMPTY_INT_ARRAY, ArrayUtils.EMPTY_INT_ARRAY);
    public static final AnyTokenSchemaDescriptor ANY_TOKEN_RELATIONSHIP_SCHEMA_DESCRIPTOR = new SchemaDescriptorImplementation(EntityType.RELATIONSHIP, SchemaPatternMatchingType.ENTITY_TOKENS, ArrayUtils.EMPTY_INT_ARRAY, ArrayUtils.EMPTY_INT_ARRAY);

    public static SchemaDescriptor noSchema() {
        return NoSchemaDescriptor.NO_SCHEMA;
    }

    public static SemanticSearchSchemaDescriptor forSemanticSearch(EntityType entityType, int[] entityTokenIds, int[] propertyKeyIds) {
        return new SchemaDescriptorImplementation(entityType, SchemaPatternMatchingType.PARTIAL_ANY_TOKEN, entityTokenIds, propertyKeyIds);
    }

    public static LabelSchemaDescriptor forLabel(int labelId, int ... propertyIds) {
        SchemaDescriptors.validateLabelIds(labelId);
        SchemaDescriptors.validatePropertyIds(propertyIds);
        return new SchemaDescriptorImplementation(EntityType.NODE, SchemaPatternMatchingType.COMPLETE_ALL_TOKENS, new int[]{labelId}, propertyIds);
    }

    public static RelationTypeSchemaDescriptor forRelType(int relTypeId, int ... propertyIds) {
        SchemaDescriptors.validateRelationshipTypeIds(relTypeId);
        SchemaDescriptors.validatePropertyIds(propertyIds);
        return new SchemaDescriptorImplementation(EntityType.RELATIONSHIP, SchemaPatternMatchingType.COMPLETE_ALL_TOKENS, new int[]{relTypeId}, propertyIds);
    }

    public static AnyTokenSchemaDescriptor forAnyEntityTokens(EntityType entityType) {
        return switch (entityType) {
            default -> throw new MatchException(null, null);
            case EntityType.NODE -> ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR;
            case EntityType.RELATIONSHIP -> ANY_TOKEN_RELATIONSHIP_SCHEMA_DESCRIPTOR;
        };
    }

    public static RelationshipEndpointLabelSchemaDescriptor forRelationshipEndpointLabel(int relationshipTypeId) {
        return new SchemaDescriptorImplementation(EntityType.RELATIONSHIP, SchemaPatternMatchingType.SINGLE_ENTITY_TOKEN, new int[]{relationshipTypeId}, ArrayUtils.EMPTY_INT_ARRAY);
    }

    public static NodeLabelExistenceSchemaDescriptor forNodeLabelExistence(int labelId) {
        return new SchemaDescriptorImplementation(EntityType.NODE, SchemaPatternMatchingType.SINGLE_ENTITY_TOKEN, new int[]{labelId}, ArrayUtils.EMPTY_INT_ARRAY);
    }

    public static <T extends SchemaDescriptorSupplier> Predicate<T> equalTo(SchemaDescriptor descriptor) {
        return supplier -> descriptor.equals(supplier.schema());
    }

    private static void validatePropertyIds(int[] propertyIds) {
        for (int propertyId : propertyIds) {
            if (-1 != propertyId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent property.");
        }
    }

    private static void validateRelationshipTypeIds(int ... relTypes) {
        for (int relType : relTypes) {
            if (-1 != relType) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent relationship type.");
        }
    }

    private static void validateLabelIds(int ... labelIds) {
        for (int labelId : labelIds) {
            if (-1 != labelId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent label.");
        }
    }
}

