/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.hashing.HashFunction;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexRef;
import org.neo4j.internal.schema.ReservedSchemaRuleNames;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorImplementation;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.constraints.RelationshipEndpointLabelConstraintDescriptor;
import org.neo4j.util.Preconditions;

public class SchemaNameUtil {
    public static String sanitiseName(Optional<String> name) {
        if (name.isPresent()) {
            return SchemaNameUtil.sanitiseName(name.get());
        }
        throw new IllegalArgumentException("Schema rules must have names.");
    }

    public static String sanitiseName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Schema rule name cannot be null.");
        }
        if ((name = name.trim()).isBlank()) {
            throw new IllegalArgumentException("Schema rule name cannot be the empty string or only contain whitespace.");
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (ch != '\u0000') continue;
            throw new IllegalArgumentException("Schema rule names are not allowed to contain null-bytes: '" + name + "'.");
        }
        if (ReservedSchemaRuleNames.contains(name)) {
            throw new IllegalArgumentException("The index name '" + name + "' is reserved, and cannot be used. The reserved names are " + String.valueOf(ReservedSchemaRuleNames.getReservedNames()) + ".");
        }
        return name;
    }

    public static String generateName(SchemaDescriptorSupplier rule) {
        Preconditions.checkArgument((rule.schema().getEntityTokenIds().length == 0 ? 1 : 0) != 0, (String)"Schema should target no entity tokens (labels, relationship types).");
        Preconditions.checkArgument((rule.schema().getPropertyIds().length == 0 ? 1 : 0) != 0, (String)"Schema should target no property keys.");
        return SchemaNameUtil.generateName(rule, null);
    }

    public static String generateName(SchemaDescriptorSupplier rule, TokenNameLookup tokenNameLookup) {
        HashFunction hf = HashFunction.incrementalXXH64();
        long key = hf.initialise(-7046029254386353131L);
        SchemaDescriptor schema = rule.schema();
        int[] entityTokenIds = schema.getEntityTokenIds();
        int[] propertyKeyIds = schema.getPropertyIds();
        key = hf.update(key, (long)schema.entityType().ordinal());
        key = hf.update(key, (long)SchemaDescriptorImplementation.effectiveSchemaPatternMatchingTypeFeature(schema.schemaPatternMatchingType(), propertyKeyIds));
        key = switch (schema.entityType()) {
            default -> throw new MatchException(null, null);
            case EntityType.NODE -> hf.updateWithArray(key, entityTokenIds, id -> tokenNameLookup.labelGetName(id).hashCode());
            case EntityType.RELATIONSHIP -> hf.updateWithArray(key, entityTokenIds, id -> tokenNameLookup.relationshipTypeGetName(id).hashCode());
        };
        key = hf.updateWithArray(key, propertyKeyIds, id -> tokenNameLookup.propertyKeyGetName(id).hashCode());
        key = hf.update(key, (long)Boolean.hashCode(rule instanceof ConstraintDescriptor));
        SchemaDescriptorSupplier schemaDescriptorSupplier = rule;
        Objects.requireNonNull(schemaDescriptorSupplier);
        SchemaDescriptorSupplier schemaDescriptorSupplier2 = schemaDescriptorSupplier;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IndexRef.class, ConstraintDescriptor.class}, (Object)schemaDescriptorSupplier2, n)) {
            case 0 -> {
                IndexRef index = (IndexRef)schemaDescriptorSupplier2;
                key = hf.update(key, (long)Boolean.hashCode(index.isUnique()));
                key = hf.update(key, (long)index.getIndexType().getTypeNumber());
                yield "index_%x".formatted(hf.toInt(hf.finalise(key)));
            }
            case 1 -> {
                ConstraintDescriptor constraint = (ConstraintDescriptor)schemaDescriptorSupplier2;
                key = hf.update(key, (long)constraint.type().ordinal());
                if (constraint.isIndexBackedConstraint()) {
                    key = hf.update(key, (long)constraint.asIndexBackedConstraint().indexType().getTypeNumber());
                } else if (constraint.enforcesPropertyType()) {
                    key = hf.update(key, (long)constraint.asPropertyTypeConstraint().propertyType().hashCode());
                } else if (constraint.isRelationshipEndpointLabelConstraint()) {
                    RelationshipEndpointLabelConstraintDescriptor relEndpointLabelConstraint = constraint.asRelationshipEndpointLabelConstraint();
                    key = hf.update(key, (long)tokenNameLookup.labelGetName(relEndpointLabelConstraint.endpointLabelId()).hashCode());
                    key = hf.update(key, (long)relEndpointLabelConstraint.endpointType().ordinal());
                } else if (constraint.isNodeLabelExistenceConstraint()) {
                    key = hf.update(key, (long)tokenNameLookup.labelGetName(constraint.asNodeLabelExistenceConstraint().requiredLabelId()).hashCode());
                }
                yield "constraint_%x".formatted(hf.toInt(hf.finalise(key)));
            }
            default -> throw new IllegalArgumentException("Don't know how to generate a name for this %s implementation: %s.".formatted(SchemaDescriptorSupplier.class.getSimpleName(), rule));
        };
    }
}

