/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.steps;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.expressions.EntityType;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.NODE_TYPE$;
import org.neo4j.cypher.internal.expressions.RELATIONSHIP_TYPE$;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.logical.plans.AsDynamicPropertyNonScannable$;
import org.neo4j.cypher.internal.logical.plans.AsDynamicPropertyNonSeekable$;
import org.neo4j.cypher.internal.logical.plans.AsStringRangeNonSeekable$;
import org.neo4j.cypher.internal.logical.plans.AsValueRangeNonSeekable$;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.notification.InternalNotification;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class DynamicPropertyNotifier$ {
    public static final DynamicPropertyNotifier$ MODULE$ = new DynamicPropertyNotifier$();

    public void process(Set<Variable> variables, Function1<Set<String>, InternalNotification> notification, QueryGraph qg, LogicalPlanningContext context) {
        Set indexedLabelOrRelTypes = (Set)variables.flatMap((Function1 & Serializable)variable -> {
            Set labels = qg.selections().labelsOnNode((LogicalVariable)variable);
            Set relTypes = (Set)qg.inlinedRelTypes((LogicalVariable)variable).$plus$plus((IterableOnce)qg.selections().typesOnRel((LogicalVariable)variable));
            Set indexedLabels = (Set)labels.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicPropertyNotifier$.MODULE$.withNodeIndex(x$1, context)));
            Set indexedRelTypes = (Set)relTypes.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicPropertyNotifier$.MODULE$.withRelIndex(x$2, context)));
            return (Set)indexedLabels.$plus$plus((IterableOnce)indexedRelTypes);
        });
        if (indexedLabelOrRelTypes.nonEmpty()) {
            Set indexedLabelOrRelTypeNames = (Set)indexedLabelOrRelTypes.map((Function1 & Serializable)x$3 -> x$3.name());
            context.staticComponents().notificationLogger().log((InternalNotification)notification.apply((Object)indexedLabelOrRelTypeNames));
            return;
        }
    }

    private boolean withNodeIndex(LabelName labelName, LogicalPlanningContext context) {
        Option maybeLabelId = context.semanticTable().id(labelName);
        return BoxesRunTime.unboxToBoolean((Object)maybeLabelId.fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DynamicPropertyNotifier$.$anonfun$withNodeIndex$2(context, x$4))));
    }

    private boolean withRelIndex(RelTypeName relTypeName, LogicalPlanningContext context) {
        Option maybeRelTypeId = context.semanticTable().id(relTypeName);
        return BoxesRunTime.unboxToBoolean((Object)maybeRelTypeId.fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DynamicPropertyNotifier$.$anonfun$withRelIndex$2(context, x$5))));
    }

    public Set<Variable> findNonSolvableIdentifiers(Seq<Expression> predicates2, EntityType expectedType, LogicalPlanningContext context) {
        Function1 & Serializable intersect;
        EntityType entityType = expectedType;
        if (NODE_TYPE$.MODULE$.equals(entityType)) {
            intersect = (Function1 & Serializable)variable -> BoxesRunTime.boxToBoolean((boolean)DynamicPropertyNotifier$.$anonfun$findNonSolvableIdentifiers$1(context, variable));
        } else if (RELATIONSHIP_TYPE$.MODULE$.equals(entityType)) {
            intersect = (Function1 & Serializable)variable -> BoxesRunTime.boxToBoolean((boolean)DynamicPropertyNotifier$.$anonfun$findNonSolvableIdentifiers$2(context, variable));
        } else {
            throw new MatchError((Object)entityType);
        }
        Function1 & Serializable isExpectedEntity = intersect;
        return ((IterableOnceOps)predicates2.flatMap((Function1 & Serializable)x0$1 -> {
            Variable nonScannableId;
            Option option;
            Variable nonSeekableId;
            Option option2;
            Variable nonSeekableId2;
            Option option3;
            Variable nonSeekableId3;
            Option option4;
            Expression expression = x0$1;
            if (expression != null && !(option4 = AsDynamicPropertyNonSeekable$.MODULE$.unapply((Object)expression)).isEmpty() && BoxesRunTime.unboxToBoolean((Object)isExpectedEntity.apply((Object)(nonSeekableId3 = (Variable)option4.get())))) {
                return new Some((Object)nonSeekableId3);
            }
            if (expression != null && !(option3 = AsStringRangeNonSeekable$.MODULE$.unapply((Object)expression)).isEmpty() && BoxesRunTime.unboxToBoolean((Object)isExpectedEntity.apply((Object)(nonSeekableId2 = (Variable)option3.get())))) {
                return new Some((Object)nonSeekableId2);
            }
            if (expression != null && !(option2 = AsValueRangeNonSeekable$.MODULE$.unapply((Object)expression)).isEmpty() && BoxesRunTime.unboxToBoolean((Object)isExpectedEntity.apply((Object)(nonSeekableId = (Variable)option2.get())))) {
                return new Some((Object)nonSeekableId);
            }
            if (expression != null && !(option = AsDynamicPropertyNonScannable$.MODULE$.unapply((Object)expression)).isEmpty() && BoxesRunTime.unboxToBoolean((Object)isExpectedEntity.apply((Object)(nonScannableId = (Variable)option.get())))) {
                return new Some((Object)nonScannableId);
            }
            return None$.MODULE$;
        })).toSet();
    }

    public void issueNotifications(Set<LogicalPlan> result, Function1<Set<String>, InternalNotification> notification, QueryGraph qg, EntityType expectedType, LogicalPlanningContext context) {
        if (result.isEmpty()) {
            Set<Variable> nonSolvable = this.findNonSolvableIdentifiers((Seq<Expression>)qg.selections().flatPredicates(), expectedType, context);
            this.process(nonSolvable, notification, qg, context);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$withNodeIndex$2(LogicalPlanningContext context$2, LabelId x$4) {
        return context$2.staticComponents().planContext().indexExistsForLabel(NameId$.MODULE$.toKernelEncode((NameId)x$4));
    }

    public static final /* synthetic */ boolean $anonfun$withRelIndex$2(LogicalPlanningContext context$3, RelTypeId x$5) {
        return context$3.staticComponents().planContext().indexExistsForRelType(NameId$.MODULE$.toKernelEncode((NameId)x$5));
    }

    public static final /* synthetic */ boolean $anonfun$findNonSolvableIdentifiers$1(LogicalPlanningContext context$4, Variable variable) {
        return context$4.semanticTable().typeFor((Expression)variable).is((CypherType)package$.MODULE$.CTNode());
    }

    public static final /* synthetic */ boolean $anonfun$findNonSolvableIdentifiers$2(LogicalPlanningContext context$4, Variable variable) {
        return context$4.semanticTable().typeFor((Expression)variable).is((CypherType)package$.MODULE$.CTRelationship());
    }

    private DynamicPropertyNotifier$() {
    }
}

