/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.semantics;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.UsingJoinHint;
import org.neo4j.cypher.internal.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.ast.semantics.SemanticErrorDef;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FunctionTypeSignature;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.StaticElementTypeName;
import org.neo4j.cypher.internal.expressions.functions.AllReduce$;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class SemanticError$
implements Serializable {
    public static final SemanticError$ MODULE$ = new SemanticError$();
    private static final String existsErrorMessage = "The EXISTS expression is not valid in driver settings.";
    private static final String countErrorMessage = "The COUNT expression is not valid in driver settings.";
    private static final String collectErrorMessage = "The COLLECT expression is not valid in driver settings.";
    private static final String patternExpressionErrorMessage = "Pattern expressions are not valid in driver settings.";
    private static final String patternComprehensionErrorMessage = "Pattern comprehensions are not valid in driver settings.";
    private static final String genericErrorMessage = "This expression is not valid in driver settings.";
    private static final String validLastClauses = "a RETURN clause, a FINISH clause, an update clause, a unit subquery call, or a procedure call with no YIELD";
    private static final String invalidUseOfPatternExpressionMessage = "A pattern expression should only be used in order to test the existence of a pattern. It should therefore only be used in contexts that evaluate to a boolean, e.g. inside the function exists() or in a WHERE-clause. No other uses are allowed, instead they should be replaced by a pattern comprehension.";
    private static final String errorMessageForSizeFunction = "A pattern expression should only be used in order to test the existence of a pattern. It can no longer be used inside the function size(), an alternative is to replace size() with COUNT {}.";

    public SemanticError apply(String msg, InputPosition position) {
        return new SemanticError(null, msg, position);
    }

    public Option<Tuple3<ErrorGqlStatusObject, String, InputPosition>> unapply(SemanticErrorDef errorDef) {
        return new Some((Object)new Tuple3((Object)errorDef.gqlStatusObject(), (Object)errorDef.msg(), (Object)errorDef.position()));
    }

    public SemanticError internalError(String msgTitle, String msg, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)msg, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, msg, position);
    }

    public SemanticError invalidOption(String invalidOptionsString, scala.collection.immutable.Seq<String> validOptions, Option<String> errorMessageOverride, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)invalidOptionsString, (String)GqlParams.StringParam.input.process((Object)"OPTIONS"), (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava(validOptions).asJava(), (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, (String)errorMessageOverride.getOrElse((Function0 & Serializable)() -> GqlHelper.getCompleteMessage((ErrorGqlStatusObject)gql)), position);
    }

    public SemanticError authForbidsClauseError(String provider, String unsupportedClause, java.util.List<String> expected, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)unsupportedClause, (String)("auth provider " + GqlParams.StringParam.input.process((Object)provider) + " attribute"), expected, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Auth provider `" + provider + "` does not allow `" + unsupportedClause + "` clause.", position);
    }

    public SemanticError unsupportedActionAccess(String actionName, java.util.List<String> expectedActions, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)actionName, (String)"property value access rules", expectedActions, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, actionName + " is not supported for property value access rules.", position);
    }

    public SemanticError mixedListInPBAC(String expression, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NA0).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NAB).withParam(GqlParams.StringParam.expr, expression).atPosition(position.offset(), position.line(), position.column()).build()).build();
        String legacyMsg = "Failed to administer property rule. The expression: `" + expression + "` is not supported. All elements in a list must be literals of the same type for property-based access control.";
        return new SemanticError(gql, legacyMsg, position);
    }

    public SemanticError yieldMissingColumn(String originalName, java.util.List<String> expectedColumns, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)originalName, (String)"column name", expectedColumns, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Trying to YIELD non-existing column: `" + originalName + "`", position);
    }

    public SemanticError invalidFunctionForIndex(String entityIndexDescription, String name, String validFunction, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)(name + "()"), (String)("function in " + entityIndexDescription), java.util.List.of(validFunction + "()"), (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Failed to create " + entityIndexDescription + ": Function '" + name + "' is not allowed, valid function is '" + validFunction + "'.", position);
    }

    public SemanticError invalidUseOfGraphFunction(String graphFunction, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N75).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.StringParam.fun, graphFunction).build()).build();
        return new SemanticError(gql, "`" + graphFunction + "` is only allowed at the first position of a USE clause.", pos);
    }

    private String existsErrorMessage() {
        return existsErrorMessage;
    }

    private String countErrorMessage() {
        return countErrorMessage;
    }

    private String collectErrorMessage() {
        return collectErrorMessage;
    }

    private String patternExpressionErrorMessage() {
        return patternExpressionErrorMessage;
    }

    private String patternComprehensionErrorMessage() {
        return patternComprehensionErrorMessage;
    }

    private String genericErrorMessage() {
        return genericErrorMessage;
    }

    public SemanticError existsInDriverSettings(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"EXISTS"), (String)"driver settings", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, this.existsErrorMessage(), position);
    }

    public SemanticError countInDriverSettings(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"COUNT"), (String)"driver settings", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, this.countErrorMessage(), position);
    }

    public SemanticError collectInDriverSettings(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"COLLECT"), (String)"driver settings", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, this.collectErrorMessage(), position);
    }

    public SemanticError patternExpressionInDriverSettings(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"pattern expression"), (String)"driver settings", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, this.patternExpressionErrorMessage(), position);
    }

    public SemanticError patternComprehensionInDriverSettings(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"pattern comprehension"), (String)"driver settings", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, this.patternComprehensionErrorMessage(), position);
    }

    public SemanticError genericDriverSettingsFail(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"subquery expression"), (String)"driver settings", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, this.genericErrorMessage(), position);
    }

    public SemanticError cannotUseJoinHint(UsingJoinHint hint, String prettifiedHint) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N76).withParam(GqlParams.ListParam.hintList, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)prettifiedHint, (List)Nil$.MODULE$)).asJava()).atPosition(hint.position().offset(), hint.position().line(), hint.position().column()).build();
        return new SemanticError(gql, "Cannot use join hint for single node pattern.", hint.position());
    }

    public SemanticError variableAlreadyDeclaredInOuterScope(String name, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N07((String)name, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Variable `" + name + "` already declared in outer scope", position);
    }

    public SemanticError variableShadowingOuterScope(String name, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N07((String)name, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "The variable `" + name + "` is shadowing a variable with the same name from the outer scope and needs to be renamed", position);
    }

    public SemanticError legacyDisjunction(String sanitizedLabelExpression, boolean containsIs, boolean isNode, InputPosition position) {
        String isOrColon = containsIs ? "IS " : ":";
        String msg = isNode ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Label expressions are not allowed to contain '|:'.\n         |If you want to express a disjunction of labels, please use `" + isOrColon + sanitizedLabelExpression + "` instead")) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The semantics of using colon in the separation of alternative relationship types in conjunction with\n         |the use of variable binding, inlined property predicates, or variable length is no longer supported.\n         |Please separate the relationships types using `" + isOrColon + sanitizedLabelExpression + "` instead."));
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I20((String)"|:", (String)"|", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, msg, position);
    }

    public boolean legacyDisjunction$default$3() {
        return false;
    }

    public SemanticError invalidDisjunction(boolean isNode, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I20((String)(isNode ? "|:" : ":"), (String)"|", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, isNode ? "Label expressions are not allowed to contain '|:'." : "Relationship types in a relationship type expressions may not be combined using ':'", position);
    }

    public SemanticError subPathAssignmentNotSupported(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N42((int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Sub-path assignment is currently not supported.", position);
    }

    public SemanticError unsupportedRequestOnSystemDatabase(String invalidInput, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N17).withParam(GqlParams.StringParam.input, invalidInput).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError invalidInput(String wrongInput, String forField, List<String> expectedInput, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N04).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.StringParam.input, wrongInput).withParam(GqlParams.StringParam.context, forField).withParam(GqlParams.ListParam.inputList, java.util.List.of(expectedInput)).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError invalidEntityType(String invalidInput, String variable, scala.collection.immutable.Seq<String> expectedValueList, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)invalidInput, (String)variable, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava(expectedValueList).asJava(), (int)pos.offset(), (int)pos.line(), (int)pos.column());
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError typeMismatch(List<String> expectedValueList, String wrongType, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NB1).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.ListParam.valueTypeList, CollectionConverters$.MODULE$.SeqHasAsJava(expectedValueList).asJava()).withParam(GqlParams.StringParam.input, wrongType).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError invalidCoercion(String cannotCoerceFrom, String cannotCoerceTo, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N37).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.StringParam.value, cannotCoerceFrom).withParam(GqlParams.StringParam.valueType, cannotCoerceTo).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError specifiedNumberOutOfRange(String component, String valueType, Number lower, Number upper, String inputValue, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N31).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.StringParam.component, component).withParam(GqlParams.StringParam.valueType, valueType).withParam(GqlParams.NumberParam.lower, lower).withParam(GqlParams.NumberParam.upper, upper).withParam(GqlParams.StringParam.value, inputValue).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError propertyTypeUnsupportedInConstraint(String constraintTypeDescription, CypherType originalPropertyType, String additionalError, Option<ErrorGqlStatusObject> maybeCause) {
        ErrorGqlStatusObjectImplementation.Builder gqlInnerBuilder = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N90).withParam(GqlParams.StringParam.valueType, originalPropertyType.description());
        Object object = maybeCause.isDefined() ? gqlInnerBuilder.withCause((ErrorGqlStatusObject)maybeCause.get()) : BoxedUnit.UNIT;
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N11).withParam(GqlParams.StringParam.constrDescrOrName, constraintTypeDescription + " constraint").withCause(gqlInnerBuilder.build()).build();
        return new SemanticError(gql, "Failed to create " + constraintTypeDescription + " constraint: Invalid property type `" + originalPropertyType.description() + "`." + additionalError, originalPropertyType.position());
    }

    public SemanticError missingMandatoryAuthClause(String clause, String authProvider, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N97).withParam(GqlParams.StringParam.clause, clause).withParam(GqlParams.StringParam.auth, authProvider).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError duplicateClause(String clause, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N19((String)clause, (int)pos.offset(), (int)pos.line(), (int)pos.column());
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError missingHintPredicate(String legacyMessage, String hint, String entity, String variable, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N76).withParam(GqlParams.ListParam.hintList, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)hint, (List)Nil$.MODULE$)).asJava()).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N77).withParam(GqlParams.StringParam.hint, hint).withParam(GqlParams.StringParam.entityType, entity).withParam(GqlParams.StringParam.variable, variable).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError functionRequiresWhereClause(String func, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N70).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.fun, func).build()).build();
        return new SemanticError(gql, func + "(...) requires a WHERE predicate", position);
    }

    public SemanticError aExpressionCannotContainUpdates(String expr, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N57((String)expr, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "A " + expr + " Expression cannot contain any updates", position);
    }

    public SemanticError anExpressionCannotContainUpdates(String expr, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N57((String)expr, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "An " + expr + " Expression cannot contain any updates", position);
    }

    public SemanticError singleReturnColumnRequired(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N22((int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "A Collect Expression must end with a single return column.", position);
    }

    public SemanticError emptyListRangeOperator(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N20).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, "The start or end (or both) is required for a collection slice", position);
    }

    public SemanticError unboundVariablesInPatternExpression(String name, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N29).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.variable, name).build()).build();
        return new SemanticError(gql, "PatternExpressions are not allowed to introduce new variables: '" + name + "'.", position);
    }

    public SemanticError invalidUseOfDynamicLabelOrType(String entityType, String clause, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I55).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.StringParam.entityType, entityType).withParam(GqlParams.StringParam.clause, clause).build()).build();
        return new SemanticError(gql, "Dynamic " + entityType + " using `$any()` are not allowed in CREATE or MERGE.", pos);
    }

    public SemanticError dynamicEntityTypeNotAllowed(InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I59).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.ListParam.clauseList, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"MATCH", (List)new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"MERGE", (List)new .colon.colon((Object)"SET", (List)new .colon.colon((Object)"REMOVE", (List)Nil$.MODULE$)))))).asJava()).build()).build();
        return new SemanticError(gql, "Dynamic Label and Types are only allowed in MATCH, CREATE, MERGE, SET and REMOVE clauses.", pos);
    }

    public SemanticError unsupportedAggregationInNEXT(String aggregation, String msg, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I64).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.StringParam.context, aggregation).withParam(GqlParams.StringParam.msg, msg).build()).build();
        return new SemanticError(gql, ((ErrorGqlStatusObject)gql.cause().get()).gqlStatusObject().getMessage(), pos);
    }

    public SemanticError onlyDirectedRelationshipAllowed(String clause, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I56).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.StringParam.clause, clause).build()).build();
        return new SemanticError(gql, "Only directed relationships are supported in " + clause, pos);
    }

    public SemanticError invalidEndOfQuery(String exprType, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I57).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.StringParam.exprType, exprType).withParam(GqlParams.StringParam.clause, "FINISH").build()).build();
        return new SemanticError(gql, exprType + " cannot contain a query ending with FINISH.", pos);
    }

    public SemanticError invalidEntityReference(String entity, String clause, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I58).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.StringParam.expr, entity).build()).build();
        return new SemanticError(gql, "Creating an entity (" + entity + ") and referencing that entity in a property definition in the same " + clause + " is not allowed. Only reference variables created in earlier clauses.", pos);
    }

    public SemanticError incompatibleWhenReturnColumns(String context, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N39((String)context, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, ((ErrorGqlStatusObject)gql.cause().get()).gqlStatusObject().getMessage(), position);
    }

    public SemanticError incompatibleReturnColumns(String context, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N39((String)context, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "All sub queries in an UNION must have the same return column names", position);
    }

    public SemanticError incompatibleSubqueryType(String context, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N3A((String)context, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, ((ErrorGqlStatusObject)gql.cause().get()).gqlStatusObject().getMessage(), position);
    }

    public SemanticError incompatibleNumberOfReturnColumns(String context, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N3B((String)context, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, ((ErrorGqlStatusObject)gql.cause().get()).gqlStatusObject().getMessage(), position);
    }

    public SemanticError invalidUseOfOldCall(String clause, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N3C((String)clause, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, ((ErrorGqlStatusObject)gql.cause().get()).gqlStatusObject().getMessage(), position);
    }

    public SemanticError invalidUseOfUnion(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I40).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, "Invalid combination of UNION and UNION ALL", position);
    }

    public SemanticError invalidUseOfCIT(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I25((int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "CALL { ... } IN TRANSACTIONS after a write clause is not supported", position);
    }

    public SemanticError invalidPositionOfClause(String name, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I38).withParam(GqlParams.StringParam.clause, name).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, name + " can only be used at the end of the query.", position);
    }

    public SemanticError invalidSubclauseOrder(String name, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I63).withParam(GqlParams.StringParam.clause, name).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, ((ErrorGqlStatusObject)gql.cause().get()).gqlStatusObject().getMessage(), position);
    }

    public SemanticError invalidUseOfReturnStar(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I37).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, "RETURN * is not allowed when there are no variables in scope", position);
    }

    public SemanticError invalidReferenceToGroupingExpression(scala.collection.immutable.Seq<String> variables, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I18).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.ListParam.variableList, CollectionConverters$.MODULE$.SeqHasAsJava(variables).asJava()).build()).build();
        String errorMsg = this.implicitGroupingExpressionInAggregationColumnErrorMessage(variables);
        return new SemanticError(gql, errorMsg, position);
    }

    public SemanticError invalidForeach(String clause, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I01).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.clause, clause).build()).build();
        return new SemanticError(gql, "Invalid use of " + clause + " inside FOREACH", position);
    }

    public SemanticError unaliasedReturnItem(String context, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N21).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.context, context).build()).build();
        return new SemanticError(gql, "Expression in " + context + " must be aliased (use AS)", position);
    }

    public String implicitGroupingExpressionInAggregationColumnErrorMessage(scala.collection.immutable.Seq<String> variables) {
        return "Aggregation column contains implicit grouping expressions. For example, in 'RETURN n.a, n.a + n.b + count(*)' the aggregation expression 'n.a + n.b + count(*)' includes the implicit grouping key 'n.b'. It may be possible to rewrite the query by extracting these grouping/aggregation expressions into a preceding WITH clause. Illegal expression(s): " + variables.mkString(", ");
    }

    public SemanticError aggregateExpressionsNotAllowedInSimpleExpressions(String function, String functionName, InputPosition position) {
        return this.aggregateExpressionsNotAllowed(function, "Invalid use of aggregating function " + functionName + "(...) in this context", position);
    }

    public SemanticError aggregateExpressionsNotAllowedInAggregationFunctions(String function, InputPosition position) {
        return this.aggregateExpressionsNotAllowed(function, "Can't use aggregate functions inside of aggregate functions.", position);
    }

    public SemanticError aggregateExpressionsNotAllowedInProcedureCallArgument(String arg, InputPosition position) {
        return this.aggregateExpressionsNotAllowed(arg, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Procedure call cannot take an aggregating function as argument, please add a 'WITH' to your statement.\n        |For example:\n        |    MATCH (n:Person) WITH collect(n.name) AS names CALL proc(names) YIELD value RETURN value")), position);
    }

    public SemanticError aggregateExpressionsInOrderBy(scala.collection.immutable.Seq<String> aggregateExpressions, InputPosition position) {
        return this.aggregateExpressionsNotAllowed((String)aggregateExpressions.head(), "Illegal aggregation expression(s) in order by: " + aggregateExpressions.mkString(", ") + ". If an aggregation expression is used in order by, it also needs to be a projection item on it's own. For example, in 'RETURN n.a, 1 + count(*) ORDER BY count(*) + 1' the aggregation expression 'count(*) + 1' is not a projection item on its own, but it could be rewritten to 'RETURN n.a, 1 + count(*) AS cnt ORDER BY 1 + count(*)'.", position);
    }

    private SemanticError aggregateExpressionsNotAllowed(String function, String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I24((String)function, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError accessingMultipleGraphsError(String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NA5).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError numberTooLarge(String numberType, String value, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22003((String)value, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, numberType + " is too large", position);
    }

    public SemanticError notSupported(InputPosition pos) {
        String msg = "Not supported.";
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)this.getClass().getSimpleName(), (String)msg, (int)pos.offset(), (int)pos.line(), (int)pos.column());
        return new SemanticError(gql, msg, pos);
    }

    public SemanticError invalidClauseCombination(String clause1, String clause2, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N14).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.clause, clause1).withParam(GqlParams.StringParam.cmd, clause2).build()).build();
        return new SemanticError(gql, "%s cannot be used together with %s.".formatted(clause1, clause2), position);
    }

    public SemanticError bothOrReplaceAndIfNotExists(String entity, String userAsString, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N14((String)"OR REPLACE", (String)"IF NOT EXISTS", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Failed to create the specified " + entity + " '" + userAsString + "': cannot have both `OR REPLACE` and `IF NOT EXISTS`.", position);
    }

    public SemanticError badCommandWithOrReplace(String cmd, String cypherCmd, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N14((String)"OR REPLACE", (String)cypherCmd, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Failed to " + cmd + ": `OR REPLACE` cannot be used together with this command.", position);
    }

    public SemanticError denyMergeUnsupported(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N14((String)"DENY", (String)"MERGE", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "`DENY MERGE` is not supported. Use `DENY SET PROPERTY` and `DENY CREATE` instead.", position);
    }

    public SemanticError grantDenyRevokeUnsupported(String cmd, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N14((String)"GRANT, DENY and REVOKE", (String)cmd, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "`GRANT`, `DENY` and `REVOKE` are not supported for `" + cmd + "`", position);
    }

    public SemanticError defaultLanguageForConstituentAliases(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N14((String)"DEFAULT LANGUAGE", (String)"constituent aliases", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, GqlHelper.getCompleteMessage((ErrorGqlStatusObject)gql), position);
    }

    public SemanticError unableToRouteUseClauseError(String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N04).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.clause, "`USE` clause").build();
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError invalidNumberOfProcedureOrFunctionArguments(int expectedNumberOfArgs, int obtainedNumberOfArgs, String procedureFunction, String signature, String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I13).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.NumberParam.count1, (Number)Predef$.MODULE$.int2Integer(expectedNumberOfArgs)).withParam(GqlParams.NumberParam.count2, (Number)Predef$.MODULE$.int2Integer(obtainedNumberOfArgs)).withParam(GqlParams.StringParam.procFun, procedureFunction).withParam(GqlParams.StringParam.sig, signature).build()).build();
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError invalidYieldStar(String commandName, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N94).build();
        return new SemanticError(gql, "When combining `" + commandName + "` with other show and/or terminate commands, `YIELD *` isn't permitted.", position);
    }

    public SemanticError missingYield(String commandName, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N93).build();
        return new SemanticError(gql, "When combining `" + commandName + "` with other show and/or terminate commands, `YIELD` is mandatory.", position);
    }

    public SemanticError missingReturn(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N92).build();
        return new SemanticError(gql, "When combining show and/or terminate commands, `RETURN` isn't optional.", position);
    }

    public SemanticError queryMustConcludeWithClause(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N71((int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Query must conclude with " + this.validLastClauses() + ".", position);
    }

    public SemanticError queryCannotConcludeWithCall(String callName, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N71((int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Query cannot conclude with " + callName + " together with YIELD", position);
    }

    public SemanticError queryCannotConcludeWithClause(String clause, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N71((int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Query cannot conclude with " + clause + " (must be " + this.validLastClauses() + ").", position);
    }

    public SemanticError invalidPropertyBasedAccessControlRuleInvolvingNontrivialPredicates(String unsupportedExpression, String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NA0).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NA7).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.expr, unsupportedExpression).build()).build();
        return new SemanticError(gql, legacyMessage, position);
    }

    private String validLastClauses() {
        return validLastClauses;
    }

    public SemanticError withIsRequiredBetween(String clause1, String clause2, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N24((String)clause1, (String)clause2, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "WITH is required between " + clause1 + " and " + clause2, position);
    }

    public SemanticError invalidType(String value, List<String> correctTypes, String actualType, String legacyMessage, InputPosition pos) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22G03).atPosition(pos.offset(), pos.line(), pos.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N01).atPosition(pos.offset(), pos.line(), pos.column()).withParam(GqlParams.StringParam.value, value).withParam(GqlParams.ListParam.valueTypeList, CollectionConverters$.MODULE$.SeqHasAsJava(correctTypes).asJava()).withParam(GqlParams.StringParam.valueType, actualType).build()).build();
        return new SemanticError(gql, legacyMessage, pos);
    }

    public SemanticError invalidPlacementOfUseClause(InputPosition pos) {
        return new SemanticError(GqlHelper.getGql42001_42N73((int)pos.offset(), (int)pos.line(), (int)pos.column()), "USE clause must be the first clause in a (sub-)query.", pos);
    }

    public SemanticError invalidPlacementOfUseClauseVerboseLegacyMsg(InputPosition pos) {
        return new SemanticError(GqlHelper.getGql42001_42N73((int)pos.offset(), (int)pos.line(), (int)pos.column()), "USE clause must be either the first clause in a (sub-)query or preceded by an importing WITH clause in a sub-query.", pos);
    }

    public SemanticError invalidSubqueryInMerge(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I48((int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Subquery expressions are not allowed in a MERGE clause.", position);
    }

    public SemanticError invalidUseOfMultiplePathPatterns(InputPosition position, boolean explicitMatchModesSupported) {
        String baseMessage = "Multiple path patterns cannot be used in the same clause in combination with a selective path selector.";
        String action = explicitMatchModesSupported ? " You may want to use multiple MATCH clauses, or you might want to consider using the REPEATABLE ELEMENTS match mode." : "";
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I45((String)action, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, baseMessage + action, position);
    }

    public SemanticError invalidFieldTerminator(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I05).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, "CSV field terminator can only be one character wide", position);
    }

    public SemanticError singleRelationshipPatternRequired(String name, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N40((String)name, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, name + "(...) requires a pattern containing a single relationship", position);
    }

    public SemanticError inputContainsInvalidCharacters(String invalidInput, String context, String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.input, invalidInput).withParam(GqlParams.StringParam.context, context).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N82).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.input, invalidInput).withParam(GqlParams.StringParam.context, context).build()).build();
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError numPrimariesOutOfRange(int count, String command, String action, String topologyString, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, String.valueOf(count)).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N52).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.action, action).withParam(GqlParams.NumberParam.count, (Number)Predef$.MODULE$.int2Integer(count)).withParam(GqlParams.NumberParam.upper, (Number)Predef$.MODULE$.int2Integer(11)).build()).build();
        return new SemanticError(gql, "Failed to " + command + " with `" + topologyString + "`, PRIMARY must be greater than 0.", position);
    }

    public SemanticError numSecondariesOutOfRange(int count, String command, String action, String topologyString, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, String.valueOf(count)).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N53).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.action, action).withParam(GqlParams.NumberParam.count, (Number)Predef$.MODULE$.int2Integer(count)).withParam(GqlParams.NumberParam.upper, (Number)Predef$.MODULE$.int2Integer(20)).build()).build();
        return new SemanticError(gql, "Failed to " + command + " with `" + topologyString + "`, SECONDARY must be a positive value", position);
    }

    public SemanticError numReplicasOutOfRange(int count, String command, String topologyString, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, String.valueOf(count)).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N58).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.NumberParam.count, (Number)Predef$.MODULE$.int2Integer(count)).withParam(GqlParams.NumberParam.upper, (Number)Predef$.MODULE$.int2Integer(20)).withParam(GqlParams.StringParam.context, "replicas").build()).build();
        return new SemanticError(gql, "Failed to " + command + " with `" + topologyString + "`, REPLICA must be between 1 and 20.", position);
    }

    public SemanticError numShardsOutOfRange(int count, String command, String topologyString, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, String.valueOf(count)).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N58).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.NumberParam.count, (Number)Predef$.MODULE$.int2Integer(count)).withParam(GqlParams.NumberParam.upper, (Number)Predef$.MODULE$.int2Integer(1000)).withParam(GqlParams.StringParam.context, "shards").build()).build();
        return new SemanticError(gql, "Failed to " + command + " with `" + topologyString + "`, COUNT must be between 1 and 1000.", position);
    }

    public SemanticError unsupportedUseOfProperties(Expression props, String funcName, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N56).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.fun, funcName).build()).build();
        return new SemanticError(gql, funcName + "(...) contains properties " + props + ". This is currently not supported.", position);
    }

    public SemanticError nodeVariableNotBound(String funcName, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N65).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.fun, funcName).build()).build();
        return new SemanticError(gql, "A " + funcName + "(...) requires bound nodes when not part of a MATCH clause.", position);
    }

    public SemanticError relationshipVariableAlreadyBound(String funcName, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N66).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.fun, funcName).build()).build();
        return new SemanticError(gql, "Bound relationships not allowed in " + funcName + "(...)", position);
    }

    public SemanticError qppInShortestPath(String funcName, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42I23((String)funcName, (int)position.offset(), (int)position.line(), (int)position.column()), funcName + "(...) contains quantified pattern. This is currently not supported.", position);
    }

    public SemanticError invalidLowerBound(String funcName, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I08).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.fun, funcName).build()).build();
        return new SemanticError(gql, funcName + "(...) does not support a minimal length different from 0 or 1", position);
    }

    public SemanticError invalidUseOfParameterMap(String keyword, String param, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N32((String)keyword, (int)position.offset(), (int)position.line(), (int)position.column()), "Parameter maps cannot be used in `" + keyword + "` patterns (use a literal map instead, e.g. `{id: $" + param + ".id}`)", position);
    }

    public SemanticError invalidUseOfPatternExpression(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I34).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, this.invalidUseOfPatternExpressionMessage(), position);
    }

    public String invalidUseOfPatternExpressionMessage() {
        return invalidUseOfPatternExpressionMessage;
    }

    public SemanticError invalidUseOfUnionAndCIT(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N47((int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "CALL { ... } IN TRANSACTIONS in a UNION is not supported", position);
    }

    public SemanticError unknownFunction(String functionName, InputPosition position) {
        return this.unknownFunction(functionName, "Unknown function '" + functionName + "'", position);
    }

    public SemanticError unknownFunctionNamedNot(InputPosition position) {
        return this.unknownFunction("not", "Unknown function 'not'. If you intended to use the negation expression, surround it with parentheses.", position);
    }

    private SemanticError unknownFunction(String functionName, String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N48((String)functionName, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError invalidToken(String tokenType, String input, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I11((String)tokenType, (String)input, (int)position.offset(), (int)position.line(), (int)position.column());
        String inputChecked = input == null ? "Null" : (input.isEmpty() ? "''" : input);
        return new SemanticError(gql, inputChecked + " is not a valid token name. Token names cannot be empty or contain any null-bytes.", position);
    }

    public SemanticError invalidDelete(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I26).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, "DELETE doesn't support removing labels from a node. Try REMOVE.", position);
    }

    public SemanticError unsafeUsageOfRepeatableElements(InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N53((int)position.offset(), (int)position.line(), (int)position.column()), "The quantified path pattern may yield an infinite number of rows under match mode 'REPEATABLE ELEMENTS'. Add an upper bound to the quantified path pattern.", position);
    }

    public SemanticError variableAlreadyDeclared(String variableName, InputPosition position) {
        return this.variableAlreadyDeclared(variableName, "Variable `" + variableName + "` already declared", position);
    }

    public SemanticError variableAlreadyDeclared(String variableName, String legacyMessage, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N59((String)variableName, (int)position.offset(), (int)position.line(), (int)position.column()), legacyMessage, position);
    }

    public SemanticError invalidUseOfVariableLengthRelationship(String expr, String legacyMessage, InputPosition position) {
        return new SemanticError(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I41).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.value, expr).build()).build(), legacyMessage, position);
    }

    public SemanticError variableNotDefined(String variableName, String legacyMessage, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N62((String)variableName, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError variableNotDefined(String variableName, InputPosition position) {
        return this.variableNotDefined(variableName, "Variable `" + variableName + "` not defined", position);
    }

    public SemanticError wrongInequalityOperator(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I49).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, "Unknown operation '!=' (you probably meant to use '<>', which is the operator for inequality testing)", position);
    }

    public SemanticError multipleReturnColumnsWithSameName(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N38((int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Multiple result columns with the same name are not supported", position);
    }

    public SemanticError multipleJoinHintsForSameVariable(String variable, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N26).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.variable, variable).build()).build();
        return new SemanticError(gql, "Multiple join hints for same variable are not supported", position);
    }

    public SemanticError innerTypeWithDifferentNullability(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N63((int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "All types in a Closed Dynamic Union must be nullable, or be appended with `NOT NULL`", position);
    }

    public SemanticError expressionCanOnlyBeUsedInMatch(String startOfLegacyMessage, String expr, String clause, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I04((String)expr, (String)clause, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, startOfLegacyMessage + " cannot be used in a " + clause + " clause, but only in a MATCH clause.", position);
    }

    public SemanticError patternPredicateInVarLengthRel(InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N37((int)position.offset(), (int)position.line(), (int)position.column()), "Relationship pattern predicates are not supported for variable-length relationships.", position);
    }

    public SemanticError procedureCallWithoutParentheses(String name, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N36((int)position.offset(), (int)position.line(), (int)position.column()), "Procedure call is missing parentheses: " + name, position);
    }

    public SemanticError procedureCallWithParenthesesWithArgs(String name, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N36((int)position.offset(), (int)position.line(), (int)position.column()), "Procedure call inside a query does not support passing arguments implicitly. Please pass arguments explicitly in parentheses after procedure name for " + name, position);
    }

    public SemanticError procedureCallWithImplicitNaming(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N25).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, "Procedure call inside a query does not support naming results implicitly (name explicitly using `YIELD` instead)", position);
    }

    public SemanticError nestedQPP(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I12).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, "Quantified path patterns are not allowed to be nested.", position);
    }

    public SemanticError shortestPathInsideQPP(InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N69((String)"shortestPath", (String)"quantified path pattern", (int)position.offset(), (int)position.line(), (int)position.column()), "shortestPath(...) is only allowed as a top-level element and not inside a quantified path pattern", position);
    }

    public SemanticError shortestPathInsideParenthesizedPathPattern(String shortestPathFunc, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N69((String)shortestPathFunc, (String)"parenthesized path pattern", (int)position.offset(), (int)position.line(), (int)position.column()), shortestPathFunc + "(...) is only allowed as a top-level element and not inside a parenthesized path pattern", position);
    }

    public SemanticError pathPatternNeedsAtLeastOnePattern(String patternPart, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N64((int)position.offset(), (int)position.line(), (int)position.column()), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A top-level path pattern in a `MATCH` clause must be written such that it always evaluates to at least one node pattern.\n         |In this case, `" + patternPart + "` would result in an empty pattern.")), position);
    }

    public SemanticError qppNeedsAtLeastOneRelationship(String pattern, String nodeCountDescription, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N64((int)position.offset(), (int)position.line(), (int)position.column()), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A quantified path pattern needs to have at least one relationship.\n         |In this case, the quantified path pattern " + pattern + " consists of only " + nodeCountDescription + ".")), position);
    }

    public SemanticError invalidNodePatternPair(String inThisCase, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42I46((int)position.offset(), (int)position.line(), (int)position.column()), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Juxtaposition is currently only supported for quantified path patterns.\n         |" + inThisCase + "\n         |That is, neither of these is a quantified path pattern.")), position);
    }

    public SemanticError invalidQuantifier(long lower, long upper, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I17).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A quantifier for a path pattern must not have a lower bound which exceeds its upper bound.\n         |In this case, the lower bound " + lower + " is greater than the upper bound " + upper + ".")), position);
    }

    public SemanticError cannotYieldFromVoidProcedure(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I42).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, "Cannot yield value from void procedure.", position);
    }

    public SemanticError pathBoundInQPP(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N34((int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Assigning a path in a quantified path pattern is not yet supported.", position);
    }

    public SemanticError notStaticallyInferrableVariable(String name, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N28((String)name, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "It is not allowed to refer to variables in " + name + ", so that the value for " + name + " can be statically calculated.", position);
    }

    public SemanticError notStaticallyInferrablePattern(String name, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N28((String)name, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "It is not allowed to use patterns in the expression for " + name + ", so that the value for " + name + " can be statically calculated.", position);
    }

    public SemanticError invalidUseOfShortestPath(String fun, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I39((String)fun, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Mixing shortestPath/allShortestPaths with path selectors (e.g. 'ANY SHORTEST') or explicit match modes ('e.g. DIFFERENT RELATIONSHIPS') is not allowed.", position);
    }

    public SemanticError invalidReportStatus(InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42I36((int)position.offset(), (int)position.line(), (int)position.column()), "REPORT STATUS can only be used when specifying ON ERROR CONTINUE or ON ERROR BREAK", position);
    }

    public SemanticError matchModesNotSupported(String matchMode, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N54((String)matchMode, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Match modes such as `" + matchMode + "` are not supported yet.", position);
    }

    public SemanticError matchModesNotSupportedInCypher5(String matchMode, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N54((String)matchMode, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Match modes such as `" + matchMode + "` are not supported in Cypher 5.", position);
    }

    public SemanticError vectorTypeNotSupported(String item, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_51N26((String)item, (String)"Vector types", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "The vector type is not supported.", position);
    }

    public SemanticError invalidImportingWithKeyword(String keyword, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I28((String)keyword, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Importing WITH should consist only of simple references to outside variables. " + keyword + " is not allowed.", position);
    }

    public SemanticError invalidImportingWithAliasOrExpression(String input, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I28((String)input, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Importing WITH should consist only of simple references to outside variables. Aliasing or expressions are not supported.", position);
    }

    public SemanticError invalidYieldStar(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I43).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, "Cannot use `YIELD *` outside standalone call", position);
    }

    public SemanticError unsupportedNestingCIT(InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N58((int)position.offset(), (int)position.line(), (int)position.column()), "Nested CALL { ... } IN TRANSACTIONS is not supported", position);
    }

    public SemanticError unsupportedNestingCITInCall(InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N58((int)position.offset(), (int)position.line(), (int)position.column()), "CALL { ... } IN TRANSACTIONS nested in a regular CALL is not supported", position);
    }

    public SemanticError invalidReduceAccumulator(InputPosition position) {
        ErrorGqlStatusObject gql = this.missingPipeExpression(position);
        return new SemanticError(gql, "reduce(...) requires '| expression' (an accumulation expression)", position);
    }

    private ErrorGqlStatusObject missingPipeExpression(InputPosition position) {
        return ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N41).atPosition(position.offset(), position.line(), position.column()).build()).build();
    }

    public SemanticError invalidAllReduceSyntax(InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I51).withParam(GqlParams.StringParam.procFun, AllReduce$.MODULE$.name()).withParam(GqlParams.StringParam.sig, ((FunctionTypeSignature)AllReduce$.MODULE$.signatures().head()).getSignatureAsString()).atPosition(position.offset(), position.line(), position.column()).build()).build();
        return new SemanticError(gql, "Invalid syntax for the `allReduce` function. The function allReduce must have the signature " + ((FunctionTypeSignature)AllReduce$.MODULE$.signatures().head()).getSignatureAsString(), position);
    }

    public SemanticError invalidDistinct(String fun, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I27).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.StringParam.fun, fun).build()).build();
        return new SemanticError(gql, "Invalid use of DISTINCT with function '" + fun + "'", position);
    }

    public SemanticError invalidPoint(scala.collection.immutable.Seq<String> keys, InputPosition position) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I16).atPosition(position.offset(), position.line(), position.column()).withParam(GqlParams.ListParam.mapKeyList, CollectionConverters$.MODULE$.SeqHasAsJava(keys).asJava()).build()).build();
        String legacyMessage = "A map with keys " + ((IterableOnceOps)keys.map((Function1 & Serializable)key -> "'" + key + "'")).mkString(", ") + " is not describing a valid point, a point is described either by using cartesian coordinates e.g. {x: 2.3, y: 4.5, crs: 'cartesian'} or using geographic coordinates e.g. {latitude: 12.78, longitude: 56.7, crs: 'WGS-84'}.";
        return new SemanticError(gql, legacyMessage, position);
    }

    public SemanticError invalidRelTypeExpression(String clause, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42I35((int)position.offset(), (int)position.line(), (int)position.column()), "Relationship type expressions in patterns are not allowed in " + clause + ", but only in a MATCH clause", position);
    }

    public SemanticError invalidPatternPredicate(String entity, String description, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42I32((String)description, (int)position.offset(), (int)position.line(), (int)position.column()), entity + " pattern predicates are not allowed in " + description + ", but only in a MATCH clause or inside a pattern comprehension", position);
    }

    public SemanticError mixingColonAndIs(Set<String> labelExpressions, Set<String> replacements, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I29((String)labelExpressions.mkString(", "), (String)replacements.mkString(", "), (int)position.offset(), (int)position.line(), (int)position.column());
        String exprText = replacements.size() > 1 ? "These expressions" : "This expression";
        return new SemanticError(gql, "Mixing the IS keyword with colon (':') between labels is not allowed. " + exprText + " could be expressed as " + replacements.mkString(", ") + ".", position);
    }

    public SemanticError mixingIsWithMultipleLabels(String statement, String replacement, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I29((String)statement, (String)replacement, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "It is not supported to use the `IS` keyword together with multiple labels in `" + statement + "`. Rewrite the expression as `" + replacement + "`.", position);
    }

    public SemanticError invalidLabelExpression(Set<String> replacements, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I10((String)replacements.mkString(", "), (int)position.offset(), (int)position.line(), (int)position.column());
        String exprText = replacements.size() > 1 ? "These expressions" : "This expression";
        return new SemanticError(gql, "Mixing label expression symbols ('|', '&', '!', and '%') with colon (':') between labels is not allowed. Please only use one set of symbols. " + exprText + " could be expressed as " + replacements.mkString(", ") + ".", position);
    }

    public SemanticError invalidLabelExpressionInShortestPath(InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I30((String)"shortestPath", (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, "Label expressions in shortestPath are not allowed in an expression", position);
    }

    public SemanticError invalidLabelExpressionInPattern(String clause, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I30((String)clause, (int)position.offset(), (int)position.line(), (int)position.column());
        String legacyMsg = "Label expressions in patterns are not allowed in " + clause + ", but only in a MATCH clause and in expressions";
        return new SemanticError(gql, legacyMsg, position);
    }

    public SemanticError functionCallWrongNumberOfArguments(int expectedNumArgs, int actualNumArgs, String name, String signature, String argumentMsg, InputPosition position, Option<String> legacyMsg) {
        String string;
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I13((int)expectedNumArgs, (int)actualNumArgs, (String)name, (String)signature, (int)position.offset(), (int)position.line(), (int)position.column());
        Option<String> option = legacyMsg;
        if (option instanceof Some) {
            String m;
            Some some = (Some)option;
            string = m = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Function call does not provide the required number of arguments: expected " + expectedNumArgs + " got " + actualNumArgs + ".\n           |\n           |Function " + name + " has signature: " + signature + "\n           |meaning that it expects " + expectedNumArgs + " " + argumentMsg));
        } else {
            throw new MatchError(option);
        }
        String msg = string;
        return new SemanticError(gql, msg, position);
    }

    public Option<String> functionCallWrongNumberOfArguments$default$7() {
        return None$.MODULE$;
    }

    public SemanticError procedureCallTooFewArguments(int actualNumArgs, int minNumArgs, int totalNumArgs, int numArgsWithDefaults, String name, String signature, String sigDesc, String description, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I13((int)minNumArgs, (int)actualNumArgs, (String)name, (String)signature, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Procedure call does not provide the required number of arguments: got " + actualNumArgs + " expected at least " + minNumArgs + " (total: " + totalNumArgs + ", " + numArgsWithDefaults + " of which have default values).\n         |\n         |" + sigDesc + "\n         |" + description)), position);
    }

    public SemanticError procedureCallTooManyArguments(int expectedNumArgs, int actualNumArgs, String name, String signature, String maxExpectedMsg, String sigDesc, String description, InputPosition position) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42I13((int)expectedNumArgs, (int)actualNumArgs, (String)name, (String)signature, (int)position.offset(), (int)position.line(), (int)position.column());
        return new SemanticError(gql, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Procedure call provides too many arguments: got " + actualNumArgs + " expected " + maxExpectedMsg + ".\n         |\n         |" + sigDesc + "\n         |" + description)), position);
    }

    public SemanticError invalidReferenceInParenthesizedPathPatternPredicate(String stringifiedPattern, Set<String> invalidReferences, InputPosition position, String legacyErrorMessage) {
        return new SemanticError(GqlHelper.getGql42001_42I21((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)invalidReferences.toList()).asJava(), (String)stringifiedPattern, (int)position.offset(), (int)position.line(), (int)position.column()), legacyErrorMessage, position);
    }

    public SemanticError invalidLiteralNumber(String value, String input, InputPosition position) {
        return this.invalidIntegerSyntax(value, input, position, "invalid literal number");
    }

    public SemanticError invalidOctalIntegerSyntax(String input, InputPosition position) {
        String newInput = StringOps$.MODULE$.patch$extension(Predef$.MODULE$.augmentString(input), input.indexOf(48) + 1, "o", 0);
        return this.invalidIntegerSyntax("octal integer", input, position, "The octal integer literal syntax `" + input + "` is no longer supported, please use `" + newInput + "` instead");
    }

    public SemanticError invalidHexIntegerSyntax(String input, InputPosition position) {
        return this.invalidIntegerSyntax("hex integer", input, position, "The hex integer literal syntax `" + input + "` is no longer supported, please use `" + input.replace('X', 'x') + "` instead");
    }

    private SemanticError invalidIntegerSyntax(String valueType, String input, InputPosition position, String legacyErrorMessage) {
        return new SemanticError(GqlHelper.getGql42001_42I07((String)valueType, (String)input, (int)position.offset(), (int)position.line(), (int)position.column()), legacyErrorMessage, position);
    }

    public SemanticError invalidNumberOfRelationshipTypes(String variable, InputPosition position, String legacyErrorMessage) {
        return new SemanticError(GqlHelper.getGql42001_42I14((String)variable, (int)position.offset(), (int)position.line(), (int)position.column()), legacyErrorMessage, position);
    }

    public SemanticError inaccessibleVariable(String variable, String clause, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N44((String)variable, (String)clause, (int)position.offset(), (int)position.line(), (int)position.column()), "In a WITH/RETURN with DISTINCT or an aggregation, it is not possible to access variables declared before the WITH/RETURN: " + variable, position);
    }

    public SemanticError patternExpressionInSize(InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42I52((String)this.errorMessageForSizeFunction(), (int)position.offset(), (int)position.line(), (int)position.column()), this.errorMessageForSizeFunction(), position);
    }

    public String errorMessageForSizeFunction() {
        return errorMessageForSizeFunction;
    }

    public SemanticError duplicateVariableDefinitionUnknown(String clause, String varName, InputPosition position) {
        return this.duplicateVariableDefinition(clause, "The variable '" + varName + "' is referencing an entity that is created in the same " + clause + " clause which is not allowed. Please only reference variables created in earlier clauses.", position);
    }

    public SemanticError duplicateVariableDefinitionKnown(String clause, String varName, String typ, InputPosition position) {
        return this.duplicateVariableDefinition(clause, "The " + typ + " variable '" + varName + "' is referencing a " + typ + " that is created in the same " + clause + " clause which is not allowed. Please only reference variables created in earlier clauses.", position);
    }

    public SemanticError labelIdentifyingAndImplied(List<String> labels, InputPosition position) {
        return new SemanticError(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NC4).withParam(GqlParams.ListParam.labelList, CollectionConverters$.MODULE$.SeqHasAsJava(labels).asJava()).atPosition(position.offset(), position.line(), position.column()).build()).build(), "The label(s) " + labels.map((Function1 & Serializable)l -> "`" + l + "`").mkString(", ") + " are defined as both identifying and implied.", position);
    }

    public SemanticError independentConstraintOnDependentElement(String description, StaticElementTypeName elementTypeName, InputPosition position) {
        Tuple4 tuple4;
        StaticElementTypeName staticElementTypeName = elementTypeName;
        if (staticElementTypeName instanceof LabelName) {
            LabelName labelName = (LabelName)staticElementTypeName;
            String name = labelName.name();
            tuple4 = new Tuple4((Object)GqlStatusInfoCodes.STATUS_22NC6, (Object)GqlParams.StringParam.label, (Object)name, (Object)("Independent constraints cannot be defined on label `" + name + "`"));
        } else if (staticElementTypeName instanceof RelTypeName) {
            RelTypeName relTypeName = (RelTypeName)staticElementTypeName;
            String name = relTypeName.name();
            tuple4 = new Tuple4((Object)GqlStatusInfoCodes.STATUS_22NC7, (Object)GqlParams.StringParam.relType, (Object)name, (Object)("Independent constraints cannot be defined on relationship type `" + name + "`"));
        } else {
            throw new MatchError((Object)staticElementTypeName);
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        GqlStatusInfoCodes statusCode = (GqlStatusInfoCodes)tuple42._1();
        GqlParams.StringParam param = (GqlParams.StringParam)tuple42._2();
        String nameValue = (String)tuple42._3();
        String error = (String)tuple42._4();
        Tuple4 tuple43 = new Tuple4((Object)statusCode, (Object)param, (Object)nameValue, (Object)error);
        GqlStatusInfoCodes statusCode2 = (GqlStatusInfoCodes)tuple43._1();
        GqlParams.StringParam param2 = (GqlParams.StringParam)tuple43._2();
        String nameValue2 = (String)tuple43._3();
        String error2 = (String)tuple43._4();
        return new SemanticError(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)statusCode2).withParam(GqlParams.StringParam.constrDescrOrName, description).withParam(param2, nameValue2).atPosition(position.offset(), position.line(), position.column()).build()).build(), error2, position);
    }

    public SemanticError duplicateTokensInGraphType(String token, InputPosition position) {
        return new SemanticError(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).atPosition(position.offset(), position.line(), position.column()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NC8).withParam(GqlParams.StringParam.token, token).atPosition(position.offset(), position.line(), position.column()).build()).build(), "graph type contains duplicated tokens '" + token + "'", position);
    }

    private SemanticError duplicateVariableDefinition(String clause, String legacyMessage, InputPosition position) {
        return new SemanticError(GqlHelper.getGql42001_42N68((String)clause, (int)position.offset(), (int)position.line(), (int)position.column()), legacyMessage, position);
    }

    public SemanticError apply(ErrorGqlStatusObject gqlStatusObject, String msg, InputPosition position) {
        return new SemanticError(gqlStatusObject, msg, position);
    }

    public Option<Tuple3<ErrorGqlStatusObject, String, InputPosition>> unapply(SemanticError x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.gqlStatusObject(), (Object)x$0.msg(), (Object)x$0.position()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SemanticError$.class);
    }

    private SemanticError$() {
    }
}

