/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.PartitionSearcherReference;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;
import org.neo4j.kernel.api.impl.fulltext.SearcherReference;
import org.neo4j.kernel.api.impl.fulltext.SimpleFulltextIndexReader;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.values.storable.Value;

class PartitionedFulltextIndexReader
extends FulltextIndexReader {
    private final List<FulltextIndexReader> indexReaders;

    PartitionedFulltextIndexReader(List<PartitionSearcher> partitionSearchers, String[] properties, Analyzer analyzer, TokenHolder propertyKeyTokenHolder) {
        this(partitionSearchers.stream().map(PartitionSearcherReference::new).map(searcher -> new SimpleFulltextIndexReader((SearcherReference)searcher, properties, analyzer, propertyKeyTokenHolder)).collect(Collectors.toList()));
    }

    private PartitionedFulltextIndexReader(List<FulltextIndexReader> readers) {
        this.indexReaders = readers;
    }

    @Override
    public ScoreEntityIterator query(String query) throws ParseException {
        return this.partitionedQuery(query);
    }

    public void close() {
        try {
            IOUtils.closeAll(this.indexReaders);
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private ScoreEntityIterator partitionedQuery(String query) throws ParseException {
        ArrayList<ScoreEntityIterator> results = new ArrayList<ScoreEntityIterator>();
        for (FulltextIndexReader indexReader : this.indexReaders) {
            results.add(indexReader.query(query));
        }
        return ScoreEntityIterator.mergeIterators(results);
    }

    public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
        return this.indexReaders.stream().mapToLong(reader -> reader.countIndexedNodes(nodeId, propertyKeyIds, propertyValues)).sum();
    }
}

