/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.kernel.api.query.ExecutingQuery;

abstract class ExecutingQueryList {
    static final ExecutingQueryList EMPTY = new ExecutingQueryList(){

        @Override
        Stream<ExecutingQuery> queries() {
            return Stream.empty();
        }

        @Override
        ExecutingQueryList push(ExecutingQuery newExecutingQuery) {
            return new Entry(newExecutingQuery, this);
        }

        @Override
        ExecutingQueryList remove(ExecutingQuery parent, ExecutingQuery target) {
            return this;
        }

        @Override
        <T> T top(Function<ExecutingQuery, T> accessor) {
            return null;
        }

        @Override
        void waitsFor(ExecutingQuery query) {
        }
    };

    ExecutingQueryList() {
    }

    abstract Stream<ExecutingQuery> queries();

    abstract ExecutingQueryList push(ExecutingQuery var1);

    final ExecutingQueryList remove(ExecutingQuery executingQuery) {
        return this.remove(null, executingQuery);
    }

    abstract ExecutingQueryList remove(ExecutingQuery var1, ExecutingQuery var2);

    abstract <T> T top(Function<ExecutingQuery, T> var1);

    abstract void waitsFor(ExecutingQuery var1);

    private static class Entry
    extends ExecutingQueryList {
        private final ExecutingQuery query;
        private final ExecutingQueryList next;

        Entry(ExecutingQuery query, ExecutingQueryList next) {
            this.query = query;
            this.next = next;
        }

        @Override
        Stream<ExecutingQuery> queries() {
            Stream.Builder<ExecutingQuery> builder = Stream.builder();
            ExecutingQueryList entry = this;
            while (entry != EMPTY) {
                Entry current = entry;
                builder.accept(current.query);
                entry = current.next;
            }
            return builder.build();
        }

        @Override
        ExecutingQueryList push(ExecutingQuery newExecutingQuery) {
            assert (newExecutingQuery.internalQueryId() > this.query.internalQueryId());
            this.waitsFor(newExecutingQuery);
            return new Entry(newExecutingQuery, this);
        }

        @Override
        ExecutingQueryList remove(ExecutingQuery parent, ExecutingQuery target) {
            if (target.equals(this.query)) {
                this.next.waitsFor(parent);
                return this.next;
            }
            ExecutingQueryList removed = this.next.remove(parent, target);
            if (removed == this.next) {
                return this;
            }
            return new Entry(this.query, removed);
        }

        @Override
        <T> T top(Function<ExecutingQuery, T> accessor) {
            return accessor.apply(this.query);
        }

        @Override
        void waitsFor(ExecutingQuery child) {
            this.query.waitsForQuery(child);
        }
    }
}

