/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.kernel.impl.transaction.command.Command;

public class EntityCommandGrouper<ENTITY extends Command> {
    private final Comparator<Command> COMMAND_COMPARATOR = new Comparator<Command>(){

        @Override
        public int compare(Command o1, Command o2) {
            int entityIdComparison = Long.compare(this.entityId(o1), this.entityId(o2));
            return entityIdComparison != 0 ? entityIdComparison : Integer.compare(this.commandType(o1), this.commandType(o2));
        }

        private long entityId(Command command) {
            if (command.getClass() == EntityCommandGrouper.this.entityCommandClass) {
                return command.getKey();
            }
            return ((Command.PropertyCommand)command).getEntityId();
        }

        private int commandType(Command command) {
            return command.getClass() == EntityCommandGrouper.this.entityCommandClass ? 0 : 1;
        }
    };
    private final Class<ENTITY> entityCommandClass;
    private Command[] commands;
    private int writeCursor;

    public EntityCommandGrouper(Class<ENTITY> entityCommandClass, int sizeHint) {
        this.entityCommandClass = entityCommandClass;
        this.commands = new Command[sizeHint];
    }

    public void add(Command command) {
        if (this.writeCursor == this.commands.length) {
            this.commands = Arrays.copyOf(this.commands, this.commands.length * 2);
        }
        this.commands[this.writeCursor++] = command;
    }

    public Cursor sortAndAccessGroups() {
        Arrays.sort(this.commands, 0, this.writeCursor, this.COMMAND_COMPARATOR);
        return new Cursor();
    }

    public void clear() {
        if (this.writeCursor > 1000) {
            Arrays.fill(this.commands, 1000, this.writeCursor, null);
        }
        this.writeCursor = 0;
    }

    public class Cursor {
        private int readCursor;
        private long currentEntity;
        private ENTITY currentEntityCommand;

        public boolean nextEntity() {
            if (this.readCursor >= EntityCommandGrouper.this.writeCursor) {
                return false;
            }
            if (EntityCommandGrouper.this.commands[this.readCursor].getClass() == EntityCommandGrouper.this.entityCommandClass) {
                this.currentEntityCommand = EntityCommandGrouper.this.commands[this.readCursor++];
                this.currentEntity = ((Command)this.currentEntityCommand).getKey();
            } else {
                Command.PropertyCommand firstPropertyCommand = (Command.PropertyCommand)EntityCommandGrouper.this.commands[this.readCursor];
                this.currentEntityCommand = null;
                this.currentEntity = firstPropertyCommand.getEntityId();
            }
            return true;
        }

        public Command.PropertyCommand nextProperty() {
            Command command;
            if (this.readCursor < EntityCommandGrouper.this.writeCursor && (command = EntityCommandGrouper.this.commands[this.readCursor]) instanceof Command.PropertyCommand && ((Command.PropertyCommand)command).getEntityId() == this.currentEntity) {
                ++this.readCursor;
                return (Command.PropertyCommand)command;
            }
            return null;
        }

        public long currentEntityId() {
            return this.currentEntity;
        }

        public ENTITY currentEntityCommand() {
            return this.currentEntityCommand;
        }
    }
}

