/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts.keys;

import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.util.IdPrettyPrinter;

public final class NodeKey
implements CountsKey {
    private final int labelId;

    NodeKey(int labelId) {
        this.labelId = labelId;
    }

    public int getLabelId() {
        return this.labelId;
    }

    public String toString() {
        return String.format("NodeKey[(%s)]", IdPrettyPrinter.label(this.labelId));
    }

    @Override
    public void accept(CountsVisitor visitor, long ignored, long count) {
        visitor.visitNodeCount(this.labelId, count);
    }

    @Override
    public CountsKeyType recordType() {
        return CountsKeyType.ENTITY_NODE;
    }

    public int hashCode() {
        int result = this.labelId;
        result = 31 * result + this.recordType().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof NodeKey && this.labelId == ((NodeKey)o).labelId;
    }

    @Override
    public int compareTo(CountsKey other) {
        if (other instanceof NodeKey) {
            NodeKey that = (NodeKey)other;
            return Integer.compare(this.labelId, that.labelId);
        }
        return this.recordType().compareTo(other.recordType());
    }
}

