/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.v1.messaging.response.FailureMessage;
import org.neo4j.bolt.v1.messaging.response.FatalFailureMessage;
import org.neo4j.bolt.v1.messaging.response.IgnoredMessage;
import org.neo4j.bolt.v1.messaging.response.SuccessMessage;
import org.neo4j.bolt.v1.packstream.PackOutputClosedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public class MessageProcessingHandler
implements BoltResponseHandler {
    private static final Set<Status> CLIENT_MID_OP_DISCONNECT_ERRORS = new HashSet<Status.Transaction>(Arrays.asList(Status.Transaction.Terminated, Status.Transaction.LockClientStopped));
    private final MapValueBuilder metadata = new MapValueBuilder();
    protected final Log log;
    protected final BoltConnection connection;
    protected final BoltResponseMessageWriter messageWriter;
    private Neo4jError error;
    private boolean ignored;

    public MessageProcessingHandler(BoltResponseMessageWriter messageWriter, BoltConnection connection, Log logger) {
        this.messageWriter = messageWriter;
        this.connection = connection;
        this.log = logger;
    }

    @Override
    public void onRecords(BoltResult result, boolean pull) throws Exception {
    }

    @Override
    public void onMetadata(String key, AnyValue value) {
        this.metadata.add(key, value);
    }

    @Override
    public void markIgnored() {
        this.ignored = true;
    }

    @Override
    public void markFailed(Neo4jError error) {
        this.error = error;
    }

    @Override
    public void onFinish() {
        try {
            if (this.ignored) {
                this.messageWriter.write(IgnoredMessage.IGNORED_MESSAGE);
            } else if (this.error != null) {
                this.publishError(this.messageWriter, this.error);
            } else {
                this.messageWriter.write(new SuccessMessage(this.getMetadata()));
            }
        }
        catch (Throwable e) {
            this.connection.stop();
            this.log.error("Failed to write response to driver", e);
        }
        finally {
            this.clearState();
        }
    }

    MapValue getMetadata() {
        return this.metadata.build();
    }

    private void clearState() {
        this.error = null;
        this.ignored = false;
        this.metadata.clear();
    }

    private void publishError(BoltResponseMessageWriter messageWriter, Neo4jError error) {
        try {
            if (error.isFatal()) {
                messageWriter.write(new FatalFailureMessage(error.status(), error.message()));
            } else {
                messageWriter.write(new FailureMessage(error.status(), error.message()));
            }
        }
        catch (PackOutputClosedException e) {
            if (CLIENT_MID_OP_DISCONNECT_ERRORS.contains(error.status())) {
                this.log.warn("Client %s disconnected while query was running. Session has been cleaned up. This can be caused by temporary network problems, but if you see this often, ensure your applications are properly waiting for operations to complete before exiting.", new Object[]{e.clientAddress()});
                return;
            }
            this.log.warn("Unable to send error back to the client. " + e.getMessage(), error.cause());
        }
        catch (Throwable t) {
            t.addSuppressed(error.cause());
            this.log.error("Unable to send error back to the client", t);
        }
    }
}

