/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.util.FeatureToggles;

public class PooledConcurrentMergeScheduler
extends ConcurrentMergeScheduler {
    private static final int POOL_QUEUE_CAPACITY = FeatureToggles.getInteger(PooledConcurrentMergeScheduler.class, (String)"pool.queue.capacity", (int)100);
    private static final int POOL_MINIMUM_THREADS = FeatureToggles.getInteger(PooledConcurrentMergeScheduler.class, (String)"pool.minimum.threads", (int)4);
    private static final int POOL_MAXIMUM_THREADS = FeatureToggles.getInteger(PooledConcurrentMergeScheduler.class, (String)"pool.maximum.threads", (int)10);
    private final LongAdder writerTaskCounter = new LongAdder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(IndexWriter writer, MergeTrigger trigger, boolean newMergesFound) throws IOException {
        MergePolicy.OneMerge merge;
        while ((merge = writer.getNextMerge()) != null) {
            boolean success = false;
            try {
                ConcurrentMergeScheduler.MergeThread mergeThread = this.getMergeThread(writer, merge);
                this.writerTaskCounter.increment();
                PooledConcurrentMergePool.mergeThreadsPool.submit(this.mergeTask(mergeThread));
                success = true;
                continue;
            }
            finally {
                if (success) continue;
                writer.mergeFinish(merge);
                this.writerTaskCounter.decrement();
                continue;
            }
            break;
        }
        return;
    }

    public void close() {
        this.waitForAllTasks();
        super.close();
    }

    protected void updateMergeThreads() {
    }

    void removeMergeThread() {
    }

    long getWriterTaskCount() {
        return this.writerTaskCounter.longValue();
    }

    private Runnable mergeTask(ConcurrentMergeScheduler.MergeThread mergeThread) {
        return new MergeTask(mergeThread, this.writerTaskCounter);
    }

    private void waitForAllTasks() {
        try {
            Predicates.await(() -> this.writerTaskCounter.longValue() == 0L, (long)10L, (TimeUnit)TimeUnit.MINUTES, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static /* synthetic */ int access$100() {
        return POOL_MINIMUM_THREADS;
    }

    static /* synthetic */ int access$200() {
        return POOL_QUEUE_CAPACITY;
    }

    private static class MergeTask
    implements Runnable {
        private final ConcurrentMergeScheduler.MergeThread mergeThread;
        private final LongAdder taskCounter;

        MergeTask(ConcurrentMergeScheduler.MergeThread mergeThread, LongAdder taskCounter) {
            this.mergeThread = mergeThread;
            this.taskCounter = taskCounter;
        }

        @Override
        public void run() {
            try {
                this.mergeThread.run();
            }
            finally {
                this.taskCounter.decrement();
            }
        }
    }

    private static class PooledConcurrentMergePool {
        private static final ExecutorService mergeThreadsPool = new ThreadPoolExecutor(PooledConcurrentMergeScheduler.access$100(), PooledConcurrentMergePool.getMaximumPoolSize(), 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(PooledConcurrentMergeScheduler.access$200()), (ThreadFactory)new NamedThreadFactory("Lucene-Merge", true), new ThreadPoolExecutor.CallerRunsPolicy());

        private PooledConcurrentMergePool() {
        }

        private static int getMaximumPoolSize() {
            return Math.max(POOL_MAXIMUM_THREADS, Runtime.getRuntime().availableProcessors());
        }
    }
}

