/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.builder;

import java.io.File;
import java.util.Objects;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.builder.LuceneIndexStorageBuilder;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;

public abstract class AbstractLuceneIndexBuilder<T extends AbstractLuceneIndexBuilder<T>> {
    protected LuceneIndexStorageBuilder storageBuilder = LuceneIndexStorageBuilder.create();
    private final Config config;
    private OperationalMode operationalMode = OperationalMode.single;

    public AbstractLuceneIndexBuilder(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public T withIndexStorage(PartitionedIndexStorage indexStorage) {
        this.storageBuilder.withIndexStorage(indexStorage);
        return (T)this;
    }

    public T withDirectoryFactory(DirectoryFactory directoryFactory) {
        this.storageBuilder.withDirectoryFactory(directoryFactory);
        return (T)this;
    }

    public T withFileSystem(FileSystemAbstraction fileSystem) {
        this.storageBuilder.withFileSystem(fileSystem);
        return (T)this;
    }

    public T withIndexRootFolder(File indexRootFolder) {
        this.storageBuilder.withIndexFolder(indexRootFolder);
        return (T)this;
    }

    public T withOperationalMode(OperationalMode operationalMode) {
        this.operationalMode = operationalMode;
        return (T)this;
    }

    protected boolean isReadOnly() {
        return (Boolean)this.getConfig(GraphDatabaseSettings.read_only) != false && OperationalMode.single == this.operationalMode;
    }

    protected <F> F getConfig(Setting<F> flag) {
        return (F)this.config.get(flag);
    }
}

