/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import org.neo4j.configuration.ConfigValue;
import org.neo4j.jmx.Description;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.internal.KernelData;

@Description(value="The configuration parameters used to configure Neo4j")
@Deprecated
public final class ConfigurationBean
extends Neo4jMBean {
    public static final String CONFIGURATION_MBEAN_NAME = "Configuration";
    private final Map<String, ConfigValue> config;

    ConfigurationBean(KernelData kernel, ManagementSupport support) throws NotCompliantMBeanException {
        super(CONFIGURATION_MBEAN_NAME, kernel, support);
        this.config = kernel.getConfig().getConfigValues();
    }

    private String describeConfigParameter(String param) {
        return this.config.get(param).description().orElse("Configuration attribute");
    }

    private MBeanAttributeInfo[] keys() {
        ArrayList<MBeanAttributeInfo> keys = new ArrayList<MBeanAttributeInfo>();
        for (String key : this.config.keySet()) {
            keys.add(new MBeanAttributeInfo(key, String.class.getName(), this.describeConfigParameter(key), true, false, false));
        }
        return keys.toArray(new MBeanAttributeInfo[keys.size()]);
    }

    @Override
    public Object getAttribute(String attribute) {
        return this.config.get(attribute).valueAsString().orElse(null);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList(attributes.length);
        for (String attribute : attributes) {
            try {
                result.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public void setAttribute(Attribute attribute) throws InvalidAttributeValueException {
        throw new InvalidAttributeValueException("Not a writable attribute: " + attribute.getName());
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        Description description = this.getClass().getAnnotation(Description.class);
        return new MBeanInfo(this.getClass().getName(), description != null ? description.value() : "Neo4j configuration", this.keys(), null, null, null);
    }

    @Override
    public Object invoke(String s, Object[] objects, String[] strings) throws MBeanException {
        try {
            return this.getClass().getMethod(s, new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new MBeanException((Exception)e.getTargetException());
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }
}

