/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public final class Bookmarks {
    private static final String BOOKMARK_KEY = "bookmark";
    private static final String BOOKMARKS_KEY = "bookmarks";
    private static final String BOOKMARK_PREFIX = "neo4j:bookmark:v1:tx";
    private static final long UNKNOWN_BOOKMARK_VALUE = -1L;
    private static final Bookmarks EMPTY = new Bookmarks(Collections.emptySet());
    private final Iterable<String> values;
    private final String maxValue;

    private Bookmarks(Iterable<String> values2) {
        this.values = values2;
        this.maxValue = Bookmarks.maxBookmark(values2);
    }

    public static Bookmarks empty() {
        return EMPTY;
    }

    public static Bookmarks from(String value2) {
        if (value2 == null) {
            return Bookmarks.empty();
        }
        return Bookmarks.from(Collections.singleton(value2));
    }

    public static Bookmarks from(Iterable<String> values2) {
        if (values2 == null) {
            return Bookmarks.empty();
        }
        return new Bookmarks(values2);
    }

    public boolean isEmpty() {
        return this.maxValue == null;
    }

    public String maxBookmarkAsString() {
        return this.maxValue;
    }

    public Iterable<String> values() {
        return this.values;
    }

    public Map<String, Value> asBeginTransactionParameters() {
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Value> parameters = Iterables.newHashMapWithSize(2);
        parameters.put(BOOKMARK_KEY, Values.value(this.maxValue));
        parameters.put(BOOKMARKS_KEY, Values.value(this.values));
        return parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bookmarks bookmarks = (Bookmarks)o;
        return Objects.equals(this.values, bookmarks.values) && Objects.equals(this.maxValue, bookmarks.maxValue);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.maxValue);
    }

    public String toString() {
        return "Bookmarks{values=" + this.values + "}";
    }

    private static String maxBookmark(Iterable<String> bookmarks) {
        if (bookmarks == null) {
            return null;
        }
        Iterator<String> iterator2 = bookmarks.iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        String maxBookmark = iterator2.next();
        long maxValue = Bookmarks.bookmarkValue(maxBookmark);
        while (iterator2.hasNext()) {
            String bookmark = iterator2.next();
            long value2 = Bookmarks.bookmarkValue(bookmark);
            if (value2 <= maxValue) continue;
            maxBookmark = bookmark;
            maxValue = value2;
        }
        return maxBookmark;
    }

    private static long bookmarkValue(String value2) {
        if (value2 != null && value2.startsWith(BOOKMARK_PREFIX)) {
            try {
                return Long.parseLong(value2.substring(BOOKMARK_PREFIX.length()));
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }
}

