/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.driver.internal.types.InternalMapAccessorWithDefaultValue;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Format;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.util.Function;
import org.neo4j.driver.v1.util.Pair;

public class InternalRecord
extends InternalMapAccessorWithDefaultValue
implements Record {
    private final List<String> keys;
    private final Value[] values;
    private int hashCode = 0;

    public InternalRecord(List<String> keys, Value[] values2) {
        this.keys = keys;
        this.values = values2;
    }

    @Override
    public List<String> keys() {
        return this.keys;
    }

    @Override
    public List<Value> values() {
        return Arrays.asList(this.values);
    }

    @Override
    public List<Pair<String, Value>> fields() {
        return Extract.fields(this, Values.ofValue());
    }

    @Override
    public int index(String key) {
        int result2 = this.keys.indexOf(key);
        if (result2 == -1) {
            throw new NoSuchElementException("Unknown key: " + key);
        }
        return result2;
    }

    @Override
    public boolean containsKey(String key) {
        return this.keys.contains(key);
    }

    @Override
    public Value get(String key) {
        int fieldIndex = this.keys.indexOf(key);
        if (fieldIndex == -1) {
            return Values.NULL;
        }
        return this.values[fieldIndex];
    }

    @Override
    public Value get(int index) {
        return index >= 0 && index < this.values.length ? this.values[index] : Values.NULL;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Map<String, Object> asMap() {
        return Extract.map(this, Values.ofObject());
    }

    @Override
    public <T> Map<String, T> asMap(Function<Value, T> mapper) {
        return Extract.map(this, mapper);
    }

    public String toString() {
        return String.format("Record<%s>", Format.formatPairs(this.asMap(Values.ofValue())));
    }

    public boolean equals(Object other2) {
        if (this == other2) {
            return true;
        }
        if (other2 instanceof Record) {
            Record otherRecord = (Record)other2;
            int size2 = this.size();
            if (size2 != otherRecord.size()) {
                return false;
            }
            if (!this.keys.equals(otherRecord.keys())) {
                return false;
            }
            for (int i = 0; i < size2; ++i) {
                Value otherValue;
                Value value2 = this.get(i);
                if (value2.equals(otherValue = otherRecord.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 31 * this.keys.hashCode() + Arrays.hashCode(this.values);
        }
        return this.hashCode;
    }
}

