/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster.loadbalancing;

import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.RoundRobinArrayIndex;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class RoundRobinLoadBalancingStrategy
implements LoadBalancingStrategy {
    private static final String LOGGER_NAME = RoundRobinLoadBalancingStrategy.class.getSimpleName();
    private final RoundRobinArrayIndex readersIndex = new RoundRobinArrayIndex();
    private final RoundRobinArrayIndex writersIndex = new RoundRobinArrayIndex();
    private final Logger log;

    public RoundRobinLoadBalancingStrategy(Logging logging) {
        this.log = logging.getLog(LOGGER_NAME);
    }

    @Override
    public BoltServerAddress selectReader(BoltServerAddress[] knownReaders) {
        return this.select(knownReaders, this.readersIndex, "reader");
    }

    @Override
    public BoltServerAddress selectWriter(BoltServerAddress[] knownWriters) {
        return this.select(knownWriters, this.writersIndex, "writer");
    }

    private BoltServerAddress select(BoltServerAddress[] addresses, RoundRobinArrayIndex roundRobinIndex, String addressType) {
        int length2 = addresses.length;
        if (length2 == 0) {
            this.log.trace("Unable to select %s, no known addresses given", addressType);
            return null;
        }
        int index = roundRobinIndex.next(length2);
        BoltServerAddress address = addresses[index];
        this.log.trace("Selected %s with address: '%s'", addressType, address);
        return address;
    }
}

