/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

abstract class TransactionStartingMessage
implements Message {
    private static final String BOOKMARKS_METADATA_KEY = "bookmarks";
    private static final String TX_TIMEOUT_METADATA_KEY = "tx_timeout";
    private static final String TX_METADATA_METADATA_KEY = "tx_metadata";
    private static final String MODE_KEY = "mode";
    private static final String MODE_READ_VALUE = "r";
    final Map<String, Value> metadata;

    TransactionStartingMessage(Bookmarks bookmarks, Duration txTimeout, Map<String, Value> txMetadata, AccessMode mode) {
        this.metadata = TransactionStartingMessage.buildMetadata(bookmarks, txTimeout, txMetadata, mode);
    }

    public final Map<String, Value> metadata() {
        return this.metadata;
    }

    private static Map<String, Value> buildMetadata(Bookmarks bookmarks, Duration txTimeout, Map<String, Value> txMetadata, AccessMode mode) {
        boolean accessModePresent;
        boolean bookmarksPresent = bookmarks != null && !bookmarks.isEmpty();
        boolean txTimeoutPresent = txTimeout != null;
        boolean txMetadataPresent = txMetadata != null && !txMetadata.isEmpty();
        boolean bl = accessModePresent = mode == AccessMode.READ;
        if (!(bookmarksPresent || txTimeoutPresent || txMetadataPresent || accessModePresent)) {
            return Collections.emptyMap();
        }
        HashMap<String, Value> result2 = Iterables.newHashMapWithSize(3);
        if (bookmarksPresent) {
            result2.put(BOOKMARKS_METADATA_KEY, Values.value(bookmarks.values()));
        }
        if (txTimeoutPresent) {
            result2.put(TX_TIMEOUT_METADATA_KEY, Values.value(txTimeout.toMillis()));
        }
        if (txMetadataPresent) {
            result2.put(TX_METADATA_METADATA_KEY, Values.value(txMetadata));
        }
        switch (mode) {
            case READ: {
                result2.put(MODE_KEY, Values.value(MODE_READ_VALUE));
            }
        }
        return result2;
    }
}

