/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v1;

import java.io.IOException;
import java.util.Map;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.packstream.PackStream;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.v1.Value;

public class ValuePackerV1
implements ValuePacker {
    protected final PackStream.Packer packer;
    private final boolean byteArraySupportEnabled;

    public ValuePackerV1(PackOutput output, boolean byteArraySupportEnabled) {
        this.packer = new PackStream.Packer(output);
        this.byteArraySupportEnabled = byteArraySupportEnabled;
    }

    @Override
    public final void packStructHeader(int size2, byte signature) throws IOException {
        this.packer.packStructHeader(size2, signature);
    }

    @Override
    public final void pack(String string2) throws IOException {
        this.packer.pack(string2);
    }

    @Override
    public final void pack(Value value2) throws IOException {
        if (!(value2 instanceof InternalValue)) {
            throw new IllegalArgumentException("Unable to pack: " + value2);
        }
        this.packInternalValue((InternalValue)value2);
    }

    @Override
    public final void pack(Map<String, Value> map2) throws IOException {
        if (map2 == null || map2.size() == 0) {
            this.packer.packMapHeader(0);
            return;
        }
        this.packer.packMapHeader(map2.size());
        for (Map.Entry<String, Value> entry : map2.entrySet()) {
            this.packer.pack(entry.getKey());
            this.pack(entry.getValue());
        }
    }

    protected void packInternalValue(InternalValue value2) throws IOException {
        switch (value2.typeConstructor()) {
            case NULL: {
                this.packer.packNull();
                break;
            }
            case BYTES: {
                if (!this.byteArraySupportEnabled) {
                    throw new PackStream.UnPackable("Packing bytes is not supported as the current server this driver connected to does not support unpack bytes.");
                }
                this.packer.pack(value2.asByteArray());
                break;
            }
            case STRING: {
                this.packer.pack(value2.asString());
                break;
            }
            case BOOLEAN: {
                this.packer.pack(value2.asBoolean());
                break;
            }
            case INTEGER: {
                this.packer.pack(value2.asLong());
                break;
            }
            case FLOAT: {
                this.packer.pack(value2.asDouble());
                break;
            }
            case MAP: {
                this.packer.packMapHeader(value2.size());
                for (String s2 : value2.keys()) {
                    this.packer.pack(s2);
                    this.pack(value2.get(s2));
                }
                break;
            }
            case LIST: {
                this.packer.packListHeader(value2.size());
                for (Value item : value2.values()) {
                    this.pack(item);
                }
                break;
            }
            default: {
                throw new IOException("Unknown type: " + value2.type().name());
            }
        }
    }
}

