/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PoolChunk;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PoolThreadCache;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PooledByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.SwappedByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnsafeByteBufUtil;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnsafeDirectSwappedByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.util.Recycler;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

final class PooledUnsafeDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final Recycler<PooledUnsafeDirectByteBuf> RECYCLER = new Recycler<PooledUnsafeDirectByteBuf>(){

        @Override
        protected PooledUnsafeDirectByteBuf newObject(Recycler.Handle<PooledUnsafeDirectByteBuf> handle) {
            return new PooledUnsafeDirectByteBuf(handle, 0);
        }
    };
    private long memoryAddress;

    static PooledUnsafeDirectByteBuf newInstance(int maxCapacity) {
        PooledUnsafeDirectByteBuf buf = RECYCLER.get();
        buf.reuse(maxCapacity);
        return buf;
    }

    private PooledUnsafeDirectByteBuf(Recycler.Handle<PooledUnsafeDirectByteBuf> recyclerHandle, int maxCapacity) {
        super(recyclerHandle, maxCapacity);
    }

    @Override
    void init(PoolChunk<ByteBuffer> chunk, long handle, int offset, int length2, int maxLength, PoolThreadCache cache) {
        super.init(chunk, handle, offset, length2, maxLength, cache);
        this.initMemoryAddress();
    }

    @Override
    void initUnpooled(PoolChunk<ByteBuffer> chunk, int length2) {
        super.initUnpooled(chunk, length2);
        this.initMemoryAddress();
    }

    private void initMemoryAddress() {
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.memory) + (long)this.offset;
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(ByteBuffer memory) {
        return memory.duplicate();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    protected byte _getByte(int index) {
        return UnsafeByteBufUtil.getByte(this.addr(index));
    }

    @Override
    protected short _getShort(int index) {
        return UnsafeByteBufUtil.getShort(this.addr(index));
    }

    @Override
    protected short _getShortLE(int index) {
        return UnsafeByteBufUtil.getShortLE(this.addr(index));
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(index));
    }

    @Override
    protected int _getUnsignedMediumLE(int index) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr(index));
    }

    @Override
    protected int _getInt(int index) {
        return UnsafeByteBufUtil.getInt(this.addr(index));
    }

    @Override
    protected int _getIntLE(int index) {
        return UnsafeByteBufUtil.getIntLE(this.addr(index));
    }

    @Override
    protected long _getLong(int index) {
        return UnsafeByteBufUtil.getLong(this.addr(index));
    }

    @Override
    protected long _getLongLE(int index) {
        return UnsafeByteBufUtil.getLongLE(this.addr(index));
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length2) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(index), index, dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length2) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(index), index, dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        UnsafeByteBufUtil.getBytes(this, this.addr(index), index, dst);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        int length2 = dst.remaining();
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length2) throws IOException {
        UnsafeByteBufUtil.getBytes(this, this.addr(index), index, out, length2);
        return this;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length2) throws IOException {
        return this.getBytes(index, out, length2, false);
    }

    private int getBytes(int index, GatheringByteChannel out, int length2, boolean internal) throws IOException {
        this.checkIndex(index, length2);
        if (length2 == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + length2);
        return out.write(tmpBuf);
    }

    @Override
    public int getBytes(int index, FileChannel out, long position2, int length2) throws IOException {
        return this.getBytes(index, out, position2, length2, false);
    }

    private int getBytes(int index, FileChannel out, long position2, int length2, boolean internal) throws IOException {
        this.checkIndex(index, length2);
        if (length2 == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + length2);
        return out.write(tmpBuf, position2);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes = this.getBytes(this.readerIndex, out, length2, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    public int readBytes(FileChannel out, long position2, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes = this.getBytes(this.readerIndex, out, position2, length2, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    protected void _setByte(int index, int value2) {
        UnsafeByteBufUtil.setByte(this.addr(index), (byte)value2);
    }

    @Override
    protected void _setShort(int index, int value2) {
        UnsafeByteBufUtil.setShort(this.addr(index), value2);
    }

    @Override
    protected void _setShortLE(int index, int value2) {
        UnsafeByteBufUtil.setShortLE(this.addr(index), value2);
    }

    @Override
    protected void _setMedium(int index, int value2) {
        UnsafeByteBufUtil.setMedium(this.addr(index), value2);
    }

    @Override
    protected void _setMediumLE(int index, int value2) {
        UnsafeByteBufUtil.setMediumLE(this.addr(index), value2);
    }

    @Override
    protected void _setInt(int index, int value2) {
        UnsafeByteBufUtil.setInt(this.addr(index), value2);
    }

    @Override
    protected void _setIntLE(int index, int value2) {
        UnsafeByteBufUtil.setIntLE(this.addr(index), value2);
    }

    @Override
    protected void _setLong(int index, long value2) {
        UnsafeByteBufUtil.setLong(this.addr(index), value2);
    }

    @Override
    protected void _setLongLE(int index, long value2) {
        UnsafeByteBufUtil.setLongLE(this.addr(index), value2);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length2) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(index), index, src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length2) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(index), index, src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        UnsafeByteBufUtil.setBytes(this, this.addr(index), index, src);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream in2, int length2) throws IOException {
        return UnsafeByteBufUtil.setBytes(this, this.addr(index), index, in2, length2);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in2, int length2) throws IOException {
        this.checkIndex(index, length2);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + length2);
        try {
            return in2.read(tmpBuf);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public int setBytes(int index, FileChannel in2, long position2, int length2) throws IOException {
        this.checkIndex(index, length2);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + length2);
        try {
            return in2.read(tmpBuf, position2);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public ByteBuf copy(int index, int length2) {
        return UnsafeByteBufUtil.copy(this, this.addr(index), index, length2);
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length2) {
        return new ByteBuffer[]{this.nioBuffer(index, length2)};
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length2) {
        this.checkIndex(index, length2);
        index = this.idx(index);
        return ((ByteBuffer)((ByteBuffer)this.memory).duplicate().position(index).limit(index + length2)).slice();
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length2) {
        this.checkIndex(index, length2);
        index = this.idx(index);
        return (ByteBuffer)this.internalNioBuffer().clear().position(index).limit(index + length2);
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    private long addr(int index) {
        return this.memoryAddress + (long)index;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public ByteBuf setZero(int index, int length2) {
        this.checkIndex(index, length2);
        UnsafeByteBufUtil.setZero(this.addr(index), length2);
        return this;
    }

    @Override
    public ByteBuf writeZero(int length2) {
        this.ensureWritable(length2);
        int wIndex = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(wIndex), length2);
        this.writerIndex = wIndex + length2;
        return this;
    }
}

