/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.neo4j.driver.internal.shaded.io.netty.util.ByteProcessor;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.HashingStrategy;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.EmptyArrays;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.InternalThreadLocalMap;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.MathUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ObjectUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public final class AsciiString
implements CharSequence,
Comparable<CharSequence> {
    public static final AsciiString EMPTY_STRING = AsciiString.cached("");
    private static final char MAX_CHAR_VALUE = '\u00ff';
    public static final int INDEX_NOT_FOUND = -1;
    private final byte[] value;
    private final int offset;
    private final int length;
    private int hash;
    private String string;
    public static final HashingStrategy<CharSequence> CASE_INSENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEqualsIgnoreCase(a, b);
        }
    };
    public static final HashingStrategy<CharSequence> CASE_SENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEquals(a, b);
        }
    };

    public AsciiString(byte[] value2) {
        this(value2, true);
    }

    public AsciiString(byte[] value2, boolean copy2) {
        this(value2, 0, value2.length, copy2);
    }

    public AsciiString(byte[] value2, int start, int length2, boolean copy2) {
        if (copy2) {
            this.value = Arrays.copyOfRange(value2, start, start + length2);
            this.offset = 0;
        } else {
            if (MathUtil.isOutOfBounds(start, length2, value2.length)) {
                throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length2 + ") <= value.length(" + value2.length + ')');
            }
            this.value = value2;
            this.offset = start;
        }
        this.length = length2;
    }

    public AsciiString(ByteBuffer value2) {
        this(value2, true);
    }

    public AsciiString(ByteBuffer value2, boolean copy2) {
        this(value2, value2.position(), value2.remaining(), copy2);
    }

    public AsciiString(ByteBuffer value2, int start, int length2, boolean copy2) {
        if (MathUtil.isOutOfBounds(start, length2, value2.capacity())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length2 + ") <= value.capacity(" + value2.capacity() + ')');
        }
        if (value2.hasArray()) {
            if (copy2) {
                int bufferOffset = value2.arrayOffset() + start;
                this.value = Arrays.copyOfRange(value2.array(), bufferOffset, bufferOffset + length2);
                this.offset = 0;
            } else {
                this.value = value2.array();
                this.offset = start;
            }
        } else {
            this.value = new byte[length2];
            int oldPos = value2.position();
            value2.get(this.value, 0, length2);
            value2.position(oldPos);
            this.offset = 0;
        }
        this.length = length2;
    }

    public AsciiString(char[] value2) {
        this(value2, 0, value2.length);
    }

    public AsciiString(char[] value2, int start, int length2) {
        if (MathUtil.isOutOfBounds(start, length2, value2.length)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length2 + ") <= value.length(" + value2.length + ')');
        }
        this.value = new byte[length2];
        int i = 0;
        int j = start;
        while (i < length2) {
            this.value[i] = AsciiString.c2b(value2[j]);
            ++i;
            ++j;
        }
        this.offset = 0;
        this.length = length2;
    }

    public AsciiString(char[] value2, Charset charset) {
        this(value2, charset, 0, value2.length);
    }

    public AsciiString(char[] value2, Charset charset, int start, int length2) {
        CharBuffer cbuf = CharBuffer.wrap(value2, start, length2);
        CharsetEncoder encoder = CharsetUtil.encoder(charset);
        ByteBuffer nativeBuffer = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)length2));
        encoder.encode(cbuf, nativeBuffer, true);
        int bufferOffset = nativeBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(nativeBuffer.array(), bufferOffset, bufferOffset + nativeBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public AsciiString(CharSequence value2) {
        this(value2, 0, value2.length());
    }

    public AsciiString(CharSequence value2, int start, int length2) {
        if (MathUtil.isOutOfBounds(start, length2, value2.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length2 + ") <= value.length(" + value2.length() + ')');
        }
        this.value = new byte[length2];
        int i = 0;
        int j = start;
        while (i < length2) {
            this.value[i] = AsciiString.c2b(value2.charAt(j));
            ++i;
            ++j;
        }
        this.offset = 0;
        this.length = length2;
    }

    public AsciiString(CharSequence value2, Charset charset) {
        this(value2, charset, 0, value2.length());
    }

    public AsciiString(CharSequence value2, Charset charset, int start, int length2) {
        CharBuffer cbuf = CharBuffer.wrap(value2, start, start + length2);
        CharsetEncoder encoder = CharsetUtil.encoder(charset);
        ByteBuffer nativeBuffer = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)length2));
        encoder.encode(cbuf, nativeBuffer, true);
        int offset = nativeBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(nativeBuffer.array(), offset, offset + nativeBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public int forEachByte(ByteProcessor visitor) throws Exception {
        return this.forEachByte0(0, this.length(), visitor);
    }

    public int forEachByte(int index, int length2, ByteProcessor visitor) throws Exception {
        if (MathUtil.isOutOfBounds(index, length2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + index + ") <= start + length(" + length2 + ") <= length(" + this.length() + ')');
        }
        return this.forEachByte0(index, length2, visitor);
    }

    private int forEachByte0(int index, int length2, ByteProcessor visitor) throws Exception {
        int len = this.offset + index + length2;
        for (int i = this.offset + index; i < len; ++i) {
            if (visitor.process(this.value[i])) continue;
            return i - this.offset;
        }
        return -1;
    }

    public int forEachByteDesc(ByteProcessor visitor) throws Exception {
        return this.forEachByteDesc0(0, this.length(), visitor);
    }

    public int forEachByteDesc(int index, int length2, ByteProcessor visitor) throws Exception {
        if (MathUtil.isOutOfBounds(index, length2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + index + ") <= start + length(" + length2 + ") <= length(" + this.length() + ')');
        }
        return this.forEachByteDesc0(index, length2, visitor);
    }

    private int forEachByteDesc0(int index, int length2, ByteProcessor visitor) throws Exception {
        int end = this.offset + index;
        for (int i = this.offset + index + length2 - 1; i >= end; --i) {
            if (visitor.process(this.value[i])) continue;
            return i - this.offset;
        }
        return -1;
    }

    public byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("index: " + index + " must be in the range [0," + this.length + ")");
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getByte(this.value, index + this.offset);
        }
        return this.value[index + this.offset];
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    public void arrayChanged() {
        this.string = null;
        this.hash = 0;
    }

    public byte[] array() {
        return this.value;
    }

    public int arrayOffset() {
        return this.offset;
    }

    public boolean isEntireArrayUsed() {
        return this.offset == 0 && this.length == this.value.length;
    }

    public byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    public byte[] toByteArray(int start, int end) {
        return Arrays.copyOfRange(this.value, start + this.offset, end + this.offset);
    }

    public void copy(int srcIdx, byte[] dst, int dstIdx, int length2) {
        if (MathUtil.isOutOfBounds(srcIdx, length2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length2 + ") <= srcLen(" + this.length() + ')');
        }
        System.arraycopy(this.value, srcIdx + this.offset, ObjectUtil.checkNotNull(dst, "dst"), dstIdx, length2);
    }

    @Override
    public char charAt(int index) {
        return AsciiString.b2c(this.byteAt(index));
    }

    public boolean contains(CharSequence cs) {
        return this.indexOf(cs) >= 0;
    }

    @Override
    public int compareTo(CharSequence string2) {
        if (this == string2) {
            return 0;
        }
        int length1 = this.length();
        int length2 = string2.length();
        int minLength = Math.min(length1, length2);
        int i = 0;
        int j = this.arrayOffset();
        while (i < minLength) {
            int result2 = AsciiString.b2c(this.value[j]) - string2.charAt(i);
            if (result2 != 0) {
                return result2;
            }
            ++i;
            ++j;
        }
        return length1 - length2;
    }

    public AsciiString concat(CharSequence string2) {
        int thisLen = this.length();
        int thatLen = string2.length();
        if (thatLen == 0) {
            return this;
        }
        if (string2.getClass() == AsciiString.class) {
            AsciiString that = (AsciiString)string2;
            if (this.isEmpty()) {
                return that;
            }
            byte[] newValue = new byte[thisLen + thatLen];
            System.arraycopy(this.value, this.arrayOffset(), newValue, 0, thisLen);
            System.arraycopy(that.value, that.arrayOffset(), newValue, thisLen, thatLen);
            return new AsciiString(newValue, false);
        }
        if (this.isEmpty()) {
            return new AsciiString(string2);
        }
        byte[] newValue = new byte[thisLen + thatLen];
        System.arraycopy(this.value, this.arrayOffset(), newValue, 0, thisLen);
        int i = thisLen;
        int j = 0;
        while (i < newValue.length) {
            newValue[i] = AsciiString.c2b(string2.charAt(j));
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public boolean endsWith(CharSequence suffix) {
        int suffixLen = suffix.length();
        return this.regionMatches(this.length() - suffixLen, suffix, 0, suffixLen);
    }

    public boolean contentEqualsIgnoreCase(CharSequence string2) {
        if (string2 == null || string2.length() != this.length()) {
            return false;
        }
        if (string2.getClass() == AsciiString.class) {
            AsciiString rhs = (AsciiString)string2;
            int i = this.arrayOffset();
            int j = rhs.arrayOffset();
            while (i < this.length()) {
                if (!AsciiString.equalsIgnoreCase(this.value[i], rhs.value[j])) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        int i = this.arrayOffset();
        int j = 0;
        while (i < this.length()) {
            if (!AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[i]), string2.charAt(j))) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public char[] toCharArray() {
        return this.toCharArray(0, this.length());
    }

    public char[] toCharArray(int start, int end) {
        int length2 = end - start;
        if (length2 == 0) {
            return EmptyArrays.EMPTY_CHARS;
        }
        if (MathUtil.isOutOfBounds(start, length2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= srcIdx + length(" + length2 + ") <= srcLen(" + this.length() + ')');
        }
        char[] buffer = new char[length2];
        int i = 0;
        int j = start + this.arrayOffset();
        while (i < length2) {
            buffer[i] = AsciiString.b2c(this.value[j]);
            ++i;
            ++j;
        }
        return buffer;
    }

    public void copy(int srcIdx, char[] dst, int dstIdx, int length2) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        if (MathUtil.isOutOfBounds(srcIdx, length2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length2 + ") <= srcLen(" + this.length() + ')');
        }
        int dstEnd = dstIdx + length2;
        int i = dstIdx;
        int j = srcIdx + this.arrayOffset();
        while (i < dstEnd) {
            dst[i] = AsciiString.b2c(this.value[j]);
            ++i;
            ++j;
        }
    }

    public AsciiString subSequence(int start) {
        return this.subSequence(start, this.length());
    }

    @Override
    public AsciiString subSequence(int start, int end) {
        return this.subSequence(start, end, true);
    }

    public AsciiString subSequence(int start, int end, boolean copy2) {
        if (MathUtil.isOutOfBounds(start, end - start, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= end (" + end + ") <= length(" + this.length() + ')');
        }
        if (start == 0 && end == this.length()) {
            return this;
        }
        if (end == start) {
            return EMPTY_STRING;
        }
        return new AsciiString(this.value, start + this.offset, end - start, copy2);
    }

    public int indexOf(CharSequence string2) {
        return this.indexOf(string2, 0);
    }

    public int indexOf(CharSequence subString, int start) {
        if (start < 0) {
            start = 0;
        }
        int thisLen = this.length();
        int subCount = subString.length();
        if (subCount <= 0) {
            return start < thisLen ? start : thisLen;
        }
        if (subCount > thisLen - start) {
            return -1;
        }
        char firstChar = subString.charAt(0);
        if (firstChar > '\u00ff') {
            return -1;
        }
        ByteProcessor.IndexOfProcessor IndexOfVisitor = new ByteProcessor.IndexOfProcessor((byte)firstChar);
        try {
            while (true) {
                int i;
                if ((i = this.forEachByte(start, thisLen - start, IndexOfVisitor)) == -1 || subCount + i > thisLen) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < subCount && AsciiString.b2c(this.value[++o1 + this.arrayOffset()]) == subString.charAt(o2)) {
                }
                if (o2 == subCount) {
                    return i;
                }
                start = i + 1;
            }
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
            return -1;
        }
    }

    public int indexOf(char ch, int start) {
        if (start < 0) {
            start = 0;
        }
        int thisLen = this.length();
        if (ch > '\u00ff') {
            return -1;
        }
        try {
            return this.forEachByte(start, thisLen - start, new ByteProcessor.IndexOfProcessor((byte)ch));
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
            return -1;
        }
    }

    public int lastIndexOf(CharSequence string2) {
        return this.lastIndexOf(string2, this.length());
    }

    public int lastIndexOf(CharSequence subString, int start) {
        int thisLen = this.length();
        int subCount = subString.length();
        if (subCount > thisLen || start < 0) {
            return -1;
        }
        if (subCount <= 0) {
            return start < thisLen ? start : thisLen;
        }
        start = Math.min(start, thisLen - subCount);
        char firstChar = subString.charAt(0);
        if (firstChar > '\u00ff') {
            return -1;
        }
        ByteProcessor.IndexOfProcessor IndexOfVisitor = new ByteProcessor.IndexOfProcessor((byte)firstChar);
        try {
            while (true) {
                int i;
                if ((i = this.forEachByteDesc(start, thisLen - start, IndexOfVisitor)) == -1) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < subCount && AsciiString.b2c(this.value[++o1 + this.arrayOffset()]) == subString.charAt(o2)) {
                }
                if (o2 == subCount) {
                    return i;
                }
                start = i - 1;
            }
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
            return -1;
        }
    }

    public boolean regionMatches(int thisStart, CharSequence string2, int start, int length2) {
        if (string2 == null) {
            throw new NullPointerException("string");
        }
        if (start < 0 || string2.length() - start < length2) {
            return false;
        }
        int thisLen = this.length();
        if (thisStart < 0 || thisLen - thisStart < length2) {
            return false;
        }
        if (length2 <= 0) {
            return true;
        }
        int thatEnd = start + length2;
        int i = start;
        int j = thisStart + this.arrayOffset();
        while (i < thatEnd) {
            if (AsciiString.b2c(this.value[j]) != string2.charAt(i)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase2, int thisStart, CharSequence string2, int start, int length2) {
        if (!ignoreCase2) {
            return this.regionMatches(thisStart, string2, start, length2);
        }
        if (string2 == null) {
            throw new NullPointerException("string");
        }
        int thisLen = this.length();
        if (thisStart < 0 || length2 > thisLen - thisStart) {
            return false;
        }
        if (start < 0 || length2 > string2.length() - start) {
            return false;
        }
        int thisEnd = (thisStart += this.arrayOffset()) + length2;
        while (thisStart < thisEnd) {
            if (AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[thisStart++]), string2.charAt(start++))) continue;
            return false;
        }
        return true;
    }

    public AsciiString replace(char oldChar, char newChar) {
        int index;
        if (oldChar > '\u00ff') {
            return this;
        }
        byte oldCharByte = AsciiString.c2b(oldChar);
        try {
            index = this.forEachByte(new ByteProcessor.IndexOfProcessor(oldCharByte));
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
            return this;
        }
        if (index == -1) {
            return this;
        }
        byte newCharByte = AsciiString.c2b(newChar);
        byte[] buffer = new byte[this.length()];
        int i = 0;
        int j = this.arrayOffset();
        while (i < buffer.length) {
            byte b = this.value[j];
            if (b == oldCharByte) {
                b = newCharByte;
            }
            buffer[i] = b;
            ++i;
            ++j;
        }
        return new AsciiString(buffer, false);
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(CharSequence prefix, int start) {
        return this.regionMatches(start, prefix, 0, prefix.length());
    }

    public AsciiString toLowerCase() {
        int i;
        boolean lowercased = true;
        int len = this.length() + this.arrayOffset();
        for (i = this.arrayOffset(); i < len; ++i) {
            byte b = this.value[i];
            if (b < 65 || b > 90) continue;
            lowercased = false;
            break;
        }
        if (lowercased) {
            return this;
        }
        byte[] newValue = new byte[this.length()];
        i = 0;
        int j = this.arrayOffset();
        while (i < newValue.length) {
            newValue[i] = AsciiString.toLowerCase(this.value[j]);
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public AsciiString toUpperCase() {
        int i;
        boolean uppercased = true;
        int len = this.length() + this.arrayOffset();
        for (i = this.arrayOffset(); i < len; ++i) {
            byte b = this.value[i];
            if (b < 97 || b > 122) continue;
            uppercased = false;
            break;
        }
        if (uppercased) {
            return this;
        }
        byte[] newValue = new byte[this.length()];
        i = 0;
        int j = this.arrayOffset();
        while (i < newValue.length) {
            newValue[i] = AsciiString.toUpperCase(this.value[j]);
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public static CharSequence trim(CharSequence c) {
        int start;
        int last2;
        if (c.getClass() == AsciiString.class) {
            return ((AsciiString)c).trim();
        }
        if (c instanceof String) {
            return ((String)c).trim();
        }
        int end = last2 = c.length() - 1;
        for (start = 0; start <= end && c.charAt(start) <= ' '; ++start) {
        }
        while (end >= start && c.charAt(end) <= ' ') {
            --end;
        }
        if (start == 0 && end == last2) {
            return c;
        }
        return c.subSequence(start, end);
    }

    public AsciiString trim() {
        int start;
        int last2;
        int end = last2 = this.arrayOffset() + this.length() - 1;
        for (start = this.arrayOffset(); start <= end && this.value[start] <= 32; ++start) {
        }
        while (end >= start && this.value[end] <= 32) {
            --end;
        }
        if (start == 0 && end == last2) {
            return this;
        }
        return new AsciiString(this.value, start, end - start + 1, false);
    }

    public boolean contentEquals(CharSequence a) {
        if (a == null || a.length() != this.length()) {
            return false;
        }
        if (a.getClass() == AsciiString.class) {
            return this.equals(a);
        }
        int i = this.arrayOffset();
        for (int j = 0; j < a.length(); ++j) {
            if (AsciiString.b2c(this.value[i]) != a.charAt(j)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean matches(String expr) {
        return Pattern.matches(expr, this);
    }

    public AsciiString[] split(String expr, int max2) {
        return AsciiString.toAsciiStringArray(Pattern.compile(expr).split(this, max2));
    }

    public AsciiString[] split(char delim) {
        int i;
        ArrayList<AsciiString> res = InternalThreadLocalMap.get().arrayList();
        int start = 0;
        int length2 = this.length();
        for (i = start; i < length2; ++i) {
            if (this.charAt(i) != delim) continue;
            if (start == i) {
                res.add(EMPTY_STRING);
            } else {
                res.add(new AsciiString(this.value, start + this.arrayOffset(), i - start, false));
            }
            start = i + 1;
        }
        if (start == 0) {
            res.add(this);
        } else if (start != length2) {
            res.add(new AsciiString(this.value, start + this.arrayOffset(), length2 - start, false));
        } else {
            for (i = res.size() - 1; i >= 0 && ((AsciiString)res.get(i)).isEmpty(); --i) {
                res.remove(i);
            }
        }
        return res.toArray(new AsciiString[res.size()]);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = PlatformDependent.hashCodeAscii(this.value, this.offset, this.length);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != AsciiString.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AsciiString other2 = (AsciiString)obj;
        return this.length() == other2.length() && this.hashCode() == other2.hashCode() && PlatformDependent.equals(this.array(), this.arrayOffset(), other2.array(), other2.arrayOffset(), this.length());
    }

    @Override
    public String toString() {
        String cache = this.string;
        if (cache == null) {
            this.string = cache = this.toString(0);
        }
        return cache;
    }

    public String toString(int start) {
        return this.toString(start, this.length());
    }

    public String toString(int start, int end) {
        int length2 = end - start;
        if (length2 == 0) {
            return "";
        }
        if (MathUtil.isOutOfBounds(start, length2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= srcIdx + length(" + length2 + ") <= srcLen(" + this.length() + ')');
        }
        String str2 = new String(this.value, 0, start + this.offset, length2);
        return str2;
    }

    public boolean parseBoolean() {
        return this.length >= 1 && this.value[this.offset] != 0;
    }

    public char parseChar() {
        return this.parseChar(0);
    }

    public char parseChar(int start) {
        if (start + 1 >= this.length()) {
            throw new IndexOutOfBoundsException("2 bytes required to convert to character. index " + start + " would go out of bounds.");
        }
        int startWithOffset = start + this.offset;
        return (char)(AsciiString.b2c(this.value[startWithOffset]) << 8 | AsciiString.b2c(this.value[startWithOffset + 1]));
    }

    public short parseShort() {
        return this.parseShort(0, this.length(), 10);
    }

    public short parseShort(int radix) {
        return this.parseShort(0, this.length(), radix);
    }

    public short parseShort(int start, int end) {
        return this.parseShort(start, end, 10);
    }

    public short parseShort(int start, int end, int radix) {
        int intValue = this.parseInt(start, end, radix);
        short result2 = (short)intValue;
        if (result2 != intValue) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return result2;
    }

    public int parseInt() {
        return this.parseInt(0, this.length(), 10);
    }

    public int parseInt(int radix) {
        return this.parseInt(0, this.length(), radix);
    }

    public int parseInt(int start, int end) {
        return this.parseInt(start, end, 10);
    }

    public int parseInt(int start, int end, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = start;
        boolean bl = negative = this.byteAt(i) == 45;
        if (negative && ++i == end) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return this.parseInt(i, end, radix, negative);
    }

    private int parseInt(int start, int end, int radix, boolean negative) {
        int max2 = Integer.MIN_VALUE / radix;
        int result2 = 0;
        int currOffset = start;
        while (currOffset < end) {
            int digit;
            if ((digit = Character.digit((char)(this.value[currOffset++ + this.offset] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            if (max2 > result2) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            int next2 = result2 * radix - digit;
            if (next2 > result2) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            result2 = next2;
        }
        if (!negative && (result2 = -result2) < 0) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return result2;
    }

    public long parseLong() {
        return this.parseLong(0, this.length(), 10);
    }

    public long parseLong(int radix) {
        return this.parseLong(0, this.length(), radix);
    }

    public long parseLong(int start, int end) {
        return this.parseLong(start, end, 10);
    }

    public long parseLong(int start, int end, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = start;
        boolean bl = negative = this.byteAt(i) == 45;
        if (negative && ++i == end) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return this.parseLong(i, end, radix, negative);
    }

    private long parseLong(int start, int end, int radix, boolean negative) {
        long max2 = Long.MIN_VALUE / (long)radix;
        long result2 = 0L;
        int currOffset = start;
        while (currOffset < end) {
            int digit;
            if ((digit = Character.digit((char)(this.value[currOffset++ + this.offset] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            if (max2 > result2) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            long next2 = result2 * (long)radix - (long)digit;
            if (next2 > result2) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            result2 = next2;
        }
        if (!negative && (result2 = -result2) < 0L) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return result2;
    }

    public float parseFloat() {
        return this.parseFloat(0, this.length());
    }

    public float parseFloat(int start, int end) {
        return Float.parseFloat(this.toString(start, end));
    }

    public double parseDouble() {
        return this.parseDouble(0, this.length());
    }

    public double parseDouble(int start, int end) {
        return Double.parseDouble(this.toString(start, end));
    }

    public static AsciiString of(CharSequence string2) {
        return string2.getClass() == AsciiString.class ? (AsciiString)string2 : new AsciiString(string2);
    }

    public static AsciiString cached(String string2) {
        AsciiString asciiString = new AsciiString(string2);
        asciiString.string = string2;
        return asciiString;
    }

    public static int hashCode(CharSequence value2) {
        if (value2 == null) {
            return 0;
        }
        if (value2.getClass() == AsciiString.class) {
            return value2.hashCode();
        }
        return PlatformDependent.hashCodeAscii(value2);
    }

    public static boolean contains(CharSequence a, CharSequence b) {
        return AsciiString.contains(a, b, DefaultCharEqualityComparator.INSTANCE);
    }

    public static boolean containsIgnoreCase(CharSequence a, CharSequence b) {
        return AsciiString.contains(a, b, AsciiCaseInsensitiveCharEqualityComparator.INSTANCE);
    }

    public static boolean contentEqualsIgnoreCase(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.getClass() == AsciiString.class) {
            return ((AsciiString)a).contentEqualsIgnoreCase(b);
        }
        if (b.getClass() == AsciiString.class) {
            return ((AsciiString)b).contentEqualsIgnoreCase(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < a.length()) {
            if (!AsciiString.equalsIgnoreCase(a.charAt(i), b.charAt(j))) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean containsContentEqualsIgnoreCase(Collection<CharSequence> collection, CharSequence value2) {
        for (CharSequence v : collection) {
            if (!AsciiString.contentEqualsIgnoreCase(value2, v)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllContentEqualsIgnoreCase(Collection<CharSequence> a, Collection<CharSequence> b) {
        for (CharSequence v : b) {
            if (AsciiString.containsContentEqualsIgnoreCase(a, v)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.getClass() == AsciiString.class) {
            return ((AsciiString)a).contentEquals(b);
        }
        if (b.getClass() == AsciiString.class) {
            return ((AsciiString)b).contentEquals(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static AsciiString[] toAsciiStringArray(String[] jdkResult) {
        AsciiString[] res = new AsciiString[jdkResult.length];
        for (int i = 0; i < jdkResult.length; ++i) {
            res[i] = new AsciiString(jdkResult[i]);
        }
        return res;
    }

    private static boolean contains(CharSequence a, CharSequence b, CharEqualityComparator cmp) {
        if (a == null || b == null || a.length() < b.length()) {
            return false;
        }
        if (b.length() == 0) {
            return true;
        }
        int bStart = 0;
        for (int i = 0; i < a.length(); ++i) {
            if (cmp.equals(b.charAt(bStart), a.charAt(i))) {
                if (++bStart != b.length()) continue;
                return true;
            }
            if (a.length() - i < b.length()) {
                return false;
            }
            bStart = 0;
        }
        return false;
    }

    private static boolean regionMatchesCharSequences(CharSequence cs, int csStart, CharSequence string2, int start, int length2, CharEqualityComparator charEqualityComparator) {
        if (csStart < 0 || length2 > cs.length() - csStart) {
            return false;
        }
        if (start < 0 || length2 > string2.length() - start) {
            return false;
        }
        int csIndex = csStart;
        int csEnd = csIndex + length2;
        int stringIndex = start;
        while (csIndex < csEnd) {
            char c2;
            char c1;
            if (charEqualityComparator.equals(c1 = cs.charAt(csIndex++), c2 = string2.charAt(stringIndex++))) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence cs, boolean ignoreCase2, int csStart, CharSequence string2, int start, int length2) {
        if (cs == null || string2 == null) {
            return false;
        }
        if (cs instanceof String && string2 instanceof String) {
            return ((String)cs).regionMatches(ignoreCase2, csStart, (String)string2, start, length2);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).regionMatches(ignoreCase2, csStart, string2, start, length2);
        }
        return AsciiString.regionMatchesCharSequences(cs, csStart, string2, start, length2, ignoreCase2 ? GeneralCaseInsensitiveCharEqualityComparator.INSTANCE : DefaultCharEqualityComparator.INSTANCE);
    }

    public static boolean regionMatchesAscii(CharSequence cs, boolean ignoreCase2, int csStart, CharSequence string2, int start, int length2) {
        if (cs == null || string2 == null) {
            return false;
        }
        if (!ignoreCase2 && cs instanceof String && string2 instanceof String) {
            return ((String)cs).regionMatches(false, csStart, (String)string2, start, length2);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).regionMatches(ignoreCase2, csStart, string2, start, length2);
        }
        return AsciiString.regionMatchesCharSequences(cs, csStart, string2, start, length2, ignoreCase2 ? AsciiCaseInsensitiveCharEqualityComparator.INSTANCE : DefaultCharEqualityComparator.INSTANCE);
    }

    public static int indexOfIgnoreCase(CharSequence str2, CharSequence searchStr, int startPos) {
        if (str2 == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        int searchStrLen = searchStr.length();
        int endLimit = str2.length() - searchStrLen + 1;
        if (startPos > endLimit) {
            return -1;
        }
        if (searchStrLen == 0) {
            return startPos;
        }
        for (int i = startPos; i < endLimit; ++i) {
            if (!AsciiString.regionMatches(str2, true, i, searchStr, 0, searchStrLen)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCaseAscii(CharSequence str2, CharSequence searchStr, int startPos) {
        if (str2 == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        int searchStrLen = searchStr.length();
        int endLimit = str2.length() - searchStrLen + 1;
        if (startPos > endLimit) {
            return -1;
        }
        if (searchStrLen == 0) {
            return startPos;
        }
        for (int i = startPos; i < endLimit; ++i) {
            if (!AsciiString.regionMatchesAscii(str2, true, i, searchStr, 0, searchStrLen)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence cs, char searchChar, int start) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).indexOf(searchChar, start);
        }
        if (cs == null) {
            return -1;
        }
        int sz = cs.length();
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < sz; ++i) {
            if (cs.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    private static boolean equalsIgnoreCase(byte a, byte b) {
        return a == b || AsciiString.toLowerCase(a) == AsciiString.toLowerCase(b);
    }

    private static boolean equalsIgnoreCase(char a, char b) {
        return a == b || AsciiString.toLowerCase(a) == AsciiString.toLowerCase(b);
    }

    private static byte toLowerCase(byte b) {
        return AsciiString.isUpperCase(b) ? (byte)(b + 32) : b;
    }

    private static char toLowerCase(char c) {
        return AsciiString.isUpperCase(c) ? (char)(c + 32) : c;
    }

    private static byte toUpperCase(byte b) {
        return AsciiString.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    private static boolean isLowerCase(byte value2) {
        return value2 >= 97 && value2 <= 122;
    }

    public static boolean isUpperCase(byte value2) {
        return value2 >= 65 && value2 <= 90;
    }

    public static boolean isUpperCase(char value2) {
        return value2 >= 'A' && value2 <= 'Z';
    }

    public static byte c2b(char c) {
        return (byte)(c > '\u00ff' ? 63 : (int)c);
    }

    public static char b2c(byte b) {
        return (char)(b & 0xFF);
    }

    private static final class GeneralCaseInsensitiveCharEqualityComparator
    implements CharEqualityComparator {
        static final GeneralCaseInsensitiveCharEqualityComparator INSTANCE = new GeneralCaseInsensitiveCharEqualityComparator();

        private GeneralCaseInsensitiveCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return Character.toUpperCase(a) == Character.toUpperCase(b) || Character.toLowerCase(a) == Character.toLowerCase(b);
        }
    }

    private static final class AsciiCaseInsensitiveCharEqualityComparator
    implements CharEqualityComparator {
        static final AsciiCaseInsensitiveCharEqualityComparator INSTANCE = new AsciiCaseInsensitiveCharEqualityComparator();

        private AsciiCaseInsensitiveCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return AsciiString.equalsIgnoreCase(a, b);
        }
    }

    private static final class DefaultCharEqualityComparator
    implements CharEqualityComparator {
        static final DefaultCharEqualityComparator INSTANCE = new DefaultCharEqualityComparator();

        private DefaultCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return a == b;
        }
    }

    private static interface CharEqualityComparator {
        public boolean equals(char var1, char var2);
    }
}

