/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import org.neo4j.driver.internal.summary.InternalInputPosition;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.InputPosition;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.util.Function;

public class InternalNotification
implements Notification {
    public static final Function<Value, Notification> VALUE_TO_NOTIFICATION = new Function<Value, Notification>(){

        @Override
        public Notification apply(Value value2) {
            String code = value2.get("code").asString();
            String title = value2.get("title").asString();
            String description = value2.get("description").asString();
            String severity = value2.containsKey("severity") ? value2.get("severity").asString() : "N/A";
            Value posValue = value2.get("position");
            InternalInputPosition position2 = null;
            if (posValue != NullValue.NULL) {
                position2 = new InternalInputPosition(posValue.get("offset").asInt(), posValue.get("line").asInt(), posValue.get("column").asInt());
            }
            return new InternalNotification(code, title, description, severity, position2);
        }
    };
    private final String code;
    private final String title;
    private final String description;
    private final String severity;
    private final InputPosition position;

    public InternalNotification(String code, String title, String description, String severity, InputPosition position2) {
        this.code = code;
        this.title = title;
        this.description = description;
        this.severity = severity;
        this.position = position2;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public InputPosition position() {
        return this.position;
    }

    @Override
    public String severity() {
        return this.severity;
    }

    public String toString() {
        String info2 = "code=" + this.code + ", title=" + this.title + ", description=" + this.description + ", severity=" + this.severity;
        return this.position == null ? info2 : info2 + ", position={" + this.position + "}";
    }
}

