/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.driver.internal.AsValue;
import org.neo4j.driver.internal.InternalIsoDuration;
import org.neo4j.driver.internal.InternalPoint2D;
import org.neo4j.driver.internal.InternalPoint3D;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.BytesValue;
import org.neo4j.driver.internal.value.DateTimeValue;
import org.neo4j.driver.internal.value.DateValue;
import org.neo4j.driver.internal.value.DurationValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.LocalDateTimeValue;
import org.neo4j.driver.internal.value.LocalTimeValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.driver.internal.value.PointValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.internal.value.TimeValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.Entity;
import org.neo4j.driver.v1.types.IsoDuration;
import org.neo4j.driver.v1.types.MapAccessor;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Point;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.driver.v1.util.Function;

public abstract class Values {
    public static final Value EmptyMap = Values.value(Collections.emptyMap());
    public static final Value NULL = NullValue.NULL;

    private Values() {
        throw new UnsupportedOperationException();
    }

    public static Value value(Object value2) {
        if (value2 == null) {
            return NullValue.NULL;
        }
        if (value2 instanceof AsValue) {
            return ((AsValue)value2).asValue();
        }
        if (value2 instanceof Boolean) {
            return Values.value((boolean)((Boolean)value2));
        }
        if (value2 instanceof String) {
            return Values.value((String)value2);
        }
        if (value2 instanceof Character) {
            return Values.value(((Character)value2).charValue());
        }
        if (value2 instanceof Long) {
            return Values.value((long)((Long)value2));
        }
        if (value2 instanceof Short) {
            return Values.value((int)((Short)value2).shortValue());
        }
        if (value2 instanceof Byte) {
            return Values.value((int)((Byte)value2).byteValue());
        }
        if (value2 instanceof Integer) {
            return Values.value((int)((Integer)value2));
        }
        if (value2 instanceof Double) {
            return Values.value((double)((Double)value2));
        }
        if (value2 instanceof Float) {
            return Values.value((double)((Float)value2).floatValue());
        }
        if (value2 instanceof LocalDate) {
            return Values.value((LocalDate)value2);
        }
        if (value2 instanceof OffsetTime) {
            return Values.value((OffsetTime)value2);
        }
        if (value2 instanceof LocalTime) {
            return Values.value((LocalTime)value2);
        }
        if (value2 instanceof LocalDateTime) {
            return Values.value((LocalDateTime)value2);
        }
        if (value2 instanceof OffsetDateTime) {
            return Values.value((OffsetDateTime)value2);
        }
        if (value2 instanceof ZonedDateTime) {
            return Values.value((ZonedDateTime)value2);
        }
        if (value2 instanceof IsoDuration) {
            return Values.value((IsoDuration)value2);
        }
        if (value2 instanceof Period) {
            return Values.value((Period)value2);
        }
        if (value2 instanceof Duration) {
            return Values.value((Duration)value2);
        }
        if (value2 instanceof Point) {
            return Values.value((Point)value2);
        }
        if (value2 instanceof List) {
            return Values.value((List)value2);
        }
        if (value2 instanceof Map) {
            return Values.value((Map)value2);
        }
        if (value2 instanceof Iterable) {
            return Values.value((Iterable)value2);
        }
        if (value2 instanceof Iterator) {
            return Values.value((Iterator)value2);
        }
        if (value2 instanceof Stream) {
            return Values.value((Stream)value2);
        }
        if (value2 instanceof byte[]) {
            return Values.value((byte[])value2);
        }
        if (value2 instanceof boolean[]) {
            return Values.value((boolean[])value2);
        }
        if (value2 instanceof String[]) {
            return Values.value((String[])value2);
        }
        if (value2 instanceof long[]) {
            return Values.value((long[])value2);
        }
        if (value2 instanceof int[]) {
            return Values.value((int[])value2);
        }
        if (value2 instanceof double[]) {
            return Values.value((double[])value2);
        }
        if (value2 instanceof float[]) {
            return Values.value((float[])value2);
        }
        if (value2 instanceof Value[]) {
            return Values.value((Value[])value2);
        }
        if (value2 instanceof Object[]) {
            return Values.value(Arrays.asList((Object[])value2));
        }
        throw new ClientException("Unable to convert " + value2.getClass().getName() + " to Neo4j Value.");
    }

    public static Value[] values(Object ... input2) {
        Value[] values2 = new Value[input2.length];
        for (int i = 0; i < input2.length; ++i) {
            values2[i] = Values.value(input2[i]);
        }
        return values2;
    }

    public static Value value(Value ... input2) {
        int size2 = input2.length;
        Value[] values2 = new Value[size2];
        System.arraycopy(input2, 0, values2, 0, size2);
        return new ListValue(values2);
    }

    public static BytesValue value(byte ... input2) {
        return new BytesValue(input2);
    }

    public static Value value(String ... input2) {
        Value[] values2 = new StringValue[input2.length];
        for (int i = 0; i < input2.length; ++i) {
            values2[i] = new StringValue(input2[i]);
        }
        return new ListValue(values2);
    }

    public static Value value(boolean ... input2) {
        Value[] values2 = new Value[input2.length];
        for (int i = 0; i < input2.length; ++i) {
            values2[i] = Values.value(input2[i]);
        }
        return new ListValue(values2);
    }

    public static Value value(char ... input2) {
        Value[] values2 = new Value[input2.length];
        for (int i = 0; i < input2.length; ++i) {
            values2[i] = Values.value(input2[i]);
        }
        return new ListValue(values2);
    }

    public static Value value(long ... input2) {
        Value[] values2 = new Value[input2.length];
        for (int i = 0; i < input2.length; ++i) {
            values2[i] = Values.value(input2[i]);
        }
        return new ListValue(values2);
    }

    public static Value value(int ... input2) {
        Value[] values2 = new Value[input2.length];
        for (int i = 0; i < input2.length; ++i) {
            values2[i] = Values.value(input2[i]);
        }
        return new ListValue(values2);
    }

    public static Value value(double ... input2) {
        Value[] values2 = new Value[input2.length];
        for (int i = 0; i < input2.length; ++i) {
            values2[i] = Values.value(input2[i]);
        }
        return new ListValue(values2);
    }

    public static Value value(float ... input2) {
        Value[] values2 = new Value[input2.length];
        for (int i = 0; i < input2.length; ++i) {
            values2[i] = Values.value((double)input2[i]);
        }
        return new ListValue(values2);
    }

    public static Value value(List<Object> vals) {
        Value[] values2 = new Value[vals.size()];
        int i = 0;
        for (Object val : vals) {
            values2[i++] = Values.value(val);
        }
        return new ListValue(values2);
    }

    public static Value value(Iterable<Object> val) {
        return Values.value(val.iterator());
    }

    public static Value value(Iterator<Object> val) {
        ArrayList<Value> values2 = new ArrayList<Value>();
        while (val.hasNext()) {
            values2.add(Values.value(val.next()));
        }
        return new ListValue(values2.toArray(new Value[0]));
    }

    public static Value value(Stream<Object> stream) {
        Value[] values2 = (Value[])stream.map(Values::value).toArray(Value[]::new);
        return new ListValue(values2);
    }

    public static Value value(char val) {
        return new StringValue(String.valueOf(val));
    }

    public static Value value(String val) {
        return new StringValue(val);
    }

    public static Value value(long val) {
        return new IntegerValue(val);
    }

    public static Value value(int val) {
        return new IntegerValue(val);
    }

    public static Value value(double val) {
        return new FloatValue(val);
    }

    public static Value value(boolean val) {
        return BooleanValue.fromBoolean(val);
    }

    public static Value value(Map<String, Object> val) {
        HashMap<String, Value> asValues2 = Iterables.newHashMapWithSize(val.size());
        for (Map.Entry<String, Object> entry : val.entrySet()) {
            asValues2.put(entry.getKey(), Values.value(entry.getValue()));
        }
        return new MapValue(asValues2);
    }

    public static Value value(LocalDate localDate) {
        return new DateValue(localDate);
    }

    public static Value value(OffsetTime offsetTime) {
        return new TimeValue(offsetTime);
    }

    public static Value value(LocalTime localTime) {
        return new LocalTimeValue(localTime);
    }

    public static Value value(LocalDateTime localDateTime) {
        return new LocalDateTimeValue(localDateTime);
    }

    public static Value value(OffsetDateTime offsetDateTime) {
        return new DateTimeValue(offsetDateTime.toZonedDateTime());
    }

    public static Value value(ZonedDateTime zonedDateTime) {
        return new DateTimeValue(zonedDateTime);
    }

    public static Value value(Period period) {
        return Values.value(new InternalIsoDuration(period));
    }

    public static Value value(Duration duration) {
        return Values.value(new InternalIsoDuration(duration));
    }

    public static Value isoDuration(long months, long days, long seconds, int nanoseconds) {
        return Values.value(new InternalIsoDuration(months, days, seconds, nanoseconds));
    }

    private static Value value(IsoDuration duration) {
        return new DurationValue(duration);
    }

    public static Value point(int srid, double x, double y) {
        return Values.value(new InternalPoint2D(srid, x, y));
    }

    private static Value value(Point point) {
        return new PointValue(point);
    }

    public static Value point(int srid, double x, double y, double z) {
        return Values.value(new InternalPoint3D(srid, x, y, z));
    }

    public static Value parameters(Object ... keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new ClientException("Parameters function requires an even number of arguments, alternating key and value. Arguments were: " + Arrays.toString(keysAndValues) + ".");
        }
        HashMap<String, Value> map2 = Iterables.newHashMapWithSize(keysAndValues.length / 2);
        for (int i = 0; i < keysAndValues.length; i += 2) {
            Object value2 = keysAndValues[i + 1];
            Extract.assertParameter(value2);
            map2.put(keysAndValues[i].toString(), Values.value(value2));
        }
        return Values.value(map2);
    }

    public static Function<Value, Value> ofValue() {
        return val -> val;
    }

    public static Function<Value, Object> ofObject() {
        return Value::asObject;
    }

    public static Function<Value, Number> ofNumber() {
        return Value::asNumber;
    }

    public static Function<Value, String> ofString() {
        return Value::asString;
    }

    public static Function<Value, String> ofToString() {
        return Value::toString;
    }

    public static Function<Value, Integer> ofInteger() {
        return Value::asInt;
    }

    public static Function<Value, Long> ofLong() {
        return Value::asLong;
    }

    public static Function<Value, Float> ofFloat() {
        return Value::asFloat;
    }

    public static Function<Value, Double> ofDouble() {
        return Value::asDouble;
    }

    public static Function<Value, Boolean> ofBoolean() {
        return Value::asBoolean;
    }

    public static Function<Value, Map<String, Object>> ofMap() {
        return MapAccessor::asMap;
    }

    public static <T> Function<Value, Map<String, T>> ofMap(Function<Value, T> valueConverter) {
        return val -> val.asMap(valueConverter);
    }

    public static Function<Value, Entity> ofEntity() {
        return Value::asEntity;
    }

    public static Function<Value, Long> ofEntityId() {
        return val -> val.asEntity().id();
    }

    public static Function<Value, Node> ofNode() {
        return Value::asNode;
    }

    public static Function<Value, Relationship> ofRelationship() {
        return Value::asRelationship;
    }

    public static Function<Value, Path> ofPath() {
        return Value::asPath;
    }

    public static Function<Value, LocalDate> ofLocalDate() {
        return Value::asLocalDate;
    }

    public static Function<Value, OffsetTime> ofOffsetTime() {
        return Value::asOffsetTime;
    }

    public static Function<Value, LocalTime> ofLocalTime() {
        return Value::asLocalTime;
    }

    public static Function<Value, LocalDateTime> ofLocalDateTime() {
        return Value::asLocalDateTime;
    }

    public static Function<Value, OffsetDateTime> ofOffsetDateTime() {
        return Value::asOffsetDateTime;
    }

    public static Function<Value, ZonedDateTime> ofZonedDateTime() {
        return Value::asZonedDateTime;
    }

    public static Function<Value, IsoDuration> ofIsoDuration() {
        return Value::asIsoDuration;
    }

    public static Function<Value, Point> ofPoint() {
        return Value::asPoint;
    }

    public static Function<Value, List<Object>> ofList() {
        return Value::asList;
    }

    public static <T> Function<Value, List<T>> ofList(Function<Value, T> innerMap) {
        return value2 -> value2.asList(innerMap);
    }
}

