/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.SchemaDescriptorLookupSet;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;

public final class IndexMap
implements Cloneable {
    private final MutableLongObjectMap<IndexProxy> indexesById;
    private final MutableLongObjectMap<IndexBackedConstraintDescriptor> uniquenessConstraintsById;
    private final Map<SchemaDescriptor, IndexProxy> indexesByDescriptor;
    private final MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor;
    private final SchemaDescriptorLookupSet<SchemaDescriptor> descriptorsByLabelThenProperty;
    private final SchemaDescriptorLookupSet<SchemaDescriptor> descriptorsByReltypeThenProperty;
    private final SchemaDescriptorLookupSet<IndexBackedConstraintDescriptor> constraintsByLabelThenProperty;
    private final SchemaDescriptorLookupSet<IndexBackedConstraintDescriptor> constraintsByRelTypeThenProperty;

    public IndexMap() {
        this((MutableLongObjectMap<IndexProxy>)new LongObjectHashMap(), new HashMap<SchemaDescriptor, IndexProxy>(), (MutableObjectLongMap<SchemaDescriptor>)new ObjectLongHashMap(), (MutableLongObjectMap<IndexBackedConstraintDescriptor>)new LongObjectHashMap());
    }

    private IndexMap(MutableLongObjectMap<IndexProxy> indexesById, Map<SchemaDescriptor, IndexProxy> indexesByDescriptor, MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor, MutableLongObjectMap<IndexBackedConstraintDescriptor> uniquenessConstraintsById) {
        this.indexesById = indexesById;
        this.indexesByDescriptor = indexesByDescriptor;
        this.indexIdsByDescriptor = indexIdsByDescriptor;
        this.uniquenessConstraintsById = uniquenessConstraintsById;
        this.descriptorsByLabelThenProperty = new SchemaDescriptorLookupSet();
        this.descriptorsByReltypeThenProperty = new SchemaDescriptorLookupSet();
        for (SchemaDescriptor schema : indexesByDescriptor.keySet()) {
            this.addDescriptorToLookups(schema);
        }
        this.constraintsByLabelThenProperty = new SchemaDescriptorLookupSet();
        this.constraintsByRelTypeThenProperty = new SchemaDescriptorLookupSet();
        for (IndexBackedConstraintDescriptor constraint : uniquenessConstraintsById.values()) {
            this.addConstraintToLookups(constraint);
        }
    }

    public IndexProxy getIndexProxy(long indexId) {
        return (IndexProxy)this.indexesById.get(indexId);
    }

    public IndexProxy getIndexProxy(SchemaDescriptor descriptor) {
        return this.indexesByDescriptor.get(descriptor);
    }

    public long getIndexId(SchemaDescriptor descriptor) {
        return this.indexIdsByDescriptor.get((Object)descriptor);
    }

    public void putIndexProxy(IndexProxy indexProxy) {
        CapableIndexDescriptor descriptor = indexProxy.getDescriptor();
        SchemaDescriptor schema = descriptor.schema();
        this.indexesById.put(descriptor.getId(), (Object)indexProxy);
        this.indexesByDescriptor.put(schema, indexProxy);
        this.indexIdsByDescriptor.put((Object)schema, descriptor.getId());
        this.addDescriptorToLookups(schema);
    }

    IndexProxy removeIndexProxy(long indexId) {
        IndexProxy removedProxy = (IndexProxy)this.indexesById.remove(indexId);
        if (removedProxy == null) {
            return null;
        }
        SchemaDescriptor schema = removedProxy.getDescriptor().schema();
        this.indexesByDescriptor.remove(schema);
        this.selectIndexesByEntityType(schema.entityType()).remove(schema);
        return removedProxy;
    }

    void forEachIndexProxy(LongObjectProcedure<IndexProxy> consumer) {
        this.indexesById.forEachKeyValue(consumer);
    }

    Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexesById.values();
    }

    void putUniquenessConstraint(ConstraintRule rule) {
        IndexBackedConstraintDescriptor constraintDescriptor = (IndexBackedConstraintDescriptor)rule.getConstraintDescriptor();
        this.uniquenessConstraintsById.put(rule.getId(), (Object)constraintDescriptor);
        this.constraintsByLabelThenProperty.add(constraintDescriptor);
    }

    void removeUniquenessConstraint(long constraintId) {
        IndexBackedConstraintDescriptor constraint = (IndexBackedConstraintDescriptor)this.uniquenessConstraintsById.remove(constraintId);
        if (constraint != null) {
            this.selectConstraintsByEntityType(constraint.schema().entityType()).remove(constraint);
        }
    }

    private SchemaDescriptorLookupSet<IndexBackedConstraintDescriptor> selectConstraintsByEntityType(EntityType entityType) {
        switch (entityType) {
            case NODE: {
                return this.constraintsByLabelThenProperty;
            }
            case RELATIONSHIP: {
                return this.constraintsByRelTypeThenProperty;
            }
        }
        throw new IllegalArgumentException("Unknown entity type " + entityType);
    }

    private SchemaDescriptorLookupSet<SchemaDescriptor> selectIndexesByEntityType(EntityType entityType) {
        switch (entityType) {
            case NODE: {
                return this.descriptorsByLabelThenProperty;
            }
            case RELATIONSHIP: {
                return this.descriptorsByReltypeThenProperty;
            }
        }
        throw new IllegalArgumentException("Unknown entity type " + entityType);
    }

    boolean hasRelatedSchema(long[] labels2, int propertyKey, EntityType entityType) {
        return this.selectIndexesByEntityType(entityType).has(labels2, propertyKey) || this.selectConstraintsByEntityType(entityType).has(labels2, propertyKey);
    }

    boolean hasRelatedSchema(int label, EntityType entityType) {
        return this.selectIndexesByEntityType(entityType).has(label) || this.selectConstraintsByEntityType(entityType).has(label);
    }

    public Set<SchemaDescriptor> getRelatedIndexes(long[] changedEntityTokens, long[] unchangedEntityTokens, int[] sortedProperties, boolean propertyListIsComplete, EntityType entityType) {
        return this.getRelatedDescriptors(this.selectIndexesByEntityType(entityType), changedEntityTokens, unchangedEntityTokens, sortedProperties, propertyListIsComplete);
    }

    public Set<IndexBackedConstraintDescriptor> getRelatedConstraints(long[] changedEntityTokens, long[] unchangedEntityTokens, int[] sortedProperties, boolean propertyListIsComplete, EntityType entityType) {
        return this.getRelatedDescriptors(this.selectConstraintsByEntityType(entityType), changedEntityTokens, unchangedEntityTokens, sortedProperties, propertyListIsComplete);
    }

    private <T extends SchemaDescriptorSupplier> Set<T> getRelatedDescriptors(SchemaDescriptorLookupSet<T> set, long[] changedLabels, long[] unchangedLabels, int[] sortedProperties, boolean propertyListIsComplete) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet descriptors = new HashSet();
        if (propertyListIsComplete) {
            set.matchingDescriptorsForCompleteListOfProperties(descriptors, changedLabels, sortedProperties);
        } else if (sortedProperties.length == 0) {
            set.matchingDescriptors(descriptors, changedLabels);
        } else if (changedLabels.length == 0) {
            set.matchingDescriptorsForPartialListOfProperties(descriptors, unchangedLabels, sortedProperties);
        } else {
            set.matchingDescriptors(descriptors, changedLabels);
            set.matchingDescriptorsForPartialListOfProperties(descriptors, unchangedLabels, sortedProperties);
        }
        return descriptors;
    }

    public IndexMap clone() {
        return new IndexMap((MutableLongObjectMap<IndexProxy>)LongObjectHashMap.newMap(this.indexesById), this.cloneMap(this.indexesByDescriptor), (MutableObjectLongMap<SchemaDescriptor>)new ObjectLongHashMap(this.indexIdsByDescriptor), (MutableLongObjectMap<IndexBackedConstraintDescriptor>)LongObjectHashMap.newMap(this.uniquenessConstraintsById));
    }

    public Iterator<SchemaDescriptor> descriptors() {
        return this.indexesByDescriptor.keySet().iterator();
    }

    public LongIterator indexIds() {
        return this.indexesById.keySet().longIterator();
    }

    public int size() {
        return this.indexesById.size();
    }

    private <K, V> Map<K, V> cloneMap(Map<K, V> map2) {
        HashMap<K, V> shallowCopy = new HashMap<K, V>(map2.size());
        shallowCopy.putAll(map2);
        return shallowCopy;
    }

    private void addDescriptorToLookups(SchemaDescriptor schema) {
        this.selectIndexesByEntityType(schema.entityType()).add(schema);
    }

    private void addConstraintToLookups(IndexBackedConstraintDescriptor constraint) {
        this.selectConstraintsByEntityType(constraint.schema().entityType()).add(constraint);
    }

    private static Map<SchemaDescriptor, IndexProxy> indexesByDescriptor(LongObjectMap<IndexProxy> indexesById) {
        return indexesById.toMap((Function & Serializable)indexProxy -> indexProxy.getDescriptor().schema(), Functions.identity());
    }

    private static MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor(LongObjectMap<IndexProxy> indexesById) {
        ObjectLongHashMap map2 = new ObjectLongHashMap(indexesById.size());
        indexesById.forEachKeyValue((arg_0, arg_1) -> IndexMap.lambda$indexIdsByDescriptor$9c2f860d$1((MutableObjectLongMap)map2, arg_0, arg_1));
        return map2;
    }

    private static /* synthetic */ void lambda$indexIdsByDescriptor$9c2f860d$1(MutableObjectLongMap map2, long id2, IndexProxy indexProxy) {
        map2.put((Object)indexProxy.getDescriptor().schema(), id2);
    }
}

