/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

class IndexPopulationJobController {
    private final Set<IndexPopulationJob> populationJobs = Collections.newSetFromMap(new ConcurrentHashMap());
    private final JobScheduler scheduler;

    IndexPopulationJobController(JobScheduler scheduler) {
        this.scheduler = scheduler;
    }

    void stop() throws ExecutionException, InterruptedException {
        for (IndexPopulationJob job : this.populationJobs) {
            job.cancel().get();
        }
    }

    void startIndexPopulation(IndexPopulationJob job) {
        this.populationJobs.add(job);
        this.scheduler.schedule(Group.INDEX_POPULATION, new IndexPopulationJobWrapper(job, this));
    }

    void indexPopulationCompleted(IndexPopulationJob populationJob) {
        this.populationJobs.remove(populationJob);
    }

    Set<IndexPopulationJob> getPopulationJobs() {
        return this.populationJobs;
    }

    private static class IndexPopulationJobWrapper
    implements Runnable {
        private final IndexPopulationJob indexPopulationJob;
        private final IndexPopulationJobController jobController;

        IndexPopulationJobWrapper(IndexPopulationJob indexPopulationJob, IndexPopulationJobController jobController) {
            this.indexPopulationJob = indexPopulationJob;
            this.jobController = jobController;
        }

        @Override
        public void run() {
            try {
                this.indexPopulationJob.run();
            }
            finally {
                this.jobController.indexPopulationCompleted(this.indexPopulationJob);
            }
        }
    }
}

