/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaciton.monitor;

import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.impl.api.transaciton.monitor.KernelTransactionMonitor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class KernelTransactionMonitorScheduler
extends LifecycleAdapter {
    private final KernelTransactionMonitor kernelTransactionMonitor;
    private final JobScheduler scheduler;
    private final long checkIntervalMillis;
    private JobHandle monitorJobHandle;

    public KernelTransactionMonitorScheduler(KernelTransactionMonitor kernelTransactionMonitor, JobScheduler scheduler, long checkIntervalMillis) {
        this.kernelTransactionMonitor = kernelTransactionMonitor;
        this.scheduler = scheduler;
        this.checkIntervalMillis = checkIntervalMillis;
    }

    @Override
    public void start() {
        if (this.checkIntervalMillis > 0L) {
            this.monitorJobHandle = this.scheduler.scheduleRecurring(Group.TRANSACTION_TIMEOUT_MONITOR, this.kernelTransactionMonitor, this.checkIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        if (this.monitorJobHandle != null) {
            this.monitorJobHandle.cancel(true);
        }
    }
}

