/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ClockCache<K, V> {
    private final Queue<Page<V>> clock = new ConcurrentLinkedQueue<Page<V>>();
    private final Map<K, Page<V>> cache = new ConcurrentHashMap<K, Page<V>>();
    private final int maxSize;
    private final AtomicInteger currentSize = new AtomicInteger(0);
    private final String name;

    public ClockCache(String name, int size2) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (size2 <= 0) {
            throw new IllegalArgumentException(size2 + " is not > 0");
        }
        this.name = name;
        this.maxSize = size2;
    }

    public void put(K key, V value2) {
        if (key == null) {
            throw new IllegalArgumentException("null key not allowed");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("null value not allowed");
        }
        Page<Object> theValue = this.cache.get(key);
        if (theValue == null) {
            theValue = new Page();
            this.cache.put(key, theValue);
            this.clock.offer(theValue);
        }
        if (theValue.value == null) {
            this.currentSize.incrementAndGet();
        }
        theValue.flag = true;
        theValue.value = value2;
        this.checkSize();
    }

    public V get(K key) {
        if (key == null) {
            throw new IllegalArgumentException("cannot get null key");
        }
        Page<V> theElement = this.cache.get(key);
        if (theElement == null || theElement.value == null) {
            return null;
        }
        theElement.flag = true;
        return (V)theElement.value;
    }

    private void checkSize() {
        while (this.currentSize.get() > this.maxSize) {
            this.evict();
        }
    }

    private void evict() {
        Page<V> theElement = null;
        while ((theElement = this.clock.poll()) != null) {
            try {
                if (theElement.flag) {
                    theElement.flag = false;
                    continue;
                }
                Object valueCleaned = theElement.value;
                this.elementCleaned(valueCleaned);
                theElement.value = null;
                this.currentSize.decrementAndGet();
                return;
            }
            finally {
                this.clock.offer(theElement);
            }
        }
    }

    protected void elementCleaned(V element) {
    }

    public Collection<V> values() {
        HashSet toReturn = new HashSet();
        for (Page<V> page : this.cache.values()) {
            if (page.value == null) continue;
            toReturn.add(page.value);
        }
        return toReturn;
    }

    public V remove(K key) {
        if (key == null) {
            throw new IllegalArgumentException("cannot remove null key");
        }
        Page<V> toRemove = this.cache.remove(key);
        if (toRemove == null || toRemove.value == null) {
            return null;
        }
        this.currentSize.decrementAndGet();
        Object toReturn = toRemove.value;
        toRemove.value = null;
        toRemove.flag = false;
        return (V)toReturn;
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.cache.clear();
        this.clock.clear();
        this.currentSize.set(0);
    }

    public int size() {
        return this.currentSize.get();
    }

    private static class Page<E> {
        volatile boolean flag = true;
        volatile E value;

        private Page() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Page)) {
                return false;
            }
            Page other2 = (Page)obj;
            if (this.value == null) {
                return other2.value == null;
            }
            return this.value.equals(other2.value);
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }
    }
}

