/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class IndexConfigStore
extends LifecycleAdapter {
    public static final String INDEX_DB_FILE_NAME = "index.db";
    private static final String OLD_INDEX_DB_FILE_NAME = "index.db.old";
    private static final String TMP_INDEX_DB_FILE_NAME = "index.db.tmp";
    private static final byte[] MAGIC = new byte[]{110, 101, 111, 52, 106, 45, 105, 110, 100, 101, 120};
    private static final int VERSION = 1;
    private final File file;
    private final File oldFile;
    private final Map<String, Map<String, String>> nodeConfig = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> relConfig = new ConcurrentHashMap<String, Map<String, String>>();
    private final DatabaseLayout dbDirectoryStructure;
    private final FileSystemAbstraction fileSystem;
    private ByteBuffer dontUseBuffer = ByteBuffer.allocate(100);

    public IndexConfigStore(DatabaseLayout dbDirectoryStructure, FileSystemAbstraction fileSystem) {
        this.dbDirectoryStructure = dbDirectoryStructure;
        this.fileSystem = fileSystem;
        this.file = dbDirectoryStructure.file(INDEX_DB_FILE_NAME);
        this.oldFile = dbDirectoryStructure.file(OLD_INDEX_DB_FILE_NAME);
    }

    private ByteBuffer buffer(int size2) {
        if (this.dontUseBuffer.capacity() < size2) {
            this.dontUseBuffer = ByteBuffer.allocate(size2 * 2);
        }
        return this.dontUseBuffer;
    }

    private void read() {
        File fileToReadFrom;
        File file = fileToReadFrom = this.fileSystem.fileExists(this.file) ? this.file : this.oldFile;
        if (!this.fileSystem.fileExists(fileToReadFrom)) {
            return;
        }
        StoreChannel channel = null;
        try {
            channel = this.fileSystem.open(fileToReadFrom, OpenMode.READ);
            Integer version = this.tryToReadVersion((ReadableByteChannel)channel);
            if (version == null) {
                this.close(channel);
                channel = this.fileSystem.open(fileToReadFrom, OpenMode.READ);
                this.readMap(channel, this.nodeConfig, null);
                this.relConfig.putAll(this.nodeConfig);
            } else {
                if (version < 1) {
                    throw new UnsupportedOperationException("" + version);
                }
                this.readMap(channel, this.nodeConfig, this.readNextInt((ReadableByteChannel)channel));
                this.readMap(channel, this.relConfig, this.readNextInt((ReadableByteChannel)channel));
            }
            this.close(channel);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.close(channel);
                throw throwable;
            }
        }
    }

    @Override
    public void init() {
        this.read();
    }

    @Override
    public void start() {
        this.nodeConfig.clear();
        this.relConfig.clear();
        this.read();
    }

    private void readMap(StoreChannel channel, Map<String, Map<String, String>> map2, Integer sizeOrTillEof) throws IOException {
        Integer propertyCount;
        String indexName;
        for (int i = 0; (sizeOrTillEof == null || i < sizeOrTillEof) && (indexName = this.readNextString((ReadableByteChannel)channel)) != null && (propertyCount = this.readNextInt((ReadableByteChannel)channel)) != null; ++i) {
            String value2;
            String key;
            HashMap<String, String> properties = new HashMap<String, String>();
            for (int p = 0; p < propertyCount && (key = this.readNextString((ReadableByteChannel)channel)) != null && (value2 = this.readNextString((ReadableByteChannel)channel)) != null; ++p) {
                properties.put(key, value2);
            }
            map2.put(indexName, properties);
        }
    }

    private Integer tryToReadVersion(ReadableByteChannel channel) throws IOException {
        byte[] array = IoPrimitiveUtils.readBytes(channel, new byte[MAGIC.length]);
        if (!Arrays.equals(MAGIC, array)) {
            return null;
        }
        return array != null ? this.readNextInt(channel) : null;
    }

    private void close(StoreChannel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Integer readNextInt(ReadableByteChannel channel) throws IOException {
        return IoPrimitiveUtils.readInt(channel, this.buffer(4));
    }

    private String readNextString(ReadableByteChannel channel) throws IOException {
        return IoPrimitiveUtils.readLengthAndString(channel, this.buffer(100));
    }

    public boolean has(Class<? extends PropertyContainer> cls, String indexName) {
        return this.map(cls).containsKey(indexName);
    }

    public Map<String, String> get(Class<? extends PropertyContainer> cls, String indexName) {
        return this.map(cls).get(indexName);
    }

    public String[] getNames(Class<? extends PropertyContainer> cls) {
        Map<String, Map<String, String>> indexMap = this.map(cls);
        return indexMap.keySet().toArray(new String[indexMap.size()]);
    }

    private Map<String, Map<String, String>> map(Class<? extends PropertyContainer> cls) {
        if (cls.equals(Node.class)) {
            return this.nodeConfig;
        }
        if (cls.equals(Relationship.class)) {
            return this.relConfig;
        }
        throw new IllegalArgumentException(cls.toString());
    }

    public synchronized void remove(Class<? extends PropertyContainer> cls, String indexName) {
        if (this.map(cls).remove(indexName) == null) {
            throw new RuntimeException("Index config for '" + indexName + "' not found");
        }
        this.write();
    }

    public synchronized void set(Class<? extends PropertyContainer> cls, String name, Map<String, String> config) {
        this.map(cls).put(name, Collections.unmodifiableMap(config));
        this.write();
    }

    public synchronized boolean setIfNecessary(Class<? extends PropertyContainer> cls, String name, Map<String, String> config) {
        Map<String, Map<String, String>> map2 = this.map(cls);
        if (map2.containsKey(name)) {
            return false;
        }
        map2.put(name, Collections.unmodifiableMap(config));
        this.write();
        return true;
    }

    private void write() {
        File tmpFile = this.dbDirectoryStructure.file(TMP_INDEX_DB_FILE_NAME);
        this.write(tmpFile);
        this.fileSystem.deleteFile(this.oldFile);
        try {
            if (this.fileSystem.fileExists(this.file)) {
                this.fileSystem.renameFile(this.file, this.oldFile, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't rename " + this.file + " -> " + this.oldFile, e);
        }
        try {
            this.fileSystem.renameFile(tmpFile, this.file, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't rename " + tmpFile + " -> " + this.file, e);
        }
        this.fileSystem.deleteFile(this.oldFile);
    }

    private void write(File file) {
        StoreChannel channel = null;
        try {
            channel = this.fileSystem.open(file, OpenMode.READ_WRITE);
            channel.writeAll(ByteBuffer.wrap(MAGIC));
            IoPrimitiveUtils.writeInt(channel, this.buffer(4), 1);
            this.writeMap(channel, this.nodeConfig);
            this.writeMap(channel, this.relConfig);
            channel.force(false);
            this.close(channel);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.close(channel);
                throw throwable;
            }
        }
    }

    private void writeMap(StoreChannel channel, Map<String, Map<String, String>> map2) throws IOException {
        IoPrimitiveUtils.writeInt(channel, this.buffer(4), map2.size());
        for (Map.Entry<String, Map<String, String>> entry : map2.entrySet()) {
            this.writeString(channel, entry.getKey());
            this.writeInt(channel, entry.getValue().size());
            for (Map.Entry<String, String> propertyEntry : entry.getValue().entrySet()) {
                this.writeString(channel, propertyEntry.getKey());
                this.writeString(channel, propertyEntry.getValue());
            }
        }
    }

    private void writeInt(StoreChannel channel, int value2) throws IOException {
        IoPrimitiveUtils.writeInt(channel, this.buffer(4), value2);
    }

    private void writeString(StoreChannel channel, String value2) throws IOException {
        IoPrimitiveUtils.writeLengthAndString(channel, this.buffer(200), value2);
    }
}

